/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.wast;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.LargeFile26MTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class SuperLongText {
    private static String result;
    static ObjectMapper mapper;

    public void fastjson(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((String)result, Map.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)result, Map.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseBigDecimalForDoubles}));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(result, Map.class));
    }

    @Benchmark
    public void wastjson(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)result, Map.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(SuperLongText.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MINUTES).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try (InputStream fis = LargeFile26MTest.class.getClassLoader().getResourceAsStream("data/citylots.json.zip");
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zipIn = new ZipInputStream(bis);){
            zipIn.getNextEntry();
            result = IOUtils.toString((InputStream)zipIn, (String)"UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

