/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class DecimalUtils {
    static final long[] POWER_TEN = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    public static final short[] PACKED_DIGITS = new short[]{12336, 12592, 12848, 13104, 13360, 13616, 13872, 14128, 14384, 14640, 12337, 12593, 12849, 13105, 13361, 13617, 13873, 14129, 14385, 14641, 12338, 12594, 12850, 13106, 13362, 13618, 13874, 14130, 14386, 14642, 12339, 12595, 12851, 13107, 13363, 13619, 13875, 14131, 14387, 14643, 12340, 12596, 12852, 13108, 13364, 13620, 13876, 14132, 14388, 14644, 12341, 12597, 12853, 13109, 13365, 13621, 13877, 14133, 14389, 14645, 12342, 12598, 12854, 13110, 13366, 13622, 13878, 14134, 14390, 14646, 12343, 12599, 12855, 13111, 13367, 13623, 13879, 14135, 14391, 14647, 12344, 12600, 12856, 13112, 13368, 13624, 13880, 14136, 14392, 14648, 12345, 12601, 12857, 13113, 13369, 13625, 13881, 14137, 14393, 14649};

    public static String toString(long unscaledVal, int scale) {
        byte[] buf;
        if (scale == 0) {
            return Long.toString(unscaledVal);
        }
        boolean negative = false;
        if (unscaledVal < 0L) {
            unscaledVal = -unscaledVal;
            negative = true;
        }
        int size = DecimalUtils.stringSize(unscaledVal);
        int off = 0;
        if (scale < 0) {
            buf = new byte[size - scale + (negative ? 1 : 0)];
            if (negative) {
                buf[0] = 45;
                off = 1;
            }
            DecimalUtils.getChars(unscaledVal, off + size, buf);
            Arrays.fill(buf, off + size, buf.length, (byte)48);
        } else {
            int insertionPoint = size - scale;
            if (insertionPoint <= 0) {
                buf = new byte[size + 2 - insertionPoint + (negative ? 1 : 0)];
                if (negative) {
                    buf[0] = 45;
                    off = 1;
                }
                buf[off] = 48;
                buf[off + 1] = 46;
                for (int i = 0; i < -insertionPoint; ++i) {
                    buf[off + i + 2] = 48;
                }
                DecimalUtils.getChars(unscaledVal, buf.length, buf);
            } else {
                long power = POWER_TEN[scale - 1];
                long div = unscaledVal / power;
                long rem = unscaledVal - div * power;
                int divSize = size - scale;
                buf = new byte[size + (negative ? 2 : 1)];
                if (negative) {
                    buf[0] = 45;
                    off = 1;
                }
                DecimalUtils.getChars(div, off + divSize, buf);
                buf[divSize + off] = 46;
                DecimalUtils.getChars(rem, buf.length, buf);
            }
        }
        return new String(buf);
    }

    public static String toString(BigInteger unscaledVal, int scale) {
        byte[] buf;
        if (scale == 0) {
            return unscaledVal.toString(10);
        }
        boolean negative = false;
        if (unscaledVal.signum() < 0) {
            negative = true;
            unscaledVal = unscaledVal.negate();
        }
        String unscaledValString = unscaledVal.toString(10);
        int size = unscaledValString.length();
        int off = 0;
        if (scale < 0) {
            buf = new byte[size - scale + (negative ? 1 : 0)];
            if (negative) {
                buf[0] = 45;
                off = 1;
            }
            unscaledValString.getBytes(0, size, buf, off);
            Arrays.fill(buf, off + size, buf.length, (byte)48);
        } else {
            int insertionPoint = size - scale;
            if (insertionPoint <= 0) {
                buf = new byte[size + 2 - insertionPoint + (negative ? 1 : 0)];
                if (negative) {
                    buf[0] = 45;
                    off = 1;
                }
                buf[off] = 48;
                buf[off + 1] = 46;
                off += 2;
                for (int i = 0; i < -insertionPoint; ++i) {
                    buf[off++] = 48;
                }
                unscaledValString.getBytes(0, size, buf, off);
            } else {
                buf = new byte[size + (negative ? 2 : 1)];
                if (negative) {
                    buf[0] = 45;
                    off = 1;
                }
                unscaledValString.getBytes(0, insertionPoint, buf, off);
                buf[off += insertionPoint] = 46;
                unscaledValString.getBytes(insertionPoint, size, buf, off + 1);
            }
        }
        return new String(buf);
    }

    static String layout(long intCompact, int scale, boolean sci) {
        byte[] buf;
        block25: {
            long adjusted;
            block27: {
                int adjustedSize;
                int sig;
                int off;
                int coeffLen;
                long unscaledVal;
                boolean negative;
                block28: {
                    block26: {
                        block24: {
                            if (scale == 0) {
                                return Long.toString(intCompact);
                            }
                            negative = false;
                            if (intCompact < 0L) {
                                unscaledVal = -intCompact;
                                negative = true;
                            } else {
                                unscaledVal = intCompact;
                            }
                            coeffLen = DecimalUtils.stringSize(unscaledVal);
                            adjusted = -((long)scale) + (long)(coeffLen - 1);
                            off = 0;
                            if (scale < 0 || adjusted < -6L) break block24;
                            int pad = scale - coeffLen;
                            if (pad >= 0) {
                                buf = new byte[coeffLen + 2 + pad + (negative ? 1 : 0)];
                                if (negative) {
                                    buf[0] = 45;
                                    off = 1;
                                }
                                buf[off] = 48;
                                buf[off + 1] = 46;
                                off += 2;
                                for (int i = 0; i < pad; ++i) {
                                    buf[off++] = 48;
                                }
                                DecimalUtils.getChars(unscaledVal, buf.length, buf);
                            } else {
                                buf = new byte[coeffLen + 1 + (negative ? 1 : 0)];
                                if (negative) {
                                    buf[0] = 45;
                                    off = 1;
                                }
                                long power = POWER_TEN[scale - 1];
                                long div = unscaledVal / power;
                                long rem = unscaledVal - div * power;
                                DecimalUtils.getChars(div, off + coeffLen - scale, buf);
                                buf[off + coeffLen - scale] = 46;
                                DecimalUtils.getChars(rem, off + coeffLen + 1, buf);
                            }
                            break block25;
                        }
                        if (!sci) break block26;
                        if (coeffLen > 1) {
                            int adjustedSize2 = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[coeffLen + adjustedSize2 + 1 + (negative ? 1 : 0)];
                            if (negative) {
                                buf[0] = 45;
                                off = 1;
                            }
                            long power = POWER_TEN[coeffLen - 2];
                            long div = unscaledVal / power;
                            long rem = unscaledVal - div * power;
                            buf[off] = (byte)(div + 48L);
                            buf[off + 1] = 46;
                            DecimalUtils.getChars(rem, off + coeffLen + 1, buf);
                            off += coeffLen + 1;
                        } else {
                            int adjustedSize3 = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize3 + (negative ? 2 : 1)];
                            if (negative) {
                                buf[0] = 45;
                                off = 1;
                            }
                            buf[off++] = (byte)(unscaledVal + 48L);
                        }
                        break block27;
                    }
                    sig = (int)(adjusted % 3L);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    ++sig;
                    int n = adjustedSize = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                    if (unscaledVal != 0L) break block28;
                    switch (sig) {
                        case 1: {
                            buf = new byte[adjustedSize + 1];
                            buf[0] = 48;
                            off = 1;
                            break block27;
                        }
                        case 2: {
                            adjustedSize = (adjusted += 3L) != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize + 4];
                            buf[0] = 48;
                            buf[1] = 46;
                            buf[2] = 48;
                            buf[3] = 48;
                            off = 4;
                            break block27;
                        }
                        case 3: {
                            adjustedSize = (adjusted += 3L) != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize + 3];
                            buf[0] = 48;
                            buf[1] = 46;
                            buf[2] = 48;
                            off = 3;
                            break block27;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + sig));
                        }
                    }
                }
                if (sig >= coeffLen) {
                    buf = new byte[adjustedSize + (negative ? 2 : 1) + sig - coeffLen];
                    if (negative) {
                        buf[0] = 45;
                        off = 1;
                    }
                    DecimalUtils.getChars(unscaledVal, off + coeffLen, buf);
                    off += coeffLen;
                    for (int i = sig - coeffLen; i > 0; --i) {
                        buf[off++] = 48;
                    }
                } else {
                    buf = new byte[adjustedSize + (negative ? 2 : 1) + coeffLen];
                    if (negative) {
                        buf[0] = 45;
                        off = 1;
                    }
                    long power = POWER_TEN[coeffLen - sig - 1];
                    long div = unscaledVal / power;
                    long rem = unscaledVal - div * power;
                    DecimalUtils.getChars(div, off + sig, buf);
                    buf[off + sig] = 46;
                    DecimalUtils.getChars(rem, off + coeffLen + 1, buf);
                    off += coeffLen + 1;
                }
            }
            if (adjusted != 0L) {
                buf[off] = 69;
                buf[off + 1] = (byte)(adjusted > 0L ? 43 : 45);
                DecimalUtils.getChars(Math.abs(adjusted), buf.length, buf);
            }
        }
        return new String(buf);
    }

    static String layout(BigInteger intVal, int scale, boolean sci) {
        byte[] buf;
        block25: {
            long adjusted;
            block27: {
                int adjustedSize;
                int sig;
                int coeffLen;
                byte[] coeff;
                int off;
                boolean negative;
                block28: {
                    int signum;
                    block26: {
                        block24: {
                            BigInteger unscaledVal;
                            if (scale == 0) {
                                return intVal.toString();
                            }
                            negative = false;
                            signum = intVal.signum();
                            if (signum < 0) {
                                unscaledVal = intVal.negate();
                                negative = true;
                            } else {
                                unscaledVal = intVal;
                            }
                            off = 0;
                            String unscaledValString = unscaledVal.toString(10);
                            coeff = unscaledValString.getBytes(StandardCharsets.ISO_8859_1);
                            coeffLen = coeff.length;
                            adjusted = -((long)scale) + (long)(coeffLen - 1);
                            if (scale < 0 || adjusted < -6L) break block24;
                            int pad = scale - coeffLen;
                            if (pad >= 0) {
                                buf = new byte[coeffLen + 2 + pad + (negative ? 1 : 0)];
                                if (negative) {
                                    buf[0] = 45;
                                    off = 1;
                                }
                                buf[off] = 48;
                                buf[off + 1] = 46;
                                off += 2;
                                for (int i = 0; i < pad; ++i) {
                                    buf[off++] = 48;
                                }
                                System.arraycopy(coeff, 0, buf, off, coeffLen);
                            } else {
                                buf = new byte[coeffLen + 1 + (negative ? 1 : 0)];
                                if (negative) {
                                    buf[0] = 45;
                                    off = 1;
                                }
                                System.arraycopy(coeff, 0, buf, off, -pad);
                                buf[off - pad] = 46;
                                System.arraycopy(coeff, -pad, buf, off - pad + 1, scale);
                            }
                            break block25;
                        }
                        if (!sci) break block26;
                        if (coeffLen > 1) {
                            int adjustedSize2 = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[coeffLen + adjustedSize2 + 1 + (negative ? 1 : 0)];
                            if (negative) {
                                buf[0] = 45;
                                off = 1;
                            }
                            buf[off] = coeff[0];
                            buf[off + 1] = 46;
                            System.arraycopy(coeff, 1, buf, off + 2, coeffLen - 1);
                            off += coeffLen + 1;
                        } else {
                            int adjustedSize3 = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize3 + (negative ? 2 : 1)];
                            if (negative) {
                                buf[0] = 45;
                                off = 1;
                            }
                            buf[off++] = coeff[0];
                        }
                        break block27;
                    }
                    sig = (int)(adjusted % 3L);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    ++sig;
                    int n = adjustedSize = adjusted != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                    if (signum != 0) break block28;
                    switch (sig) {
                        case 1: {
                            buf = new byte[adjustedSize + 1];
                            buf[0] = 48;
                            off = 1;
                            break block27;
                        }
                        case 2: {
                            adjustedSize = (adjusted += 3L) != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize + 4];
                            buf[0] = 48;
                            buf[1] = 46;
                            buf[2] = 48;
                            buf[3] = 48;
                            off = 4;
                            break block27;
                        }
                        case 3: {
                            adjustedSize = (adjusted += 3L) != 0L ? DecimalUtils.stringSize(Math.abs(adjusted)) + 2 : 0;
                            buf = new byte[adjustedSize + 3];
                            buf[0] = 48;
                            buf[1] = 46;
                            buf[2] = 48;
                            off = 3;
                            break block27;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + sig));
                        }
                    }
                }
                if (sig >= coeffLen) {
                    buf = new byte[adjustedSize + (negative ? 2 : 1) + sig - coeffLen];
                    if (negative) {
                        buf[0] = 45;
                        off = 1;
                    }
                    System.arraycopy(coeff, 0, buf, off, coeffLen);
                    off += coeffLen;
                    for (int i = sig - coeffLen; i > 0; --i) {
                        buf[off++] = 48;
                    }
                } else {
                    buf = new byte[adjustedSize + (negative ? 2 : 1) + coeffLen];
                    if (negative) {
                        buf[0] = 45;
                        off = 1;
                    }
                    System.arraycopy(coeff, 0, buf, off, sig);
                    buf[off + sig] = 46;
                    System.arraycopy(coeff, sig, buf, off + sig + 1, coeffLen - sig);
                    off += coeffLen + 1;
                }
            }
            if (adjusted != 0L) {
                buf[off] = 69;
                buf[off + 1] = (byte)(adjusted > 0L ? 43 : 45);
                DecimalUtils.getChars(Math.abs(adjusted), buf.length, buf);
            }
        }
        return new String(buf);
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    static void getChars(long i, int index, byte[] buf) {
        short v;
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            short v2 = PACKED_DIGITS[(int)(i - q * 100L)];
            buf[--charPos] = (byte)(v2 >> 8);
            buf[--charPos] = (byte)v2;
            i = q;
        }
        int i2 = (int)i;
        while (i2 >= 100) {
            int q2 = i2 / 100;
            v = PACKED_DIGITS[i2 - q2 * 100];
            buf[--charPos] = (byte)(v >> 8);
            buf[--charPos] = (byte)v;
            i2 = q2;
        }
        if (i2 > 9) {
            v = PACKED_DIGITS[i2];
            buf[--charPos] = (byte)(v >> 8);
            buf[--charPos] = (byte)v;
        } else {
            buf[--charPos] = (byte)(48 + i2);
        }
        if (negative) {
            buf[charPos - 1] = 45;
        }
    }
}

