/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinary;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.csvreader.CsvReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

public class CSVReaderCOVID19 {
    static final String file = "csv/COVID-19_Public_Therapeutic_Locator.csv";
    static byte[] byteArray;

    @Benchmark
    public void fastjson2(Blackhole BH) throws IOException {
        CSVReader.of((InputStream)new ByteArrayInputStream(byteArray), (Type[])new Type[0]).readLineObjectAll(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    @Benchmark
    public void csvReader(Blackhole BH) throws IOException {
        CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(new ByteArrayInputStream(byteArray)));
        while (csvReader.readRecord()) {
            String[] line = csvReader.getValues();
            BH.consume((Object)line);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CSVReaderCOVID19.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).measurementTime(TimeValue.seconds((long)30L)).build();
        new Runner(options).run();
    }

    static {
        try (InputStream is = EishayParseBinary.class.getClassLoader().getResourceAsStream(file);){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            byteArray = str.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

