/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleDateFormatX
extends SimpleDateFormat {
    transient boolean format19;
    transient boolean format10;

    public SimpleDateFormatX(String pattern) {
        super(pattern);
        switch (pattern) {
            case "yyyy-MM-dd HH:mm:ss": {
                this.format19 = true;
                break;
            }
            case "yyyy-MM-dd": {
                this.format10 = true;
                break;
            }
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.format19 || this.format10) {
            this.calendar.setTime(date);
            int year = this.calendar.get(1);
            int month = this.calendar.get(2) + 1;
            int dayOfMonth = this.calendar.get(5);
            toAppendTo.append(year).append('-');
            if (month < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(month).append('-');
            if (dayOfMonth < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(dayOfMonth);
            if (this.format10) {
                return toAppendTo;
            }
            int hour = this.calendar.get(11);
            int minute = this.calendar.get(12);
            int second = this.calendar.get(13);
            toAppendTo.append(' ');
            if (hour < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(hour).append(':');
            if (minute < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(minute).append(':');
            if (second < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(second);
            return toAppendTo;
        }
        return super.format(date, toAppendTo, pos);
    }

    @Override
    public Date parse(String text) throws ParseException {
        if (text != null) {
            int textLength = text.length();
            if (this.format10 && textLength == 10 || this.format19 && textLength == 19) {
                char c0 = text.charAt(0);
                char c1 = text.charAt(1);
                char c2 = text.charAt(2);
                char c3 = text.charAt(3);
                char c4 = text.charAt(4);
                char c5 = text.charAt(5);
                char c6 = text.charAt(6);
                char c7 = text.charAt(7);
                char c8 = text.charAt(8);
                char c9 = text.charAt(9);
                if (c0 < '0' || c0 > '9' || c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || c3 < '0' || c3 > '9' || c4 != '-' || c5 < '0' || c5 > '9' || c6 < '0' || c6 > '9' || c7 != '-' || c8 < '0' || c8 > '9' || c9 < '0' || c9 > '9') {
                    return super.parse(text);
                }
                int year = (c0 - 48) * 1000 + (c1 - 48) * 100 + (c2 - 48) * 10 + (c3 - 48);
                int month = (c5 - 48) * 10 + (c6 - 48);
                int dayOfMonth = (c8 - 48) * 10 + (c9 - 48);
                int dom = 31;
                switch (month) {
                    case 2: {
                        boolean isLeapYear = (year & 0xF) == 0 ? (year & 3) == 0 : (year & 3) == 0 && year % 100 != 0;
                        dom = isLeapYear ? 29 : 28;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        dom = 30;
                    }
                }
                if (year >= -999999999 && year <= 999999999 && month >= 1 && month <= 12 && dayOfMonth >= 1 && dayOfMonth <= dom) {
                    this.calendar.set(1, year);
                    this.calendar.set(2, month - 1);
                    this.calendar.set(5, dayOfMonth);
                    if (this.format10) {
                        this.calendar.set(11, 0);
                        this.calendar.set(12, 0);
                        this.calendar.set(13, 0);
                        this.calendar.set(14, 0);
                        return this.calendar.getTime();
                    }
                } else {
                    return super.parse(text);
                }
                char c10 = text.charAt(10);
                char c11 = text.charAt(11);
                char c12 = text.charAt(12);
                char c13 = text.charAt(13);
                char c14 = text.charAt(14);
                char c15 = text.charAt(15);
                char c16 = text.charAt(16);
                char c17 = text.charAt(17);
                char c18 = text.charAt(18);
                if (c10 == ' ' && c11 >= '0' && c11 <= '9' && c12 >= '0' && c12 <= '9' && c13 == ':' && c14 >= '0' && c14 <= '9' && c15 >= '0' && c15 <= '9' && c16 == ':' && c17 >= '0' && c17 <= '9' && c18 >= '0' && c18 <= '9') {
                    int hour = (c11 - 48) * 10 + (c12 - 48);
                    int minute = (c14 - 48) * 10 + (c15 - 48);
                    int second = (c17 - 48) * 10 + (c18 - 48);
                    if (hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59 && second >= 0 && second <= 59) {
                        this.calendar.set(11, hour);
                        this.calendar.set(12, minute);
                        this.calendar.set(13, second);
                        this.calendar.set(14, 0);
                        return this.calendar.getTime();
                    }
                } else {
                    return super.parse(text);
                }
            }
        }
        return super.parse(text);
    }
}

