/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.sonic;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.io.Serializable;
import java.util.List;

public class EishayTest {
    public static void main(String[] args) throws Exception {
        long millis;
        long start;
        int j;
        String str = "{\"images\": [{\n      \"height\":768,\n      \"size\":\"LARGE\",\n      \"title\":\"Javaone Keynote\",\n      \"uri\":\"http://javaone.com/keynote_large.jpg\",\n      \"width\":1024\n    }, {\n      \"height\":240,\n      \"size\":\"SMALL\",\n      \"title\":\"Javaone Keynote\",\n      \"uri\":\"http://javaone.com/keynote_small.jpg\",\n      \"width\":320\n    }\n  ],\n  \"media\": {\n    \"bitrate\":262144,\n    \"duration\":18000000,\n    \"format\":\"video/mpg4\",\n    \"height\":480,\n    \"persons\": [\n      \"Bill Gates\",\n      \"Steve Jobs\"\n    ],\n    \"player\":\"JAVA\",\n    \"size\":58982400,\n    \"title\":\"Javaone Keynote\",\n    \"uri\":\"http://javaone.com/keynote.mpg\",\n    \"width\":640\n  }\n}";
        JSONReader reader = JSONReader.of((String)str);
        reader.close();
        System.out.println("reader class : " + reader.getClass().getName());
        JSONWriter writer = JSONWriter.of();
        writer.close();
        System.out.println("writer class : " + writer.getClass().getName());
        MediaContent mediaContent = (MediaContent)JSON.parseObject((String)str, MediaContent.class);
        int LOOP_COUNT = 1000000;
        for (j = 0; j < 5; ++j) {
            start = System.currentTimeMillis();
            for (int i = 0; i < LOOP_COUNT; ++i) {
                JSON.toJSONString((Object)mediaContent);
            }
            millis = System.currentTimeMillis() - start;
            System.out.println("fastjson2 eishay toJSONString time : " + millis);
        }
        for (j = 0; j < 5; ++j) {
            start = System.currentTimeMillis();
            for (int i = 0; i < LOOP_COUNT; ++i) {
                JSON.parseObject((String)str, MediaContent.class);
            }
            millis = System.currentTimeMillis() - start;
            System.out.println("fastjson2 eishay parseObject time : " + millis);
        }
    }

    public static class Media
    implements Serializable {
        private int bitrate;
        private long duration;
        private String format;
        private int height;
        private List<String> persons;
        private Player player;
        private long size;
        private String title;
        private String uri;
        private int width;
        private String copyright;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public int getBitrate() {
            return this.bitrate;
        }

        public void setBitrate(int bitrate) {
            this.bitrate = bitrate;
        }

        public List<String> getPersons() {
            return this.persons;
        }

        public void setPersons(List<String> persons) {
            this.persons = persons;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }
    }

    public static enum Player {
        JAVA,
        FLASH;

    }

    public static class Image
    implements Serializable {
        private int height;
        private Size size;
        private String title;
        private String uri;
        private int width;

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setSize(Size size) {
            this.size = size;
        }

        public String getUri() {
            return this.uri;
        }

        public String getTitle() {
            return this.title;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Size getSize() {
            return this.size;
        }
    }

    public static enum Size {
        SMALL,
        LARGE;

    }

    public static class MediaContent
    implements Serializable {
        public Media media;
        public List<Image> images;

        public void setMedia(Media media) {
            this.media = media;
        }

        public void setImages(List<Image> images) {
            this.images = images;
        }

        public Media getMedia() {
            return this.media;
        }

        public List<Image> getImages() {
            return this.images;
        }
    }
}

