/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jsonpath;

import com.alibaba.fastjson2.JSONPath;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class JSONPathPerf {
    private static String str;

    public void perf_extract_id_test() throws Exception {
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            for (int j = 0; j < 10000000; ++j) {
                this.fastjsonReaderAuthors();
            }
            long millis = System.currentTimeMillis() - start;
            System.out.println(millis);
        }
    }

    @Benchmark
    public Object fastjsonReaderAuthors() {
        return JSONPath.extract((String)str, (String)"$.store.book[*].author");
    }

    @Benchmark
    public List<String> jaywayReadAuthors() {
        return (List)JsonPath.read((String)str, (String)"$.store.book[*].author", (Predicate[])new Predicate[0]);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(JSONPathPerf.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = JSONPathPerf.class.getClassLoader().getResourceAsStream("data/path_02.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

