/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteBinary {
    static MediaContent mc;

    @Benchmark
    public void fastjson2UTF8Bytes(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)mc));
    }

    public int jsonbSize() {
        return JSONB.toBytes((Object)mc).length;
    }

    @Benchmark
    public void jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)mc));
    }

    @Benchmark
    public void javaSerialize(Blackhole bh) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(mc);
        objectOutputStream.flush();
        bh.consume((Object)byteArrayOutputStream.toByteArray());
    }

    @Benchmark
    public void hessian(Blackhole bh) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)byteArrayOutputStream);
        hessian2Output.writeObject((Object)mc);
        hessian2Output.flush();
        bh.consume((Object)byteArrayOutputStream.toByteArray());
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteBinary.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = EishayWriteBinary.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

