/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import com.alibaba.fastjson2.benchmark.LambdaGenerator;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class InvokeFirst {
    @Benchmark
    public void genLambda(Blackhole bh) throws Throwable {
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(Bean.class);
        MethodType invokedType = MethodType.methodType(ObjIntConsumer.class);
        MethodHandle target = lookup.findVirtual(Bean.class, "setId", MethodType.methodType(Void.TYPE, Integer.TYPE));
        MethodType instantiatedMethodType = MethodType.methodType(Void.TYPE, Bean.class, Integer.TYPE);
        MethodType samMethodType = MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE);
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", invokedType, samMethodType, target, instantiatedMethodType);
        ObjIntConsumer function = callSite.getTarget().invoke();
        Bean bean = new Bean();
        function.accept(bean, 123);
        bh.consume((Object)bean);
    }

    @Benchmark
    public void genLambdaASM(Blackhole bh) throws Throwable {
        ObjIntConsumer<Bean> function = LambdaGenerator.createSetterInt(Bean.class, "setId");
        Bean bean = new Bean();
        function.accept(bean, 123);
        bh.consume((Object)bean);
    }

    @Benchmark
    public void getMethod(Blackhole bh) throws Throwable {
        Method method = Bean.class.getMethod("setId", Integer.TYPE);
        Bean bean = new Bean();
        method.invoke((Object)bean, 123);
        bh.consume((Object)bean);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(InvokeFirst.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }

    public static class Bean {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

