/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtils {
    static final long FNV1A_64_MAGIC_HASHCODE = -3750763034362895579L;
    static final long FNV1A_64_MAGIC_PRIME = 1099511628211L;
    private static boolean setAccessibleEnable = true;
    public static boolean compatibleWithJavaBean;
    public static boolean compatibleWithFieldName;
    private static volatile Class kotlin_metadata;
    private static volatile boolean kotlin_metadata_error;
    private static volatile boolean kotlin_class_klass_error;
    private static volatile Constructor kotlin_kclass_constructor;
    private static volatile Method kotlin_kclass_getConstructors;
    private static volatile Method kotlin_kfunction_getParameters;
    private static volatile Method kotlin_kparameter_getName;
    private static volatile boolean kotlin_error;
    private static volatile Map<Class, String[]> kotlinIgnores;
    private static volatile boolean kotlinIgnores_error;
    private static ConcurrentMap<String, Class<?>> mappings;
    private static Class<?> pathClass;
    private static boolean PATH_CLASS_ERROR;
    private static boolean transientClassInited;
    private static Class<? extends Annotation> transientClass;

    public static <T> T cast(Object obj, Class<T> clazz, ParserConfig config) {
        return (T)com.alibaba.fastjson2.util.TypeUtils.cast((Object)obj, clazz, (ObjectReaderProvider)config.getProvider());
    }

    public static <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal) || "NULL".equals(strVal))) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type itemType;
        Type rawTye = type.getRawType();
        if (rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof List) {
                List listObj = (List)obj;
                ArrayList<T> arrayList = new ArrayList<T>(listObj.size());
                for (int i = 0; i < listObj.size(); ++i) {
                    Object item = listObj.get(i);
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping)) : TypeUtils.cast(item, itemType, mapping);
                    arrayList.add(itemValue);
                }
                return (T)arrayList;
            }
        }
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == Collection.class || rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping)) : TypeUtils.cast(item, itemType, mapping);
                    collection.add(itemValue);
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        if (rawTye == Map.Entry.class && obj instanceof Map && ((Map)obj).size() == 1) {
            Map.Entry entry = ((Map)obj).entrySet().iterator().next();
            return (T)entry;
        }
        if (rawTye instanceof Class) {
            if (mapping == null) {
                mapping = ParserConfig.global;
            }
            throw new JSONException("TODO : " + type);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : (value instanceof BigDecimal ? ((BigDecimal)value).intValueExact() : value.intValue());
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                if (config == null) {
                    config = ParserConfig.global;
                }
                throw new JSONException("TODO");
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                if (config == null) {
                    config = ParserConfig.getGlobalInstance();
                }
                throw new JSONException("TODO");
            }
            if (clazz == Locale.class) {
                Object arg0 = map.get("language");
                Object arg1 = map.get("country");
                if (arg0 instanceof String) {
                    String language = (String)arg0;
                    if (arg1 instanceof String) {
                        String country = (String)arg1;
                        return (T)new Locale(language, country);
                    }
                    if (arg1 == null) {
                        return (T)new Locale(language);
                    }
                }
            }
            if (clazz == String.class && map instanceof JSONObject) {
                return (T)map.toString();
            }
            if (clazz == LinkedHashMap.class && map instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)map;
                Map<String, Object> innerMap = jsonObject.getInnerMap();
                if (innerMap instanceof LinkedHashMap) {
                    return (T)innerMap;
                }
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                linkedHashMap.putAll(innerMap);
            }
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(clazz);
            return (T)objectReader.createInstance(map, 0L);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    public static boolean isProxy(Class<?> clazz) {
        return com.alibaba.fastjson2.util.TypeUtils.isProxy(clazz);
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            Type superType = ((Class)type).getGenericSuperclass();
            return superType != Object.class && TypeUtils.isGenericParamType(superType);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static boolean isTransient(Method method) {
        if (method == null) {
            return false;
        }
        if (!transientClassInited) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Exception exception) {
            }
            finally {
                transientClassInited = true;
            }
        }
        if (transientClass != null) {
            Annotation annotation = TypeUtils.getAnnotation(method, transientClass);
            return annotation != null;
        }
        return false;
    }

    public static String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static long fnv1a_64_lower(String key) {
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    public static long fnv1a_64(String key) {
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    public static long fnv1a_64_extract(String key) {
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '_' || ch == '-') continue;
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    public static Long castToLong(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toLong((Object)value);
    }

    public static Integer castToInt(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toInteger((Object)value);
    }

    public static Boolean castToBoolean(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toBoolean((Object)value);
    }

    public static long longExtractValue(Number number) {
        if (number == null) {
            return 0L;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).longValueExact();
        }
        return number.longValue();
    }

    public static <A extends Annotation> A getAnnotation(Class<?> targetClass, Class<A> annotationClass) {
        int n;
        A targetAnnotation = targetClass.getAnnotation(annotationClass);
        Class mixInClass = null;
        Type type = JSON.getMixInAnnotations(targetClass);
        if (type instanceof Class) {
            mixInClass = (Class)type;
        }
        if (mixInClass != null) {
            A mixInAnnotation = mixInClass.getAnnotation(annotationClass);
            Annotation[] annotations = mixInClass.getAnnotations();
            if (mixInAnnotation == null && annotations.length > 0) {
                Annotation annotation;
                Annotation[] annotationArray = annotations;
                n = annotationArray.length;
                for (int i = 0; i < n && (mixInAnnotation = (annotation = annotationArray[i]).annotationType().getAnnotation(annotationClass)) == null; ++i) {
                }
            }
            if (mixInAnnotation != null) {
                return mixInAnnotation;
            }
        }
        Annotation[] targetClassAnnotations = targetClass.getAnnotations();
        if (targetAnnotation == null && targetClassAnnotations.length > 0) {
            Annotation annotation;
            Annotation[] annotationArray = targetClassAnnotations;
            int n2 = annotationArray.length;
            for (n = 0; n < n2 && (targetAnnotation = (annotation = annotationArray[n]).annotationType().getAnnotation(annotationClass)) == null; ++n) {
            }
        }
        return targetAnnotation;
    }

    public static <A extends Annotation> A getAnnotation(Field field, Class<A> annotationClass) {
        A targetAnnotation = field.getAnnotation(annotationClass);
        Class<?> clazz = field.getDeclaringClass();
        Class mixInClass = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            mixInClass = (Class)type;
        }
        if (mixInClass != null) {
            Field mixInField = null;
            String fieldName = field.getName();
            for (Class currClass = mixInClass; currClass != null && currClass != Object.class; currClass = currClass.getSuperclass()) {
                try {
                    mixInField = currClass.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            if (mixInField == null) {
                return targetAnnotation;
            }
            A mixInAnnotation = mixInField.getAnnotation(annotationClass);
            if (mixInAnnotation != null) {
                return mixInAnnotation;
            }
        }
        return targetAnnotation;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        A targetAnnotation = method.getAnnotation(annotationClass);
        Class<?> clazz = method.getDeclaringClass();
        Class mixInClass = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            mixInClass = (Class)type;
        }
        if (mixInClass != null) {
            Method mixInMethod = null;
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (Class currClass = mixInClass; currClass != null && currClass != Object.class; currClass = currClass.getSuperclass()) {
                try {
                    mixInMethod = currClass.getDeclaredMethod(methodName, parameterTypes);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (mixInMethod == null) {
                return targetAnnotation;
            }
            A mixInAnnotation = mixInMethod.getAnnotation(annotationClass);
            if (mixInAnnotation != null) {
                return mixInAnnotation;
            }
        }
        return targetAnnotation;
    }

    public static Double castToDouble(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toDouble((Object)value);
    }

    public static <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return (T)com.alibaba.fastjson2.util.TypeUtils.cast((Object)obj, clazz);
    }

    public static Class<?> getClass(Type type) {
        return com.alibaba.fastjson2.util.TypeUtils.getClass((Type)type);
    }

    public static BigDecimal castToBigDecimal(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toBigDecimal((Object)value);
    }

    public static Timestamp castToTimestamp(Object value) {
        return (Timestamp)com.alibaba.fastjson2.util.TypeUtils.cast((Object)value, Timestamp.class);
    }

    public static Date castToSqlDate(Object value) {
        return (Date)com.alibaba.fastjson2.util.TypeUtils.cast((Object)value, Date.class);
    }

    public static byte byteValue(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.byteValue();
        }
        return decimal.byteValueExact();
    }

    public static short shortValue(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.shortValue();
        }
        return decimal.shortValueExact();
    }

    public static int intValue(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.intValue();
        }
        return decimal.intValueExact();
    }

    public static long longValue(BigDecimal decimal) {
        if (decimal == null) {
            return 0L;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.longValue();
        }
        return decimal.longValueExact();
    }

    public static Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to char, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to char, value : " + value);
    }

    public static Short castToShort(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toShort((Object)value);
    }

    public static Byte castToByte(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toByte((Object)value);
    }

    public static Float castToFloat(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toFloat((Object)value);
    }

    public static java.util.Date castToDate(Object value) {
        return com.alibaba.fastjson2.util.TypeUtils.toDate((Object)value);
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return IOUtils.decodeBase64((String)value);
        }
        throw new JSONException("can not cast to byte[], value : " + value);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap) {
        return TypeUtils.computeGetters(clazz, aliasMap, true);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap, boolean sorted) {
        JSONType jsonType = TypeUtils.getAnnotation(clazz, JSONType.class);
        HashMap<String, Field> fieldCacheMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, fieldCacheMap);
        return TypeUtils.computeGetters(clazz, jsonType, aliasMap, fieldCacheMap, sorted, PropertyNamingStrategy.CamelCase);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, JSONType jsonType, Map<String, String> aliasMap, Map<String, Field> fieldCacheMap, boolean sorted, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        boolean kotlin = TypeUtils.isKotlin(clazz);
        Constructor[] constructors = null;
        Annotation[][] paramAnnotationArrays = null;
        Object[] paramNames = null;
        short[] paramNameMapping = null;
        Method[] methods = clazz.getMethods();
        try {
            Arrays.sort(methods, new MethodInheritanceComparator());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Method method : methods) {
            JSONField fieldAnnotation;
            String propertyName;
            String propertyName2;
            Class<?> returnType;
            String methodName = method.getName();
            int ordinal = 0;
            int serialzeFeatures = 0;
            int parserFeatures = 0;
            String label = null;
            if (Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()).equals(Void.TYPE) || method.getParameterTypes().length != 0 || returnType == ClassLoader.class || returnType == InputStream.class || returnType == Reader.class || methodName.equals("getMetaClass") && returnType.getName().equals("groovy.lang.MetaClass") || methodName.equals("getSuppressed") && method.getDeclaringClass() == Throwable.class || kotlin && TypeUtils.isKotlinIgnore(clazz, methodName)) continue;
            Boolean fieldAnnotationAndNameExists = false;
            JSONField annotation = TypeUtils.getAnnotation(method, JSONField.class);
            if (annotation == null) {
                annotation = TypeUtils.getSuperMethodAnnotation(clazz, method);
            }
            if (annotation == null && kotlin) {
                Constructor creatorConstructor;
                if (constructors == null && (creatorConstructor = TypeUtils.getKotlinConstructor(constructors = clazz.getDeclaredConstructors())) != null) {
                    paramAnnotationArrays = TypeUtils.getParameterAnnotations(creatorConstructor);
                    paramNames = TypeUtils.getKoltinConstructorParameters(clazz);
                    if (paramNames != null) {
                        Object[] paramNames_sorted = new String[paramNames.length];
                        System.arraycopy(paramNames, 0, paramNames_sorted, 0, paramNames.length);
                        Arrays.sort(paramNames_sorted);
                        paramNameMapping = new short[paramNames.length];
                        for (int p = 0; p < paramNames.length; p = (int)((short)(p + 1))) {
                            int index = Arrays.binarySearch(paramNames_sorted, paramNames[p]);
                            paramNameMapping[index] = p;
                        }
                        paramNames = paramNames_sorted;
                    }
                }
                if (paramNames != null && paramNameMapping != null && methodName.startsWith("get")) {
                    propertyName2 = TypeUtils.decapitalize(methodName.substring(3));
                    int p = Arrays.binarySearch(paramNames, propertyName2);
                    if (p < 0) {
                        for (int i = 0; i < paramNames.length; ++i) {
                            if (!propertyName2.equalsIgnoreCase((String)paramNames[i])) continue;
                            p = i;
                            break;
                        }
                    }
                    if (p >= 0) {
                        Field field;
                        void index = paramNameMapping[p];
                        Annotation[] paramAnnotations = paramAnnotationArrays[index];
                        if (paramAnnotations != null) {
                            for (Annotation paramAnnotation : paramAnnotations) {
                                if (!(paramAnnotation instanceof JSONField)) continue;
                                annotation = (JSONField)paramAnnotation;
                                break;
                            }
                        }
                        if (annotation == null && (field = ParserConfig.getFieldFromCache(propertyName2, fieldCacheMap)) != null) {
                            annotation = TypeUtils.getAnnotation(field, JSONField.class);
                        }
                    }
                }
            }
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                ordinal = annotation.ordinal();
                serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                parserFeatures = Feature.of(annotation.parseFeatures());
                if (annotation.name().length() != 0) {
                    propertyName2 = annotation.name();
                    if (aliasMap != null && (propertyName2 = aliasMap.get(propertyName2)) == null) continue;
                    FieldInfo fieldInfo = new FieldInfo(propertyName2, method, null, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, null, label);
                    fieldInfoMap.put(propertyName2, fieldInfo);
                    continue;
                }
                if (annotation.label().length() != 0) {
                    label = annotation.label();
                }
            }
            if (methodName.startsWith("get")) {
                char ch;
                if (methodName.length() < 4 || methodName.equals("getClass") || methodName.equals("getDeclaringClass") && clazz.isEnum()) continue;
                char c3 = methodName.charAt(3);
                Field field = null;
                if (Character.isUpperCase(c3) || c3 > '\u0200') {
                    propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : TypeUtils.getPropertyNameByMethodName(methodName);
                    propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 3);
                } else if (c3 == '_') {
                    propertyName = methodName.substring(3);
                    field = fieldCacheMap.get(propertyName);
                    if (field == null) {
                        String temp = propertyName;
                        propertyName = methodName.substring(4);
                        field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                        if (field == null) {
                            propertyName = temp;
                        }
                    }
                } else if (c3 == 'f') {
                    propertyName = methodName.substring(3);
                } else if (methodName.length() >= 5 && Character.isUpperCase(methodName.charAt(4))) {
                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                } else {
                    propertyName = methodName.substring(3);
                    field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                    if (field == null) continue;
                }
                boolean ignore = TypeUtils.isJSONTypeIgnore(clazz, propertyName);
                if (ignore) continue;
                if (field == null) {
                    field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                }
                if (field == null && propertyName.length() > 1 && (ch = propertyName.charAt(1)) >= 'A' && ch <= 'Z') {
                    String javaBeanCompatiblePropertyName = TypeUtils.decapitalize(methodName.substring(3));
                    field = ParserConfig.getFieldFromCache(javaBeanCompatiblePropertyName, fieldCacheMap);
                }
                fieldAnnotation = null;
                if (field != null && (fieldAnnotation = TypeUtils.getAnnotation(field, JSONField.class)) != null) {
                    if (!fieldAnnotation.serialize()) continue;
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                    if (fieldAnnotation.name().length() != 0) {
                        fieldAnnotationAndNameExists = true;
                        propertyName = fieldAnnotation.name();
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    }
                    if (fieldAnnotation.label().length() != 0) {
                        label = fieldAnnotation.label();
                    }
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                if (propertyNamingStrategy != null && !fieldAnnotationAndNameExists.booleanValue()) {
                    propertyName = propertyNamingStrategy.translate(propertyName);
                }
                FieldInfo fieldInfo = new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation, label);
                fieldInfoMap.put(propertyName, fieldInfo);
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || returnType != Boolean.TYPE && returnType != Boolean.class) continue;
            char c2 = methodName.charAt(2);
            Field field = null;
            if (Character.isUpperCase(c2)) {
                propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(2)) : Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 2);
            } else if (c2 == '_') {
                propertyName = methodName.substring(3);
                field = fieldCacheMap.get(propertyName);
                if (field == null) {
                    String temp = propertyName;
                    propertyName = methodName.substring(2);
                    field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                    if (field == null) {
                        propertyName = temp;
                    }
                }
            } else if (c2 == 'f') {
                propertyName = methodName.substring(2);
            } else {
                propertyName = methodName.substring(2);
                field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                if (field == null) continue;
            }
            boolean ignore = TypeUtils.isJSONTypeIgnore(clazz, propertyName);
            if (ignore) continue;
            if (field == null) {
                field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
            }
            if (field == null) {
                field = ParserConfig.getFieldFromCache(methodName, fieldCacheMap);
            }
            fieldAnnotation = null;
            if (field != null && (fieldAnnotation = TypeUtils.getAnnotation(field, JSONField.class)) != null) {
                if (!fieldAnnotation.serialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (fieldAnnotation.label().length() != 0) {
                    label = fieldAnnotation.label();
                }
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            if (fieldInfoMap.containsKey(propertyName)) continue;
            FieldInfo fieldInfo = new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation, label);
            fieldInfoMap.put(propertyName, fieldInfo);
        }
        Field[] fields = clazz.getFields();
        TypeUtils.computeFields(clazz, aliasMap, propertyNamingStrategy, fieldInfoMap, fields);
        return TypeUtils.getFieldInfos(clazz, sorted, fieldInfoMap);
    }

    private static void computeFields(Class<?> clazz, Map<String, String> aliasMap, PropertyNamingStrategy propertyNamingStrategy, Map<String, FieldInfo> fieldInfoMap, Field[] fields) {
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            JSONField fieldAnnotation = TypeUtils.getAnnotation(field, JSONField.class);
            int ordinal = 0;
            int serialzeFeatures = 0;
            int parserFeatures = 0;
            String propertyName = field.getName();
            String label = null;
            if (fieldAnnotation != null) {
                if (!fieldAnnotation.serialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
                if (fieldAnnotation.label().length() != 0) {
                    label = fieldAnnotation.label();
                }
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            if (fieldInfoMap.containsKey(propertyName)) continue;
            FieldInfo fieldInfo = new FieldInfo(propertyName, null, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, null, fieldAnnotation, label);
            fieldInfoMap.put(propertyName, fieldInfo);
        }
    }

    private static List<FieldInfo> getFieldInfos(Class<?> clazz, boolean sorted, Map<String, FieldInfo> fieldInfoMap) {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        String[] orders = null;
        JSONType annotation = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (annotation != null) {
            orders = annotation.orders();
        }
        if (orders != null && orders.length > 0) {
            LinkedHashMap<String, FieldInfo> map = new LinkedHashMap<String, FieldInfo>(fieldInfoMap.size());
            for (FieldInfo field : fieldInfoMap.values()) {
                map.put(field.name, field);
            }
            for (String item : orders) {
                FieldInfo field = (FieldInfo)map.get(item);
                if (field == null) continue;
                fieldInfoList.add(field);
                map.remove(item);
            }
            fieldInfoList.addAll(map.values());
        } else {
            fieldInfoList.addAll(fieldInfoMap.values());
            if (sorted) {
                Collections.sort(fieldInfoList);
            }
        }
        return fieldInfoList;
    }

    static void setAccessible(AccessibleObject obj) {
        if (!setAccessibleEnable) {
            return;
        }
        if (obj.isAccessible()) {
            return;
        }
        try {
            obj.setAccessible(true);
        }
        catch (Throwable error) {
            setAccessibleEnable = false;
        }
    }

    public static boolean isKotlin(Class clazz) {
        if (kotlin_metadata == null && !kotlin_metadata_error) {
            try {
                kotlin_metadata = Class.forName("kotlin.Metadata");
            }
            catch (Throwable e) {
                kotlin_metadata_error = true;
            }
        }
        return kotlin_metadata != null && clazz.isAnnotationPresent(kotlin_metadata);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructors) {
        return TypeUtils.getKotlinConstructor(constructors, null);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructors, String[] paramNames) {
        Constructor creatorConstructor = null;
        for (Constructor constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (paramNames != null && parameterTypes.length != paramNames.length || parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || creatorConstructor != null && creatorConstructor.getParameterTypes().length >= parameterTypes.length) continue;
            creatorConstructor = constructor;
        }
        return creatorConstructor;
    }

    public static String[] getKoltinConstructorParameters(Class clazz) {
        Class<?> class_kotlin_kclass;
        if (kotlin_kclass_constructor == null && !kotlin_class_klass_error) {
            try {
                class_kotlin_kclass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_constructor = class_kotlin_kclass.getConstructor(Class.class);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kclass_constructor == null) {
            return null;
        }
        if (kotlin_kclass_getConstructors == null && !kotlin_class_klass_error) {
            try {
                class_kotlin_kclass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_getConstructors = class_kotlin_kclass.getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kfunction_getParameters == null && !kotlin_class_klass_error) {
            try {
                Class<?> class_kotlin_kfunction = Class.forName("kotlin.reflect.KFunction");
                kotlin_kfunction_getParameters = class_kotlin_kfunction.getMethod("getParameters", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kparameter_getName == null && !kotlin_class_klass_error) {
            try {
                Class<?> class_kotlinn_kparameter = Class.forName("kotlin.reflect.KParameter");
                kotlin_kparameter_getName = class_kotlinn_kparameter.getMethod("getName", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_error) {
            return null;
        }
        try {
            Object constructor = null;
            Object kclassImpl = kotlin_kclass_constructor.newInstance(clazz);
            Iterable it = (Iterable)kotlin_kclass_getConstructors.invoke(kclassImpl, new Object[0]);
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                List parameters = (List)kotlin_kfunction_getParameters.invoke(item, new Object[0]);
                if (constructor == null || parameters.size() != 0) {
                    constructor = item;
                }
                iterator.hasNext();
            }
            if (constructor == null) {
                return null;
            }
            List parameters = (List)kotlin_kfunction_getParameters.invoke(constructor, new Object[0]);
            String[] names = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Object param = parameters.get(i);
                names[i] = (String)kotlin_kparameter_getName.invoke(param, new Object[0]);
            }
            return names;
        }
        catch (Throwable e) {
            e.printStackTrace();
            kotlin_error = true;
            return null;
        }
    }

    static boolean isKotlinIgnore(Class clazz, String methodName) {
        if (kotlinIgnores == null && !kotlinIgnores_error) {
            try {
                HashMap<Class, String[]> map = new HashMap<Class, String[]>();
                Class<?> charRangeClass = Class.forName("kotlin.ranges.CharRange");
                map.put(charRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> intRangeClass = Class.forName("kotlin.ranges.IntRange");
                map.put(intRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> longRangeClass = Class.forName("kotlin.ranges.LongRange");
                map.put(longRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> floatRangeClass = Class.forName("kotlin.ranges.ClosedFloatRange");
                map.put(floatRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> doubleRangeClass = Class.forName("kotlin.ranges.ClosedDoubleRange");
                map.put(doubleRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                kotlinIgnores = map;
            }
            catch (Throwable error) {
                kotlinIgnores_error = true;
            }
        }
        if (kotlinIgnores == null) {
            return false;
        }
        Object[] ignores = kotlinIgnores.get(clazz);
        return ignores != null && Arrays.binarySearch(ignores, methodName) >= 0;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String propertyName) {
        JSONType jsonType = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (jsonType != null) {
            String[] fields = jsonType.includes();
            if (fields.length > 0) {
                for (String field : fields) {
                    if (!propertyName.equals(field)) continue;
                    return false;
                }
                return true;
            }
            for (String field : fields = jsonType.ignores()) {
                if (!propertyName.equals(field)) continue;
                return true;
            }
        }
        if (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null) {
            return TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), propertyName);
        }
        return false;
    }

    public static JSONField getSuperMethodAnnotation(Class<?> clazz, Method method) {
        Class<?> superClass;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            Class<?>[] types = method.getParameterTypes();
            for (Class<?> interfaceClass : interfaces) {
                for (Method interfaceMethod : interfaceClass.getMethods()) {
                    JSONField annotation;
                    Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                    if (interfaceTypes.length != types.length || !interfaceMethod.getName().equals(method.getName())) continue;
                    boolean match = true;
                    for (int i = 0; i < types.length; ++i) {
                        if (interfaceTypes[i].equals(types[i])) continue;
                        match = false;
                        break;
                    }
                    if (!match || (annotation = TypeUtils.getAnnotation(interfaceMethod, JSONField.class)) == null) continue;
                    return annotation;
                }
            }
        }
        if ((superClass = clazz.getSuperclass()) == null) {
            return null;
        }
        if (Modifier.isAbstract(superClass.getModifiers())) {
            Class<?>[] types = method.getParameterTypes();
            for (Method interfaceMethod : superClass.getMethods()) {
                JSONField annotation;
                Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                if (interfaceTypes.length != types.length || !interfaceMethod.getName().equals(method.getName())) continue;
                boolean match = true;
                for (int i = 0; i < types.length; ++i) {
                    if (interfaceTypes[i].equals(types[i])) continue;
                    match = false;
                    break;
                }
                if (!match || (annotation = TypeUtils.getAnnotation(interfaceMethod, JSONField.class)) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static String getPropertyNameByCompatibleFieldName(Map<String, Field> fieldCacheMap, String methodName, String propertyName, int fromIdx) {
        if (compatibleWithFieldName && !fieldCacheMap.containsKey(propertyName)) {
            String tempPropertyName = methodName.substring(fromIdx);
            return fieldCacheMap.containsKey(tempPropertyName) ? tempPropertyName : propertyName;
        }
        return propertyName;
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String getPropertyNameByMethodName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    public static Annotation[][] getParameterAnnotations(Constructor constructor) {
        Annotation[][] targetAnnotations = constructor.getParameterAnnotations();
        Class clazz = constructor.getDeclaringClass();
        Class mixInClass = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            mixInClass = (Class)type;
        }
        if (mixInClass != null) {
            Constructor mixInConstructor = null;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            ArrayList enclosingClasses = new ArrayList(2);
            for (Class<?> enclosingClass = mixInClass.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
                enclosingClasses.add(enclosingClass);
            }
            int level = enclosingClasses.size();
            for (Class currClass = mixInClass; currClass != null && currClass != Object.class; currClass = currClass.getSuperclass()) {
                try {
                    if (level != 0) {
                        Class[] outerClassAndParameterTypes = new Class[level + parameterTypes.length];
                        System.arraycopy(parameterTypes, 0, outerClassAndParameterTypes, level, parameterTypes.length);
                        for (int i = level; i > 0; --i) {
                            outerClassAndParameterTypes[i - 1] = (Class)enclosingClasses.get(i - 1);
                        }
                        mixInConstructor = mixInClass.getDeclaredConstructor(outerClassAndParameterTypes);
                        break;
                    }
                    mixInConstructor = mixInClass.getDeclaredConstructor(parameterTypes);
                    break;
                }
                catch (NoSuchMethodException e) {
                    --level;
                    continue;
                }
            }
            if (mixInConstructor == null) {
                return targetAnnotations;
            }
            Annotation[][] mixInAnnotations = mixInConstructor.getParameterAnnotations();
            if (mixInAnnotations != null) {
                return mixInAnnotations;
            }
        }
        return targetAnnotations;
    }

    static {
        mappings = new ConcurrentHashMap(256, 0.75f, 1);
    }

    public static class MethodInheritanceComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method m1, Method m2) {
            Class<?> class2;
            int cmp = m1.getName().compareTo(m2.getName());
            if (cmp != 0) {
                return cmp;
            }
            Class<?> class1 = m1.getReturnType();
            if (class1.equals(class2 = m2.getReturnType())) {
                return 0;
            }
            if (class1.isAssignableFrom(class2)) {
                return -1;
            }
            if (class2.isAssignableFrom(class1)) {
                return 1;
            }
            return 0;
        }
    }
}

