/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.Fastjson1xReaderModule;
import com.alibaba.fastjson.Fastjson1xWriterModule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public class JSON {
    private static TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final String VERSION = "2.0.10";
    static final Cache CACHE = new Cache();
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
    public static TimeZone defaultTimeZone = DEFAULT_TIME_ZONE;
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    static final Supplier<List> arraySupplier;
    static final Supplier<Map> defaultSupplier;
    static final Supplier<Map> orderedSupplier;

    public static JSONObject parseObject(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader reader = JSONReader.of((String)str);
        JSONReader.Context context = reader.getContext();
        context.config(new JSONReader.Feature[]{JSONReader.Feature.AllowUnQuotedFieldNames});
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader reader = JSONReader.of((String)text);
        JSONReader.Context context = reader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        context.config(new JSONReader.Feature[]{JSONReader.Feature.AllowUnQuotedFieldNames});
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        JSON.config(context, features);
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(char[] str, Class<T> objectClass, Feature ... features) {
        if (str == null || str.length == 0) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of((char[])str);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, TypeReference typeReference, Feature ... features) {
        return JSON.parseObject(str, typeReference.getType(), features);
    }

    public static <T> T parseObject(String str, Class<T> objectClass) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of((String)str);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames});
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Class<T> objectType, Feature ... features) {
        String defaultDateFormat;
        if (str == null || str.isEmpty()) {
            return null;
        }
        boolean useNativeJavaObject = false;
        for (Feature feature : features) {
            if (feature != Feature.UseNativeJavaObject) continue;
            useNativeJavaObject = true;
        }
        JSONReader jsonReader = JSONReader.of((String)str);
        JSONReader.Context context = jsonReader.getContext();
        if (!useNativeJavaObject) {
            context.setArraySupplier(arraySupplier);
            context.setObjectSupplier(defaultSupplier);
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat = DEFFAULT_DATE_FORMAT)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Type objectType, Feature ... features) {
        String defaultDateFormat;
        if (str == null || str.isEmpty()) {
            return null;
        }
        boolean useNativeJavaObject = false;
        for (Feature feature : features) {
            if (feature != Feature.UseNativeJavaObject) continue;
            useNativeJavaObject = true;
        }
        JSONReader jsonReader = JSONReader.of((String)str);
        JSONReader.Context context = jsonReader.getContext();
        if (!useNativeJavaObject) {
            context.setArraySupplier(arraySupplier);
            context.setObjectSupplier(defaultSupplier);
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat = DEFFAULT_DATE_FORMAT)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(InputStream is, Type objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Class<T> objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type objectType, Feature ... features) throws IOException {
        if (is == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of((InputStream)is, (Charset)charset);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> JSONObject parseObject(byte[] jsonBytes, Feature ... features) {
        if (jsonBytes == null || jsonBytes.length == 0) {
            return null;
        }
        JSONReader reader = JSONReader.of((byte[])jsonBytes);
        JSONReader.Context context = reader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        JSON.config(context, features);
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of((byte[])jsonBytes);
        JSONReader.Context context = jsonReader.getContext();
        context.setObjectSupplier(defaultSupplier);
        context.setArraySupplier(arraySupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, SerializeFilter filter, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of((byte[])jsonBytes);
        JSONReader.Context context = jsonReader.getContext();
        context.setObjectSupplier(defaultSupplier);
        context.setArraySupplier(arraySupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        if (filter instanceof Filter) {
            context.config((Filter)filter, new JSONReader.Feature[0]);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, Feature ... features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of((String)str);){
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            JSON.config(context, features);
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    protected static void config(JSONReader.Context context, Feature[] features) {
        block13: for (Feature feature : features) {
            switch (feature) {
                case SupportArrayToBean: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
                    continue block13;
                }
                case SupportAutoType: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
                    continue block13;
                }
                case ErrorOnEnumNotMatch: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
                    continue block13;
                }
                case SupportNonPublicField: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
                    continue block13;
                }
                case SupportClassForName: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportClassForName});
                    continue block13;
                }
                case TrimStringFieldValue: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.TrimString});
                    continue block13;
                }
                case ErrorOnNotSupportAutoType: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnNotSupportAutoType});
                    continue block13;
                }
                case AllowUnQuotedFieldNames: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.AllowUnQuotedFieldNames});
                    continue block13;
                }
                case OrderedField: {
                    context.setObjectSupplier(orderedSupplier);
                    continue block13;
                }
                case UseNativeJavaObject: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.UseNativeObject});
                    continue block13;
                }
                case NonStringKeyAsString: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.NonStringKeyAsString});
                    continue block13;
                }
            }
        }
        boolean disableFieldSmartMatch = false;
        for (Feature feature : features) {
            if (feature != Feature.DisableFieldSmartMatch) continue;
            disableFieldSmartMatch = true;
            break;
        }
        if (!disableFieldSmartMatch) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch});
        }
    }

    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charBuf = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charBuf);
            int position = charBuf.position();
            JSONReader jsonReader = JSONReader.of((char[])chars, (int)0, (int)position);
            JSONReader.Context context = jsonReader.getContext();
            block9: for (Feature feature : Feature.values()) {
                if ((features & feature.mask) == 0) continue;
                switch (feature) {
                    case SupportArrayToBean: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
                        continue block9;
                    }
                    case SupportAutoType: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
                        continue block9;
                    }
                    case ErrorOnEnumNotMatch: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
                    }
                    case SupportNonPublicField: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
                    }
                }
            }
            Object object = jsonReader.read(Object.class);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charByte = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charByte);
            int position = charByte.position();
            JSONReader jsonReader = JSONReader.of((char[])chars, (int)0, (int)position);
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames});
            JSON.config(context, features);
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    public static <T> T parseObject(byte[] input, int off, int len, Charset charset, Type clazz, Feature ... features) {
        try (JSONReader jsonReader = JSONReader.of((byte[])input, (int)off, (int)len, (Charset)charset);){
            JSON.config(jsonReader.getContext(), features);
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            JSON.config(context, features);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                JSON.configFilter(context, filters);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static void configFilter(JSONWriter.Context context, SerializeFilter ... filters) {
        for (SerializeFilter filter : filters) {
            JSON.configFilter(context, filter);
        }
    }

    static void configFilter(JSONWriter.Context context, SerializeFilter filter) {
        if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
            context.setNameFilter((NameFilter)((com.alibaba.fastjson.serializer.NameFilter)filter));
        }
        if (filter instanceof ValueFilter) {
            context.setValueFilter((ValueFilter)filter);
        }
        if (filter instanceof PropertyPreFilter) {
            context.setPropertyPreFilter((PropertyPreFilter)filter);
        }
        if (filter instanceof PropertyFilter) {
            context.setPropertyFilter((PropertyFilter)filter);
        }
        if (filter instanceof BeforeFilter) {
            context.setBeforeFilter((com.alibaba.fastjson2.filter.BeforeFilter)((BeforeFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.AfterFilter) {
            context.setAfterFilter((AfterFilter)((com.alibaba.fastjson.serializer.AfterFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.LabelFilter) {
            context.setLabelFilter((LabelFilter)((com.alibaba.fastjson.serializer.LabelFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.ContextValueFilter) {
            context.setContextValueFilter((ContextValueFilter)((com.alibaba.fastjson.serializer.ContextValueFilter)filter));
        }
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            JSON.config(context, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                JSON.configFilter(context, filters);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, boolean prettyFormat) {
        Object valueClass2;
        block12: {
            JSONWriter.Context context = JSONFactory.createWriteContext((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
            if (prettyFormat) {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
            }
            context.setDateFormat("millis");
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block12;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
            context.setDateFormat("millis");
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, SerializeFilter filter0, SerializeFilter filter1, SerializeFilter ... filters) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            context.setDateFormat("millis");
            JSON.configFilter(context, filter0);
            JSON.configFilter(context, filter1);
            JSON.configFilter(context, filters);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                JSON.configFilter(context, filters);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            context.setDateFormat("millis");
            JSON.config(context, features);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
            context.setDateFormat("millis");
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter ... filters) {
        return JSON.toJSONBytes(object, filters, new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            JSON.config(context, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                writer.setRootObject(object);
                if (object == null) {
                    writer.writeNull();
                } else {
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static void config(JSONWriter.Context ctx, SerializerFeature[] features) {
        ctx.setDateFormat("millis");
        if (defaultTimeZone != null && defaultTimeZone != DEFAULT_TIME_ZONE) {
            ctx.setZoneId(defaultTimeZone.toZoneId());
        }
        boolean disableCircularReferenceDetect = false;
        for (SerializerFeature feature : features) {
            if (feature != SerializerFeature.DisableCircularReferenceDetect) continue;
            disableCircularReferenceDetect = true;
            break;
        }
        if (!disableCircularReferenceDetect) {
            ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
        }
        for (SerializerFeature feature : features) {
            JSON.config(ctx, feature);
        }
    }

    static void config(JSONWriter.Context context, SerializerFeature feature) {
        switch (feature) {
            case UseISO8601DateFormat: {
                context.setDateFormat("iso8601");
                break;
            }
            case WriteMapNullValue: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
                break;
            }
            case WriteNullListAsEmpty: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullListAsEmpty});
                break;
            }
            case WriteNullStringAsEmpty: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty});
                break;
            }
            case WriteNullNumberAsZero: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullNumberAsZero});
                break;
            }
            case WriteNullBooleanAsFalse: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullBooleanAsFalse});
                break;
            }
            case BrowserCompatible: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
                break;
            }
            case WriteClassName: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName});
                break;
            }
            case WriteNonStringValueAsString: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringValueAsString});
                break;
            }
            case WriteEnumUsingToString: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString});
                break;
            }
            case NotWriteRootClassName: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteRootClassName});
                break;
            }
            case IgnoreErrorGetter: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter});
                break;
            }
            case WriteDateUseDateFormat: {
                context.setDateFormat(DEFFAULT_DATE_FORMAT);
                break;
            }
            case BeanToArray: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
                break;
            }
            case UseSingleQuotes: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.UseSingleQuotes});
                break;
            }
            case MapSortField: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.MapSortField});
                break;
            }
            case PrettyFormat: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
                break;
            }
            case WriteNonStringKeyAsString: {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringKeyAsString});
                break;
            }
        }
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context context = writer.getContext();
            if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
                com.alibaba.fastjson.serializer.NameFilter nameFilter = com.alibaba.fastjson.serializer.NameFilter.of(config.propertyNamingStrategy);
                JSON.configFilter(context, (SerializeFilter)nameFilter);
            }
            if (config.fieldBased) {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased});
            }
            JSON.config(context, features);
            writer.writeAny(object);
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context context = writer.getContext();
            if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
                com.alibaba.fastjson.serializer.NameFilter nameFilter = com.alibaba.fastjson.serializer.NameFilter.of(config.propertyNamingStrategy);
                if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
                    filter = com.alibaba.fastjson.serializer.NameFilter.compose(nameFilter, (com.alibaba.fastjson.serializer.NameFilter)filter);
                } else {
                    JSON.configFilter(context, (SerializeFilter)nameFilter);
                }
            }
            if (config.fieldBased) {
                context.config(new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased});
            }
            JSON.configFilter(context, filter);
            JSON.config(context, features);
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, SerializeFilter filter, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            JSONWriter.Context context = jsonWriter.getContext();
            JSON.configFilter(context, filter);
            JSON.config(context, features);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            JSONWriter.Context context = jsonWriter.getContext();
            if (defaultFeatures != 0) {
                for (SerializerFeature feature : SerializerFeature.values()) {
                    if ((defaultFeatures & feature.mask) == 0) continue;
                    JSON.config(context, feature);
                }
            }
            JSON.config(context, features);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            for (SerializerFeature feature : features) {
                if (feature != SerializerFeature.WriteMapNullValue) continue;
                jsonWriter.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
            }
            JSONWriter.Context context = jsonWriter.getContext();
            context.setDateFormat(dateFormat);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, object, new SerializeFilter[0], features);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters) throws IOException {
        return JSON.writeJSONString(os, object, filters, new SerializerFeature[0]);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters, SerializerFeature ... features) throws IOException {
        int n;
        block11: {
            JSONWriter jsonWriter = JSONWriter.ofUTF8();
            try {
                JSONWriter.Context context = jsonWriter.getContext();
                jsonWriter.setRootObject(object);
                JSON.config(context, features);
                JSON.configFilter(context, filters);
                if (object == null) {
                    jsonWriter.writeNull();
                } else {
                    ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                    objectWriter.write(jsonWriter, object, null, null, 0L);
                }
                byte[] bytes = jsonWriter.getBytes();
                os.write(bytes);
                n = bytes.length;
                if (jsonWriter == null) break block11;
            }
            catch (Throwable context) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            context.addSuppressed(throwable);
                        }
                    }
                    throw context;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("writeJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("writeJSONString error", ex);
                }
            }
            jsonWriter.close();
        }
        return n;
    }

    public static JSONArray parseArray(String str, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of((String)str);){
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            JSON.config(context, features);
            if (jsonReader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray jsonArray = new JSONArray();
            jsonReader.read((List)jsonArray);
            JSONArray jSONArray = jsonArray;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        List list;
        block10: {
            if (text == null || text.isEmpty()) {
                return null;
            }
            ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, List.class);
            JSONReader reader = JSONReader.of((String)text);
            try {
                JSONReader.Context context = reader.getContext();
                context.setObjectSupplier(defaultSupplier);
                context.setArraySupplier(arraySupplier);
                context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames});
                list = (List)reader.read((Type)paramType);
                if (reader == null) break block10;
            }
            catch (Throwable context) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            context.addSuppressed(throwable);
                        }
                    }
                    throw context;
                }
                catch (com.alibaba.fastjson2.JSONException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    throw new JSONException(e.getMessage(), cause);
                }
            }
            reader.close();
        }
        return list;
    }

    public static <T> List<T> parseArray(String text, Class<T> type, Feature ... features) {
        List list;
        block10: {
            if (text == null || text.isEmpty()) {
                return null;
            }
            ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, List.class);
            JSONReader reader = JSONReader.of((String)text);
            try {
                JSONReader.Context context = reader.getContext();
                context.setObjectSupplier(defaultSupplier);
                context.setArraySupplier(arraySupplier);
                JSON.config(context, features);
                list = (List)reader.read((Type)paramType);
                if (reader == null) break block10;
            }
            catch (Throwable context) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            context.addSuppressed(throwable);
                        }
                    }
                    throw context;
                }
                catch (com.alibaba.fastjson2.JSONException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    throw new JSONException(e.getMessage(), cause);
                }
            }
            reader.close();
        }
        return list;
    }

    public static boolean isValid(String str) {
        return com.alibaba.fastjson2.JSON.isValid((String)str);
    }

    public static boolean isValidArray(String str) {
        return com.alibaba.fastjson2.JSON.isValidArray((String)str);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        if (json instanceof JSONObject) {
            return ((JSONObject)json).toJavaObject(clazz);
        }
        String str = JSON.toJSONString(json);
        return JSON.parseObject(str, clazz);
    }

    public static Object toJSON(Object javaObject) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        Object object = JSON.parse(str, new Feature[0]);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static List<Object> parseArray(String text, Type[] types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray(types.length);
        try (JSONReader reader = JSONReader.of((String)text);){
            JSONReader.Context context = reader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames});
            reader.startArray();
            for (Type itemType : types) {
                array.add(reader.read(itemType));
            }
            reader.endArray();
            reader.handleResolveTasks((Object)array);
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    static {
        arraySupplier = JSONArray::new;
        defaultSupplier = JSONObject::new;
        orderedSupplier = () -> new JSONObject(true);
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        readerProvider.register((ObjectReaderModule)new Fastjson1xReaderModule(readerProvider));
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.register((ObjectWriterModule)new Fastjson1xWriterModule(writerProvider));
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

