/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.LabelFilter;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaBeanSerializer
implements ObjectSerializer {
    private static final char[] true_chars = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] false_chars = new char[]{'f', 'a', 'l', 's', 'e'};
    private final FieldSerializer[] getters;
    protected final FieldSerializer[] sortedGetters;
    protected int features = 0;
    protected final Class<?> beanType;

    public JavaBeanSerializer(Class<?> beanType) {
        this(beanType, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> beanType, String ... aliasList) {
        this(beanType, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> beanType, Map<String, String> aliasMap) {
        this(beanType, aliasMap, TypeUtils.getSerializeFeatures(beanType));
    }

    public JavaBeanSerializer(Class<?> beanType, Map<String, String> aliasMap, int features) {
        this.features = features;
        this.beanType = beanType;
        JSONType jsonType = beanType.getAnnotation(JSONType.class);
        if (jsonType != null) {
            features = SerializerFeature.of(jsonType.serialzeFeatures());
        }
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(beanType, jsonType, aliasMap, false);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(new FieldSerializer(beanType, fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        String[] orders = null;
        if (jsonType != null) {
            orders = jsonType.orders();
        }
        if (orders != null && orders.length != 0) {
            fieldInfoList = TypeUtils.computeGetters(beanType, jsonType, aliasMap, true);
            ArrayList<FieldSerializer> getterList2 = new ArrayList<FieldSerializer>();
            for (FieldInfo fieldInfo : fieldInfoList) {
                FieldSerializer fieldDeser = new FieldSerializer(beanType, fieldInfo);
                getterList2.add(fieldDeser);
            }
            this.sortedGetters = getterList2.toArray(new FieldSerializer[getterList2.size()]);
        } else {
            Object[] sortedGetters = new FieldSerializer[this.getters.length];
            System.arraycopy(this.getters, 0, sortedGetters, 0, this.getters.length);
            Arrays.sort(sortedGetters);
            this.sortedGetters = Arrays.equals(sortedGetters, this.getters) ? this.getters : sortedGetters;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if (this.writeReference(serializer, object, features)) {
            return;
        }
        FieldSerializer[] getters = out.sortField ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.context;
        serializer.setContext(parent, object, fieldName, this.features, features);
        boolean writeAsArray = this.isWriteAsArray(serializer);
        try {
            Class<?> objClass;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char endSeperator = writeAsArray ? (char)']' : '}';
            out.append(startSeperator);
            if (getters.length > 0 && out.prettyFormat) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            if (((this.features & SerializerFeature.WriteClassName.mask) != 0 || serializer.isWriteClassName(fieldType, object)) && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY, false);
                serializer.write(object.getClass());
                commaFlag = true;
            }
            char seperator = commaFlag ? (char)',' : '\u0000';
            boolean directWritePrefix = out.quoteFieldNames && !out.useSingleQuotes;
            char newSeperator = serializer.writeBefore(object, seperator);
            commaFlag = newSeperator == ',';
            boolean skipTransient = out.skipTransientField;
            boolean ignoreNonFieldGetter = out.ignoreNonFieldGetter;
            List<LabelFilter> labelFilters = serializer.labelFilters;
            List<PropertyFilter> propertyFilters = serializer.propertyFilters;
            List<NameFilter> nameFilters = serializer.nameFilters;
            List<ValueFilter> valueFilters = serializer.valueFilters;
            List<ContextValueFilter> contextValueFilters = serializer.contextValueFilters;
            List<PropertyPreFilter> filters = serializer.propertyPreFilters;
            for (int i = 0; i < getters.length; ++i) {
                void var39_56;
                Class<?> fieldCLass;
                Iterator<ContextValueFilter> nameFilter2;
                FieldSerializer fieldSerializer = getters[i];
                Field field = fieldSerializer.fieldInfo.field;
                FieldInfo fieldInfo = fieldSerializer.fieldInfo;
                String fieldInfoName = fieldInfo.name;
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (skipTransient && field != null && fieldInfo.fieldTransient || ignoreNonFieldGetter && field == null) continue;
                boolean apply = true;
                if (filters != null) {
                    for (PropertyPreFilter filter : filters) {
                        if (filter.apply(serializer, object, fieldInfo.name)) continue;
                        apply = false;
                        break;
                    }
                }
                if (!apply) continue;
                apply = true;
                if (labelFilters != null) {
                    for (LabelFilter propertyFilter : labelFilters) {
                        if (propertyFilter.apply(fieldInfo.label)) continue;
                        apply = false;
                        break;
                    }
                }
                if (!apply) continue;
                Object propertyValue = null;
                int propertyValueInt = 0;
                long propertyValueLong = 0L;
                boolean propertyValueBoolean = false;
                boolean propertyValueGot = false;
                boolean valueGot = false;
                if (fieldInfo.fieldAccess) {
                    if (fieldClass == Integer.TYPE) {
                        propertyValueInt = fieldInfo.field.getInt(object);
                        valueGot = true;
                    } else if (fieldClass == Long.TYPE) {
                        propertyValueLong = fieldInfo.field.getLong(object);
                        valueGot = true;
                    } else if (fieldClass == Boolean.TYPE) {
                        propertyValueBoolean = fieldInfo.field.getBoolean(object);
                        valueGot = true;
                    } else {
                        propertyValue = fieldInfo.field.get(object);
                        propertyValueGot = true;
                    }
                } else {
                    propertyValue = fieldSerializer.getPropertyValue(object);
                    propertyValueGot = true;
                }
                boolean apply2 = true;
                if (propertyFilters != null) {
                    if (valueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (PropertyFilter propertyFilter : propertyFilters) {
                        if (propertyFilter.apply(object, fieldInfoName, propertyValue)) continue;
                        apply2 = false;
                        break;
                    }
                }
                if (!apply2) continue;
                String key = fieldInfoName;
                if (nameFilters != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (Iterator<ContextValueFilter> nameFilter2 : nameFilters) {
                        key = nameFilter2.process(object, key, propertyValue);
                    }
                }
                if (out.writeNonStringValueAsString) {
                    if (fieldClass == Integer.TYPE) {
                        propertyValue = Integer.toString(propertyValueInt);
                        propertyValueGot = true;
                    } else if (fieldClass == Long.TYPE) {
                        propertyValue = Long.toString(propertyValueLong);
                        propertyValueGot = true;
                    } else if (fieldClass == Boolean.TYPE) {
                        propertyValue = Boolean.toString(propertyValueBoolean);
                        propertyValueGot = true;
                    } else if (fieldClass != String.class && (propertyValue instanceof Number || propertyValue instanceof Boolean)) {
                        propertyValue = propertyValue.toString();
                    }
                }
                Object object2 = propertyValue;
                if (valueFilters != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            Object object3 = propertyValue = Integer.valueOf(propertyValueInt);
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            Object object4 = propertyValue = Long.valueOf(propertyValueLong);
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            Object object5 = propertyValue = Boolean.valueOf(propertyValueBoolean);
                            propertyValueGot = true;
                        }
                    }
                    nameFilter2 = valueFilters.iterator();
                    while (nameFilter2.hasNext()) {
                        ValueFilter valueFilter = (ValueFilter)((Object)nameFilter2.next());
                        propertyValue = valueFilter.process(object, fieldInfoName, propertyValue);
                    }
                }
                if (contextValueFilters != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            Object object6 = propertyValue = Integer.valueOf(propertyValueInt);
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            Object object7 = propertyValue = Long.valueOf(propertyValueLong);
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            Object object8 = propertyValue = Boolean.valueOf(propertyValueBoolean);
                            propertyValueGot = true;
                        }
                    }
                    nameFilter2 = contextValueFilters.iterator();
                    while (nameFilter2.hasNext()) {
                        ContextValueFilter contextValueFilter = nameFilter2.next();
                        propertyValue = contextValueFilter.process(fieldSerializer.fieldContext, object, fieldInfoName, propertyValue);
                    }
                }
                if (propertyValueGot && propertyValue == null && !writeAsArray && !fieldSerializer.writeNull && !out.writeMapNullValue || propertyValue != null && out.notWriteDefaultValue && ((fieldCLass = fieldInfo.fieldClass) == Byte.TYPE && propertyValue instanceof Byte && (Byte)propertyValue == 0 || fieldCLass == Short.TYPE && propertyValue instanceof Short && (Short)propertyValue == 0 || fieldCLass == Integer.TYPE && propertyValue instanceof Integer && (Integer)propertyValue == 0 || fieldCLass == Long.TYPE && propertyValue instanceof Long && (Long)propertyValue == 0L || fieldCLass == Float.TYPE && propertyValue instanceof Float && ((Float)propertyValue).floatValue() == 0.0f || fieldCLass == Double.TYPE && propertyValue instanceof Double && (Double)propertyValue == 0.0 || fieldCLass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue())) continue;
                if (commaFlag) {
                    out.write(44);
                    if (out.prettyFormat) {
                        serializer.println();
                    }
                }
                if (key != fieldInfoName) {
                    if (!writeAsArray) {
                        out.writeFieldName(key, true);
                    }
                    serializer.write(propertyValue);
                } else if (var39_56 != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else {
                    if (!writeAsArray) {
                        if (directWritePrefix) {
                            out.write(fieldInfo.name_chars, 0, fieldInfo.name_chars.length);
                        } else {
                            fieldSerializer.writePrefix(serializer);
                        }
                    }
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            serializer.out.writeInt(propertyValueInt);
                        } else if (fieldClass == Long.TYPE) {
                            serializer.out.writeLong(propertyValueLong);
                        } else if (fieldClass == Boolean.TYPE) {
                            if (propertyValueBoolean) {
                                serializer.out.write(true_chars, 0, true_chars.length);
                            } else {
                                serializer.out.write(false_chars, 0, false_chars.length);
                            }
                        }
                    } else if (!writeAsArray) {
                        if (fieldClass == String.class) {
                            if (propertyValue == null) {
                                if ((out.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 || (fieldSerializer.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    out.writeString("");
                                } else {
                                    out.writeNull();
                                }
                            } else {
                                String propertyValueString = (String)propertyValue;
                                if (out.useSingleQuotes) {
                                    out.writeStringWithSingleQuote(propertyValueString);
                                } else {
                                    out.writeStringWithDoubleQuote(propertyValueString, '\u0000');
                                }
                            }
                        } else {
                            fieldSerializer.writeValue(serializer, propertyValue);
                        }
                    } else {
                        fieldSerializer.writeValue(serializer, propertyValue);
                    }
                }
                commaFlag = true;
            }
            serializer.writeAfter(object, commaFlag ? (char)',' : '\u0000');
            if (getters.length > 0 && out.prettyFormat) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.append(endSeperator);
        }
        catch (Exception e) {
            String errorMessage = "write javaBean error";
            if (object != null) {
                errorMessage = errorMessage + ", class " + object.getClass().getName();
            }
            if (fieldName != null) {
                errorMessage = errorMessage + ", fieldName : " + fieldName;
            }
            if (e.getMessage() != null) {
                errorMessage = errorMessage + ", " + e.getMessage();
            }
            throw new JSONException(errorMessage, e);
        }
        finally {
            serializer.context = parent;
        }
    }

    public boolean writeReference(JSONSerializer serializer, Object object, int fieldFeatures) {
        SerialContext context = serializer.context;
        int mask = SerializerFeature.DisableCircularReferenceDetect.mask;
        if (context != null && ((context.features & mask) != 0 || (fieldFeatures & mask) != 0)) {
            return false;
        }
        if (serializer.references != null && serializer.references.containsKey(object)) {
            serializer.writeReference(object);
            return true;
        }
        return false;
    }

    public boolean isWriteAsArray(JSONSerializer serializer) {
        return (this.features & SerializerFeature.BeanToArray.mask) != 0 || serializer.out.beanToArray;
    }

    public FieldSerializer getFieldSerializer(String key) {
        if (key == null) {
            return null;
        }
        int low = 0;
        int high = this.sortedGetters.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedGetters[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedGetters[mid];
        }
        return null;
    }

    public List<Object> getFieldValues(Object object) throws Exception {
        ArrayList<Object> fieldValues = new ArrayList<Object>(this.sortedGetters.length);
        for (FieldSerializer getter : this.sortedGetters) {
            fieldValues.add(getter.getPropertyValue(object));
        }
        return fieldValues;
    }
}

