/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.codegen;

import com.alibaba.fastjson.codegen.ClassGen;
import com.alibaba.fastjson.util.DeserializeBeanInfo;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializerGen
extends ClassGen {
    private DeserializeBeanInfo beanInfo;
    private String genClassName;

    public DeserializerGen(Class<?> clazz, Appendable out) {
        super(clazz, out);
    }

    @Override
    public void gen() throws IOException {
        this.beanInfo = DeserializeBeanInfo.computeSetters(this.clazz, this.type);
        this.genClassName = this.clazz.getSimpleName() + "GenDecoder";
        this.print("package ");
        this.print(this.clazz.getPackage().getName());
        this.println(";");
        this.println();
        this.println("import java.lang.reflect.Type;");
        this.println();
        this.println("import com.alibaba.fastjson.parser.DefaultJSONParser;");
        this.println("import com.alibaba.fastjson.parser.DefaultJSONParser.ResolveTask;");
        this.println("import com.alibaba.fastjson.parser.ParserConfig;");
        this.println("import com.alibaba.fastjson.parser.Feature;");
        this.println("import com.alibaba.fastjson.parser.JSONLexerBase;");
        this.println("import com.alibaba.fastjson.parser.JSONToken;");
        this.println("import com.alibaba.fastjson.parser.ParseContext;");
        this.println("import com.alibaba.fastjson.parser.deserializer.ASMJavaBeanDeserializer;");
        this.println("import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;");
        this.println();
        this.print("public class ");
        this.print(this.genClassName);
        this.print(" extends ASMJavaBeanDeserializer implements ObjectDeserializer {");
        this.incrementIndent();
        this.println();
        this.genConstructor();
        this.genCreateInstance();
        this.genDeserialze();
        this.endClass();
    }

    protected void genCreateInstance() throws IOException {
        this.println();
        this.print("public Object createInstance(DefaultJSONParser parser, Type type) {");
        this.incrementIndent();
        this.println();
        this.print("return new ");
        this.print(this.clazz.getSimpleName());
        this.print("();");
        this.println();
        this.decrementIndent();
        this.println();
        this.print("}");
    }

    protected void genDeserialze() throws IOException {
        Class<?> fieldClass;
        FieldInfo fieldInfo;
        int i;
        if (this.beanInfo.getFieldList().size() == 0) {
            return;
        }
        for (FieldInfo fieldInfo2 : this.beanInfo.getFieldList()) {
            Class<?> fieldClass2 = fieldInfo2.getFieldClass();
            Type fieldType = fieldInfo2.getFieldType();
            if (fieldClass2 == Character.TYPE) {
                return;
            }
            if (!Collection.class.isAssignableFrom(fieldClass2)) continue;
            if (fieldType instanceof ParameterizedType) {
                Type itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                if (itemType instanceof Class) continue;
                return;
            }
            return;
        }
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>(this.beanInfo.getFieldList());
        Collections.sort(fieldList);
        this.println();
        this.print("public Object deserialze(DefaultJSONParser parser, Type type, Object fieldName) {");
        this.incrementIndent();
        this.println();
        this.println("JSONLexerBase lexer = (JSONLexerBase) parser.getLexer();");
        this.println();
        this.println("if (!lexer.isEnabled(Feature.SortFeidFastMatch)) {");
        this.println("\treturn super.deserialze(parser, type, fieldName);");
        this.println("}");
        this.println();
        this.println("if (isSupportArrayToBean(lexer)) {");
        this.println("\t// deserialzeArrayMapping");
        this.println("}");
        this.println();
        this.println("if (lexer.scanType(\"Department\") == JSONLexerBase.NOT_MATCH) {");
        this.println("\treturn super.deserialze(parser, type, fieldName);");
        this.println("}");
        this.println();
        this.println("ParseContext mark_context = parser.getContext();");
        this.println("int matchedCount = 0;");
        this.print(this.clazz.getSimpleName());
        this.print(" instance = ");
        Constructor<?> defaultConstructor = this.beanInfo.getDefaultConstructor();
        if (Modifier.isPublic(defaultConstructor.getModifiers())) {
            this.print("new ");
            this.print(this.clazz.getSimpleName());
            this.println("();");
        } else {
            this.print("(");
            this.print(this.clazz.getSimpleName());
            this.print(") createInstance(parser);");
        }
        this.println();
        this.println("ParseContext context = parser.getContext();");
        this.println("ParseContext childContext = parser.setContext(context, instance, fieldName);");
        this.println();
        this.println("if (lexer.matchStat == JSONLexerBase.END) {");
        this.println("\treturn instance;");
        this.println("}");
        this.println();
        this.println("int matchStat = 0;");
        int fieldListSize = fieldList.size();
        for (i = 0; i < fieldListSize; i += 32) {
            this.print("int _asm_flag_");
            this.print(Integer.toString(i / 32));
            this.println(" = 0;");
        }
        for (i = 0; i < fieldListSize; ++i) {
            fieldInfo = (FieldInfo)fieldList.get(i);
            fieldClass = fieldInfo.getFieldClass();
            if (fieldClass == Boolean.TYPE) {
                this.print("boolean ");
                this.printFieldVarName(fieldInfo);
                this.println(" = false;");
                continue;
            }
            if (fieldClass == Byte.TYPE || fieldClass == Short.TYPE || fieldClass == Integer.TYPE || fieldClass == Long.TYPE || fieldClass == Float.TYPE || fieldClass == Double.TYPE) {
                this.print(fieldClass.getSimpleName());
                this.print(" ");
                this.printFieldVarName(fieldInfo);
                this.println(" = 0;");
                continue;
            }
            if (fieldClass == String.class) {
                this.print("String ");
                this.printFieldVarName(fieldInfo);
                this.println(";");
                this.println("if (lexer.isEnabled(Feature.InitStringFieldAsEmpty)) {");
                this.print("\t");
                this.printFieldVarName(fieldInfo);
                this.println(" = lexer.stringDefaultValue();");
                this.print("\t");
                this.genSetFlag(i);
                this.println("} else {");
                this.print("\t");
                this.printFieldVarName(fieldInfo);
                this.println(" = null;");
                this.println("}");
                continue;
            }
            this.printClassName(fieldClass);
            this.print(" ");
            this.printFieldVarName(fieldInfo);
            this.print(" = null;");
            this.println();
        }
        this.println("boolean endFlag = false, restFlag = false;");
        this.println();
        for (i = 0; i < fieldListSize; ++i) {
            this.print("if ((!endFlag) && (!restFlag)) {");
            this.incrementIndent();
            this.println();
            fieldInfo = (FieldInfo)fieldList.get(i);
            fieldClass = fieldInfo.getFieldClass();
            Type fieldType = fieldInfo.getFieldType();
            if (fieldClass == Boolean.TYPE) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldBoolean(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass == Byte.TYPE || fieldClass == Short.TYPE || fieldClass == Integer.TYPE) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldInt(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass == Long.TYPE) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldLong(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass == Float.TYPE) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldFloat(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass == Double.TYPE) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldDouble(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass == String.class) {
                this.printFieldVarName(fieldInfo);
                this.print(" = lexer.scanFieldString(");
                this.printFieldPrefix(fieldInfo);
                this.println(");");
            } else if (fieldClass.isEnum()) {
                this.print("String ");
                this.printFieldVarEnumName(fieldInfo);
                this.print(" = lexer.scanFieldSymbol(");
                this.printFieldPrefix(fieldInfo);
                this.println(", parser.getSymbolTable());");
                this.print("if (");
                this.printFieldVarEnumName(fieldInfo);
                this.println(" == null) {");
                this.print("\t");
                this.printFieldVarName(fieldInfo);
                this.print(" = ");
                this.printClassName(fieldClass);
                this.print(".valueOf(");
                this.printFieldVarEnumName(fieldInfo);
                this.println(");");
                this.println("}");
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                Class<?> itemClass = TypeUtils.getCollectionItemClass(fieldType);
                if (itemClass == String.class) {
                    this.printFieldVarName(fieldInfo);
                    this.print(" = (");
                    this.printClassName(fieldClass);
                    this.print(") lexer.scanFieldStringArray(");
                    this.printFieldPrefix(fieldInfo);
                    this.print(", ");
                    this.printClassName(fieldClass);
                    this.print(".class);");
                    this.println();
                } else {
                    this.genDeserialzeList(fieldInfo, i, itemClass);
                    if (i == fieldListSize - 1) {
                        this.genEndCheck();
                    }
                }
            } else {
                this.genDeserialzeObject(fieldInfo, i);
                if (i == fieldListSize - 1) {
                    this.genEndCheck();
                }
            }
            this.println("if(lexer.matchStat > 0) {");
            this.print("\t");
            this.genSetFlag(i);
            this.println("\tmatchedCount++;");
            this.println("}");
            this.println("if(lexer.matchStat == JSONLexerBase.NOT_MATCH) {");
            this.println("\trestFlag = true;");
            this.println("}");
            this.println("if(lexer.matchStat != JSONLexerBase.END) {");
            this.println("\tendFlag = true;");
            this.println("}");
            this.decrementIndent();
            this.println();
            this.println("}");
        }
        this.genBatchSet(fieldList, true);
        this.println();
        this.println("if (restFlag) {");
        this.println("\treturn super.parseRest(parser, type, fieldName, instance);");
        this.println("}");
        this.println();
        this.print("return instance;");
        this.println();
        this.decrementIndent();
        this.println();
        this.print("}");
    }

    private void genBatchSet(List<FieldInfo> fieldList, boolean flag) throws IOException {
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldList.get(i);
            String varName = "_asm_flag_" + i / 32;
            if (flag) {
                this.print("if ((");
                this.print(varName);
                this.print(" & ");
                this.print(Integer.toString(1 << i));
                this.print(") != 0) {");
                this.println();
                this.incrementIndent();
            }
            if (fieldInfo.getMethod() != null) {
                this.print("\tinstance.");
                this.print(fieldInfo.getMethod().getName());
                this.print("(");
                this.printFieldVarName(fieldInfo);
                this.println(");");
            } else {
                this.print("\tinstance.");
                this.print(fieldInfo.getField().getName());
                this.print(" = ");
                this.printFieldVarName(fieldInfo);
                this.println(";");
            }
            if (!flag) continue;
            this.decrementIndent();
            this.println();
            this.println("}");
        }
    }

    private void genEndCheck() throws IOException {
        this.println("if (matchedCount <= 0 || lexer.token() != JSONToken.RBRACE) {");
        this.println("\trestFlag = true;");
        this.println("} else if (lexer.token() == JSONToken.COMMA) {");
        this.println("\tlexer.nextToken();");
        this.println("}");
    }

    protected void genDeserialzeList(FieldInfo fieldInfo, int i, Class<?> itemClass) throws IOException {
        this.print("if (lexer.matchField(");
        this.printFieldPrefix(fieldInfo);
        this.print(")) {");
        this.println();
        this.print("\t");
        this.genSetFlag(i);
        this.println("\tif (lexer.token() == JSONToken.NULL) {");
        this.println("\t\tlexer.nextToken(JSONToken.COMMA);");
        this.println("\t} else {");
        this.println("\t\tif (lexer.token() == JSONToken.LBRACKET) {");
        this.print("\t\t\tif(");
        this.printListFieldItemDeser(fieldInfo);
        this.print(" == null) {");
        this.println();
        this.print("\t\t\t\t");
        this.printListFieldItemDeser(fieldInfo);
        this.print(" = parser.getConfig().getDeserializer(");
        this.printClassName(itemClass);
        this.print(".class);");
        this.println();
        this.print("\t\t\t}");
        this.println();
        this.print("\t\t\tfinal int fastMatchToken = ");
        this.printListFieldItemDeser(fieldInfo);
        this.print(".getFastMatchToken();");
        this.println();
        this.println("\t\t\tlexer.nextToken(fastMatchToken);");
        this.print("\t\t\t");
        this.printFieldVarName(fieldInfo);
        this.print(" = ");
        Class<AbstractCollection> fieldClass = fieldInfo.getFieldClass();
        if (fieldClass.isAssignableFrom(ArrayList.class)) {
            this.print("new java.util.ArrayList();");
        } else if (fieldClass.isAssignableFrom(LinkedList.class)) {
            this.print("new java.util.LinkedList();");
        } else if (fieldClass.isAssignableFrom(HashSet.class)) {
            this.print("new java.util.HashSet();");
        } else if (fieldClass.isAssignableFrom(TreeSet.class)) {
            this.print("new java.util.TreeSet();");
        } else {
            this.print("new ");
            this.printClassName(fieldClass);
            this.print("();");
        }
        this.println();
        this.println("\t\t\tParseContext listContext = parser.getContext();");
        this.print("\t\t\tparser.setContext(");
        this.printFieldVarName(fieldInfo);
        this.print(", \"");
        this.print(fieldInfo.getName());
        this.print("\");");
        this.println();
        this.println();
        this.println("\t\t\tfor(int i = 0; ;++i) {");
        this.println("\t\t\t\tif (lexer.token() == JSONToken.RBRACKET) {");
        this.println("\t\t\t\t\tbreak;");
        this.println("\t\t\t\t}");
        this.print("\t\t\t\t");
        this.printClassName(itemClass);
        this.print(" itemValue = ");
        this.printListFieldItemDeser(fieldInfo);
        this.print(".deserialze(parser, ");
        this.printListFieldItemType(fieldInfo);
        this.println(", i);");
        this.print("\t\t\t\t");
        this.printFieldVarName(fieldInfo);
        this.println(".add(itemValue);");
        this.print("\t\t\t\tparser.checkListResolve(");
        this.printFieldVarName(fieldInfo);
        this.println(");");
        this.println("\t\t\t\tif (lexer.token() == JSONToken.COMMA) {");
        this.println("\t\t\t\t\tlexer.nextToken(fastMatchToken);");
        this.println("\t\t\t\t}");
        this.println("\t\t\t}");
        this.println("\t\t\tparser.setContext(listContext);");
        this.println("\t\t\tif (lexer.token() != JSONToken.RBRACKET) {");
        this.println("\t\t\t\trestFlag = true;");
        this.println("\t\t\t}");
        this.println("\t\t\tlexer.nextToken(JSONToken.COMMA);");
        this.println();
        this.println("\t\t} else {");
        this.println("\t\t\trestFlag = true;");
        this.println("\t\t}");
        this.println("\t}");
        this.println("}");
    }

    protected void genDeserialzeObject(FieldInfo fieldInfo, int i) throws IOException {
        this.print("if (lexer.matchField(");
        this.printFieldPrefix(fieldInfo);
        this.print(")) {");
        this.println();
        this.print("\t");
        this.genSetFlag(i);
        this.println("\tmatchedCount++;");
        this.print("if (");
        this.printFieldDeser(fieldInfo);
        this.print(" == null) {");
        this.println();
        this.print("\t");
        this.printFieldDeser(fieldInfo);
        this.print(" = parser.getConfig().getDeserializer(");
        this.printClassName(fieldInfo.getFieldClass());
        this.println(".class);");
        this.println("}");
        this.print("\t");
        this.printFieldDeser(fieldInfo);
        this.print(".deserialze(parser, ");
        if (fieldInfo.getFieldType() instanceof Class) {
            this.printClassName(fieldInfo.getFieldClass());
            this.print(".class");
        } else {
            this.print("getFieldType(\"");
            this.println(fieldInfo.getName());
            this.print("\")");
        }
        this.print(",\"");
        this.print(fieldInfo.getName());
        this.println("\");");
        this.println("\tif(parser.getResolveStatus() == DefaultJSONParser.NeedToResolve) {");
        this.println("\t\tResolveTask resolveTask = parser.getLastResolveTask();");
        this.println("\t\tresolveTask.setOwnerContext(parser.getContext());");
        this.print("\t\tresolveTask.setFieldDeserializer(this.getFieldDeserializer(\"");
        this.print(fieldInfo.getName());
        this.println("\"));");
        this.println("\t\tparser.setResolveStatus(DefaultJSONParser.NONE);");
        this.println("\t}");
        this.println("}");
    }

    private void printFieldVarName(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen");
    }

    private void printFieldVarEnumName(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen_enum_name");
    }

    private void printFieldPrefix(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen_prefix__");
    }

    private void printListFieldItemDeser(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen_list_item_deser__");
    }

    private void printFieldDeser(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen_deser__");
    }

    private void printListFieldItemType(FieldInfo fieldInfo) throws IOException {
        this.print(fieldInfo.getName());
        this.print("_gen_list_item_type__");
    }

    private void genSetFlag(int flag) throws IOException {
        String varName = "_asm_flag_" + flag / 32;
        this.print(varName);
        this.print(" |= ");
        this.print(Integer.toString(1 << flag));
        this.print(";");
        this.println();
    }

    protected void genConstructor() throws IOException {
        int size = this.beanInfo.getFieldList().size();
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = this.beanInfo.getFieldList().get(i);
            this.print("private char[] ");
            this.printFieldPrefix(fieldInfo);
            this.print(" = \"\\\"");
            this.print(fieldInfo.getName());
            this.print("\\\":\".toCharArray();");
            this.println();
        }
        this.println();
        boolean fieldDeserFlag = false;
        int size2 = this.beanInfo.getFieldList().size();
        for (int i = 0; i < size2; ++i) {
            FieldInfo fieldInfo = this.beanInfo.getFieldList().get(i);
            Class<?> fieldClass = fieldInfo.getFieldClass();
            if (fieldClass.isPrimitive() || fieldClass.isEnum()) continue;
            this.print("private ObjectDeserializer ");
            if (Collection.class.isAssignableFrom(fieldClass)) {
                this.printListFieldItemDeser(fieldInfo);
            } else {
                this.printFieldDeser(fieldInfo);
            }
            this.println(";");
            fieldDeserFlag = true;
            if (!Collection.class.isAssignableFrom(fieldClass)) continue;
            this.print("private Type ");
            this.printListFieldItemType(fieldInfo);
            this.print(" = ");
            Class<?> fieldItemClass = TypeUtils.getCollectionItemClass(fieldInfo.getFieldType());
            this.printClassName(fieldItemClass);
            this.println(".class;");
        }
        if (fieldDeserFlag) {
            this.println();
        }
        this.print("public ");
        this.print(this.genClassName);
        this.print(" (ParserConfig config, Class clazz) {");
        this.incrementIndent();
        this.println();
        this.println("super(config, clazz);");
        this.decrementIndent();
        this.println();
        this.print("}");
        this.println();
    }
}

