/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private ObjectDeserializer deserializer;
    private final boolean array;

    public ListTypeFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo, 14);
        Type fieldType = fieldInfo.fieldType;
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass.isArray()) {
            this.itemType = fieldClass.getComponentType();
            this.array = true;
        } else {
            this.itemType = TypeUtils.getCollectionItemType(fieldType);
            this.array = false;
        }
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        List fieldValue;
        List list;
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8 || token == 4 && lexer.stringVal().length() == 0) {
            this.setValue(object, null);
            parser.lexer.nextToken();
            return;
        }
        JSONArray jsonArray = null;
        if (this.array) {
            jsonArray = new JSONArray();
            list = jsonArray;
            jsonArray.setComponentType(this.itemType);
        } else {
            list = new ArrayList();
        }
        ParseContext context = parser.contex;
        parser.setContext(context, object, this.fieldInfo.name);
        this.parseArray(parser, objectType, list);
        parser.setContext(context);
        if (this.array) {
            Object[] arrayValue = (Object[])Array.newInstance((Class)this.itemType, list.size());
            fieldValue = list.toArray(arrayValue);
            jsonArray.setRelatedArray(fieldValue);
        } else {
            fieldValue = list;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.name, fieldValue);
        } else {
            this.setValue(object, fieldValue);
        }
    }

    final void parseArray(DefaultJSONParser parser, Type objectType, Collection array) {
        ObjectDeserializer itemTypeDeser;
        Type itemType;
        block35: {
            block33: {
                ParameterizedType parameterizedItemType;
                Type[] itemActualTypeArgs;
                block34: {
                    itemType = this.itemType;
                    itemTypeDeser = this.deserializer;
                    if (!(objectType instanceof ParameterizedType)) break block33;
                    if (!(itemType instanceof TypeVariable)) break block34;
                    TypeVariable typeVar = (TypeVariable)itemType;
                    ParameterizedType paramType = (ParameterizedType)objectType;
                    Class objectClass = null;
                    if (paramType.getRawType() instanceof Class) {
                        objectClass = (Class)paramType.getRawType();
                    }
                    int paramIndex = -1;
                    if (objectClass != null) {
                        int size = objectClass.getTypeParameters().length;
                        for (int i = 0; i < size; ++i) {
                            TypeVariable item = objectClass.getTypeParameters()[i];
                            if (!item.getName().equals(typeVar.getName())) continue;
                            paramIndex = i;
                            break;
                        }
                    }
                    if (paramIndex == -1 || (itemType = paramType.getActualTypeArguments()[paramIndex]).equals(this.itemType)) break block35;
                    itemTypeDeser = parser.config.getDeserializer(itemType);
                    break block35;
                }
                if (!(itemType instanceof ParameterizedType) || (itemActualTypeArgs = (parameterizedItemType = (ParameterizedType)itemType).getActualTypeArguments()).length != 1 || !(itemActualTypeArgs[0] instanceof TypeVariable)) break block35;
                TypeVariable typeVar = (TypeVariable)itemActualTypeArgs[0];
                ParameterizedType paramType = (ParameterizedType)objectType;
                Class objectClass = null;
                if (paramType.getRawType() instanceof Class) {
                    objectClass = (Class)paramType.getRawType();
                }
                int paramIndex = -1;
                if (objectClass != null) {
                    int size = objectClass.getTypeParameters().length;
                    for (int i = 0; i < size; ++i) {
                        TypeVariable item = objectClass.getTypeParameters()[i];
                        if (!item.getName().equals(typeVar.getName())) continue;
                        paramIndex = i;
                        break;
                    }
                }
                if (paramIndex != -1) {
                    itemActualTypeArgs[0] = paramType.getActualTypeArguments()[paramIndex];
                    itemType = new ParameterizedTypeImpl(itemActualTypeArgs, parameterizedItemType.getOwnerType(), parameterizedItemType.getRawType());
                }
                break block35;
            }
            if (itemType instanceof TypeVariable && objectType instanceof Class) {
                Class objectClass = (Class)objectType;
                TypeVariable typeVar = (TypeVariable)itemType;
                objectClass.getTypeParameters();
                int size = objectClass.getTypeParameters().length;
                for (int i = 0; i < size; ++i) {
                    TypeVariable item = objectClass.getTypeParameters()[i];
                    if (!item.getName().equals(typeVar.getName())) continue;
                    Type[] bounds = item.getBounds();
                    if (bounds.length != 1) break;
                    itemType = bounds[0];
                    break;
                }
            }
        }
        JSONLexer lexer = parser.lexer;
        if (itemTypeDeser == null) {
            itemTypeDeser = this.deserializer = parser.config.getDeserializer(itemType);
        }
        if (lexer.token != 14) {
            if (lexer.token == 12) {
                Object val = itemTypeDeser.deserialze(parser, itemType, 0);
                array.add(val);
                return;
            }
            String errorMessage = "exepct '[', but " + JSONToken.name(lexer.token);
            if (objectType != null) {
                errorMessage = errorMessage + ", type : " + objectType;
            }
            throw new JSONException(errorMessage);
        }
        char ch = lexer.ch;
        if (ch == '[') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 14;
        } else if (ch == '{') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 12;
        } else if (ch == '\"') {
            lexer.scanString();
        } else if (ch == ']') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 15;
        } else {
            lexer.nextToken();
        }
        int i = 0;
        while (true) {
            if (lexer.token == 16) {
                lexer.nextToken();
                continue;
            }
            if (lexer.token == 15) break;
            Object val = itemTypeDeser.deserialze(parser, itemType, i);
            array.add(val);
            if (parser.resolveStatus == 1) {
                parser.checkListResolve(array);
            }
            if (lexer.token == 16) {
                int index;
                ch = lexer.ch;
                if (ch == '[') {
                    lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                    lexer.token = 14;
                } else if (ch == '{') {
                    lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                    lexer.token = 12;
                } else if (ch == '\"') {
                    lexer.scanString();
                } else {
                    lexer.nextToken();
                }
            }
            ++i;
        }
        if (lexer.ch == ',') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 16;
        } else {
            lexer.nextToken();
        }
    }
}

