/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<V> {
    private final Entry<V>[] buckets;
    private final int indexMask;

    public IdentityHashMap(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
    }

    public final V get(Type key) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry<V> entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean put(Type key, V value) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry<V> entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                entry.value = value;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry<V>(key, value, hash, this.buckets[bucket]);
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Entry<V> {
        public final int hashCode;
        public final Type key;
        public V value;
        public final Entry<V> next;

        public Entry(Type key, V value, int hash, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.hashCode = hash;
        }
    }
}

