/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.EnumDeserializer;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.JavaBeanInfo;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessable;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    private final FieldDeserializer[] sortedFieldDeserializers;
    private final Class<?> clazz;
    public final JavaBeanInfo beanInfo;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        this(config, clazz, type, JavaBeanInfo.build(clazz, clazz.getModifiers(), type, false, true, true, true));
    }

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type, JavaBeanInfo beanInfo) {
        FieldDeserializer fieldDeserializer;
        this.clazz = clazz;
        this.beanInfo = beanInfo;
        this.sortedFieldDeserializers = new FieldDeserializer[beanInfo.sortedFields.length];
        for (FieldInfo fieldInfo : beanInfo.sortedFields) {
            this.sortedFieldDeserializers[i] = fieldDeserializer = config.createFieldDeserializer(config, clazz, fieldInfo);
        }
        this.fieldDeserializers = new FieldDeserializer[beanInfo.fields.length];
        for (FieldInfo fieldInfo : beanInfo.fields) {
            this.fieldDeserializers[i] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    protected Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            Class clazz = (Class)type;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            boolean ordred = (parser.lexer.features & Feature.OrderedField.mask) != 0;
            JSONObject object2 = new JSONObject(ordred);
            Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)object2);
            return proxy;
        }
        if (this.beanInfo.defaultConstructor == null) {
            return null;
        }
        try {
            Constructor<?> constructor = this.beanInfo.defaultConstructor;
            object = this.beanInfo.defaultConstructorParameterSize == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(parser.contex.object);
            if (parser != null && (parser.lexer.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
                for (FieldInfo fieldInfo : this.beanInfo.fields) {
                    if (fieldInfo.fieldClass != String.class) continue;
                    fieldInfo.set(object, "");
                }
            }
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, null);
    }

    private <T> T deserialzeArrayMapping(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.lexer;
        object = this.createInstance(parser, type);
        int size = this.sortedFieldDeserializers.length;
        for (int i = 0; i < size; ++i) {
            Number number;
            int seperator = i == size - 1 ? 93 : 44;
            FieldDeserializer fieldDeser = this.sortedFieldDeserializers[i];
            Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
            if (fieldClass == Integer.TYPE) {
                number = lexer.scanNumberValue();
                fieldDeser.setValue(object, number);
                lexer.nextToken(16);
                continue;
            }
            if (fieldClass == String.class) {
                String strVal;
                if (lexer.ch == '\"') {
                    strVal = lexer.scanStringValue('\"');
                } else {
                    lexer.nextToken();
                    if (lexer.token == 8) {
                        strVal = null;
                    } else {
                        throw new JSONException("not match string. feild : " + fieldName);
                    }
                }
                fieldDeser.setValue(object, strVal);
                lexer.nextToken(16);
                continue;
            }
            if (fieldClass == Long.TYPE) {
                number = lexer.scanNumberValue();
                if (!(number instanceof Long)) {
                    number = number.longValue();
                }
                fieldDeser.setValue(object, number);
                lexer.nextToken(16);
                continue;
            }
            if (fieldClass.isEnum()) {
                String enumName = lexer.scanSymbol(parser.symbolTable);
                Object value = enumName == null ? null : Enum.valueOf(fieldClass, enumName);
                fieldDeser.setValue(object, value);
                lexer.nextToken(16);
                continue;
            }
            lexer.nextToken(14);
            Object value = parser.parseObject(fieldDeser.fieldInfo.fieldType);
            fieldDeser.setValue(object, value);
            if (seperator == 93) {
                if (lexer.token != 15) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(16);
                continue;
            }
            if (seperator != 44 || lexer.token == 16) continue;
            throw new JSONException("syntax error");
        }
        lexer.nextToken(16);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        if (type == JSON.class || type == JSONObject.class) {
            return (T)parser.parse();
        }
        lexer = parser.lexer;
        token = lexer.token;
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        context = parser.contex;
        if (object != null && context != null) {
            context = context.parent;
        }
        childContext = null;
        try {
            fieldValues = null;
            if (token == 13) {
                lexer.nextToken(16);
                if (object == null) {
                    object = this.createInstance(parser, type);
                }
                var10_10 = object;
                return (T)var10_10;
            }
            if (token == 14) {
                beanFeatures = 0;
                if (this.beanInfo.jsonType != null) {
                    for (Feature feature : this.beanInfo.jsonType.parseFeatures()) {
                        beanFeatures |= feature.mask;
                    }
                }
                v0 = isSupportArrayToBean = (beanFeatures & Feature.SupportArrayToBean.mask) != 0 || (lexer.features & Feature.SupportArrayToBean.mask) != 0;
                if (isSupportArrayToBean) {
                    var12_22 = this.deserialzeArrayMapping(parser, type, fieldName, object);
                    return var12_22;
                }
            }
            if (token != 12 && token != 16) {
                if (lexer.isBlankInput()) {
                    beanFeatures = null;
                    return beanFeatures;
                }
                if (token == 4 && (strVal = lexer.stringVal()).length() == 0) {
                    lexer.nextToken();
                    isSupportArrayToBean = null;
                    return isSupportArrayToBean;
                }
                buf = new StringBuffer().append("syntax error, expect {, actual ").append(lexer.info());
                if (fieldName instanceof String) {
                    buf.append(", fieldName ").append(fieldName);
                }
                throw new JSONException(buf.toString());
            }
            if (parser.resolveStatus == 2) {
                parser.resolveStatus = 0;
            }
            fieldIndex = 0;
            size = this.sortedFieldDeserializers.length;
            while (true) {
                block89: {
                    block106: {
                        block102: {
                            block104: {
                                block105: {
                                    block103: {
                                        block86: {
                                            block100: {
                                                block101: {
                                                    block98: {
                                                        block99: {
                                                            block96: {
                                                                block97: {
                                                                    block94: {
                                                                        block95: {
                                                                            block92: {
                                                                                block93: {
                                                                                    block90: {
                                                                                        block91: {
                                                                                            block87: {
                                                                                                block88: {
                                                                                                    key = null;
                                                                                                    fieldDeser = null;
                                                                                                    fieldInfo = null;
                                                                                                    fieldClass = null;
                                                                                                    if (fieldIndex < size) {
                                                                                                        fieldDeser = this.sortedFieldDeserializers[fieldIndex];
                                                                                                        fieldInfo = fieldDeser.fieldInfo;
                                                                                                        fieldClass = fieldInfo.fieldClass;
                                                                                                    }
                                                                                                    matchField = false;
                                                                                                    valueParsed = false;
                                                                                                    fieldValue = null;
                                                                                                    fieldValueInt = 0;
                                                                                                    fieldValueLong = 0L;
                                                                                                    fieldValueFloat = 0.0f;
                                                                                                    fieldValueDouble = 0.0;
                                                                                                    if (fieldDeser == null) break block86;
                                                                                                    name_chars = fieldInfo.name_chars;
                                                                                                    if (fieldClass != Integer.TYPE && fieldClass != Integer.class) break block87;
                                                                                                    fieldValueInt = lexer.scanFieldInt(name_chars);
                                                                                                    if (lexer.matchStat <= 0) break block88;
                                                                                                    matchField = true;
                                                                                                    valueParsed = true;
                                                                                                    break block86;
                                                                                                }
                                                                                                if (lexer.matchStat != -2) break block86;
                                                                                                break block89;
                                                                                            }
                                                                                            if (fieldClass != Long.TYPE && fieldClass != Long.class) break block90;
                                                                                            fieldValueLong = lexer.scanFieldLong(name_chars);
                                                                                            if (lexer.matchStat <= 0) break block91;
                                                                                            matchField = true;
                                                                                            valueParsed = true;
                                                                                            break block86;
                                                                                        }
                                                                                        if (lexer.matchStat != -2) break block86;
                                                                                        break block89;
                                                                                    }
                                                                                    if (fieldClass != String.class) break block92;
                                                                                    fieldValue = lexer.scanFieldString(name_chars);
                                                                                    if (lexer.matchStat <= 0) break block93;
                                                                                    matchField = true;
                                                                                    valueParsed = true;
                                                                                    break block86;
                                                                                }
                                                                                if (lexer.matchStat != -2) break block86;
                                                                                break block89;
                                                                            }
                                                                            if (fieldClass != Boolean.TYPE && fieldClass != Boolean.class) break block94;
                                                                            fieldValue = lexer.scanFieldBoolean(name_chars);
                                                                            if (lexer.matchStat <= 0) break block95;
                                                                            matchField = true;
                                                                            valueParsed = true;
                                                                            break block86;
                                                                        }
                                                                        if (lexer.matchStat != -2) break block86;
                                                                        break block89;
                                                                    }
                                                                    if (fieldClass != Float.TYPE && fieldClass != Float.class) break block96;
                                                                    fieldValueFloat = lexer.scanFieldFloat(name_chars);
                                                                    if (lexer.matchStat <= 0) break block97;
                                                                    matchField = true;
                                                                    valueParsed = true;
                                                                    break block86;
                                                                }
                                                                if (lexer.matchStat != -2) break block86;
                                                                break block89;
                                                            }
                                                            if (fieldClass != Double.TYPE && fieldClass != Double.class) break block98;
                                                            fieldValueDouble = lexer.scanFieldDouble(name_chars);
                                                            if (lexer.matchStat <= 0) break block99;
                                                            matchField = true;
                                                            valueParsed = true;
                                                            break block86;
                                                        }
                                                        if (lexer.matchStat != -2) break block86;
                                                        break block89;
                                                    }
                                                    if (!fieldInfo.isEnum || !(parser.config.getDeserializer(fieldClass) instanceof EnumDeserializer)) break block100;
                                                    enumName = lexer.scanFieldSymbol(name_chars, parser.symbolTable);
                                                    if (lexer.matchStat <= 0) break block101;
                                                    matchField = true;
                                                    valueParsed = true;
                                                    fieldValue = Enum.valueOf(fieldClass, enumName);
                                                    break block86;
                                                }
                                                if (lexer.matchStat != -2) break block86;
                                                break block89;
                                            }
                                            if (!lexer.matchField(name_chars)) break block89;
                                            matchField = true;
                                        }
                                        if (matchField) break block102;
                                        key = lexer.scanSymbol(parser.symbolTable);
                                        if (key != null) break block103;
                                        token = lexer.token;
                                        if (token == 13) {
                                            lexer.nextToken(16);
                                            break;
                                        }
                                        if (token == 16 && (lexer.features & Feature.AllowArbitraryCommas.mask) != 0) break block89;
                                    }
                                    if ("$ref" == key) {
                                        lexer.nextTokenWithChar(':');
                                        token = lexer.token;
                                        if (token == 4) {
                                            ref = lexer.stringVal();
                                            if ("@".equals(ref)) {
                                                object = context.object;
                                            } else if ("..".equals(ref)) {
                                                parentContext = context.parent;
                                                if (parentContext.object != null) {
                                                    object = parentContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else if ("$".equals(ref)) {
                                                rootContext = context;
                                                while (rootContext.parent != null) {
                                                    rootContext = rootContext.parent;
                                                }
                                                if (rootContext.object != null) {
                                                    object = rootContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else {
                                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                                parser.resolveStatus = 1;
                                            }
                                        } else {
                                            throw new JSONException("illegal ref, " + JSONToken.name(token));
                                        }
                                        lexer.nextToken(13);
                                        if (lexer.token != 13) {
                                            throw new JSONException("illegal ref");
                                        }
                                        lexer.nextToken(16);
                                        parser.setContext(context, object, fieldName);
                                        ref = object;
                                        return (T)ref;
                                    }
                                    if ("@type" != key) break block102;
                                    lexer.nextTokenWithChar(':');
                                    if (lexer.token != 4) break block104;
                                    typeName = lexer.stringVal();
                                    lexer.nextToken(16);
                                    if (!(type instanceof Class) || !typeName.equals(((Class)type).getName())) break block105;
                                    if (lexer.token == 13) {
                                        lexer.nextToken();
                                        break;
                                    }
                                    break block89;
                                }
                                userType = TypeUtils.loadClass(typeName, parser.config.defaultClassLoader);
                                deserizer = parser.config.getDeserializer(userType);
                                var28_43 = deserizer.deserialze(parser, userType, fieldName);
                                return var28_43;
                            }
                            throw new JSONException("syntax error");
                        }
                        if (object == null && fieldValues == null) {
                            object = this.createInstance(parser, type);
                            if (object == null) {
                                fieldValues = new HashMap<String, Integer>(this.fieldDeserializers.length);
                            }
                            childContext = parser.setContext(context, object, fieldName);
                        }
                        if (!matchField) break block106;
                        if (!valueParsed) {
                            fieldDeser.parseField(parser, object, type, fieldValues);
                        } else {
                            if (object == null) {
                                if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                    fieldValue = fieldValueInt;
                                } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                    fieldValue = fieldValueLong;
                                } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                    fieldValue = new Float(fieldValueFloat);
                                } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                    fieldValue = new Double(fieldValueDouble);
                                }
                                fieldValues.put(fieldInfo.name, (Integer)fieldValue);
                            } else if (fieldValue == null) {
                                try {
                                    if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Integer.TYPE) {
                                            fieldDeser.setValue(object, fieldValueInt);
                                        }
                                        fieldDeser.setValue(object, (Object)fieldValueInt);
                                    }
                                    if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Long.TYPE) {
                                            fieldDeser.setValue(object, fieldValueLong);
                                        }
                                        fieldDeser.setValue(object, (Object)fieldValueLong);
                                    }
                                    if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Float.TYPE) {
                                            fieldDeser.setValue(object, fieldValueFloat);
                                        }
                                        fieldDeser.setValue(object, new Float(fieldValueFloat));
                                    }
                                    if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Double.TYPE) {
                                            fieldDeser.setValue(object, fieldValueDouble);
                                        }
                                        fieldDeser.setValue(object, new Double(fieldValueDouble));
                                    }
                                    fieldDeser.setValue(object, fieldValue);
                                }
                                catch (IllegalAccessException ex) {
                                    throw new JSONException("set property error, " + fieldInfo.name, ex);
                                }
                            } else {
                                fieldDeser.setValue(object, fieldValue);
                            }
                            if (lexer.matchStat == 4) {
                                break;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    match = this.parseField(parser, key, object, type, fieldValues);
                    if (!match) {
                        if (lexer.token == 13) {
                            lexer.nextToken();
                            break;
                        }
                    } else if (lexer.token != 16) {
                        if (lexer.token == 13) {
                            lexer.nextToken(16);
                            break;
                        }
                        if (lexer.token == 18 || lexer.token == 1) {
                            throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token));
                        }
                    }
                }
                ++fieldIndex;
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    fieldIndex = object;
                    return (T)fieldIndex;
                }
                size = this.fieldDeserializers.length;
                params = new Object[size];
                for (i = 0; i < size; ++i) {
                    fieldInfo = this.fieldDeserializers[i].fieldInfo;
                    params[i] = fieldValues.get(fieldInfo.name);
                }
                if (this.beanInfo.creatorConstructor != null) {
                    try {
                        object = this.beanInfo.creatorConstructor.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
                    }
                }
                if (this.beanInfo.factoryMethod != null) {
                    try {
                        object = this.beanInfo.factoryMethod.invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
                    }
                }
            }
            var10_16 = object;
            return (T)var10_16;
        }
        finally {
            if (childContext != null) {
                childContext.object = object;
            }
            parser.setContext(context);
        }
    }

    protected FieldDeserializer getFieldDeserializer(String key) {
        if (key == null) {
            return null;
        }
        if (this.beanInfo.ordered) {
            for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
                if (!this.sortedFieldDeserializers[i].fieldInfo.name.equalsIgnoreCase(key)) continue;
                return this.sortedFieldDeserializers[i];
            }
            return null;
        }
        int low = 0;
        int high = this.sortedFieldDeserializers.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedFieldDeserializers[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedFieldDeserializers[mid];
        }
        return null;
    }

    private boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.lexer;
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(key);
        if (fieldDeserializer == null) {
            boolean startsWithIs = key.startsWith("is");
            for (FieldDeserializer fieldDeser : this.sortedFieldDeserializers) {
                FieldInfo fieldInfo = fieldDeser.fieldInfo;
                Class<?> fieldClass = fieldInfo.fieldClass;
                String fieldName = fieldInfo.name;
                if (fieldName.equalsIgnoreCase(key)) {
                    fieldDeserializer = fieldDeser;
                    break;
                }
                if (!startsWithIs || fieldClass != Boolean.TYPE && fieldClass != Boolean.class || !fieldName.equalsIgnoreCase(key.substring(2))) continue;
                fieldDeserializer = fieldDeser;
                break;
            }
        }
        if (fieldDeserializer == null) {
            this.parseExtra(parser, object, key);
            return false;
        }
        lexer.nextTokenWithChar(':');
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        return true;
    }

    void parseExtra(DefaultJSONParser parser, Object object, String key) {
        Object value;
        JSONLexer lexer = parser.lexer;
        if ((parser.lexer.features & Feature.IgnoreNotMatch.mask) == 0) {
            throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
        }
        lexer.nextTokenWithChar(':');
        Type type = null;
        List<ExtraTypeProvider> extraTypeProviders = parser.extraTypeProviders;
        if (extraTypeProviders != null) {
            for (ExtraTypeProvider extraProvider : extraTypeProviders) {
                type = extraProvider.getExtraType(object, key);
            }
        }
        Object object2 = value = type == null ? parser.parse() : parser.parseObject(type);
        if (object instanceof ExtraProcessable) {
            ExtraProcessable extraProcessable = (ExtraProcessable)object;
            extraProcessable.processExtra(key, value);
            return;
        }
        List<ExtraProcessor> extraProcessors = parser.extraProcessors;
        if (extraProcessors != null) {
            for (ExtraProcessor process : extraProcessors) {
                process.processExtra(object, key, value);
            }
        }
    }

    public Object createInstance(Map<String, Object> map, ParserConfig config) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object = null;
        if (this.beanInfo.creatorConstructor == null) {
            object = this.createInstance(null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                FieldDeserializer fieldDeser = this.getFieldDeserializer(entry.getKey());
                if (fieldDeser == null) continue;
                Object value = entry.getValue();
                Method method = fieldDeser.fieldInfo.method;
                if (method != null) {
                    Type paramType = method.getGenericParameterTypes()[0];
                    value = TypeUtils.cast(value, paramType, config);
                    method.invoke(object, value);
                    continue;
                }
                Field field = fieldDeser.fieldInfo.field;
                Type paramType = fieldDeser.fieldInfo.fieldType;
                value = TypeUtils.cast(value, paramType, config);
                field.set(object, value);
            }
            return object;
        }
        FieldInfo[] fieldInfoList = this.beanInfo.fields;
        int size = fieldInfoList.length;
        Object[] params = new Object[size];
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldInfoList[i];
            params[i] = map.get(fieldInfo.name);
        }
        if (this.beanInfo.creatorConstructor != null) {
            try {
                object = this.beanInfo.creatorConstructor.newInstance(params);
            }
            catch (Exception e) {
                throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
            }
        }
        return object;
    }
}

