/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.SymbolTable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class JSONLexer {
    public static final char EOI = '\u001a';
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKNOWN = 0;
    public static final int VALUE = 3;
    public static final int END = 4;
    private static boolean V6;
    protected int token;
    protected int pos;
    public int features = JSON.DEFAULT_PARSER_FEATURE;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    public TimeZone timeZone = JSON.defaultTimeZone;
    public Locale locale = JSON.defaultLocale;
    protected Calendar calendar = null;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> sbufLocal;
    protected final String text;
    protected final int len;
    protected static final int[] digits;
    public static final char[] CA;
    static final int[] IA;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;

    public JSONLexer(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONLexer(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    public JSONLexer(String input, int features) {
        int index;
        this.sbuf = sbufLocal.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
        this.features = features;
        this.text = input;
        this.len = this.text.length();
        this.bp = -1;
        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public final int token() {
        return this.token;
    }

    public void close() {
        if (this.sbuf.length <= 8196) {
            sbufLocal.set(this.sbuf);
        }
        this.sbuf = null;
    }

    public char next() {
        int index;
        char c = (index = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(index);
        this.ch = c;
        return c;
    }

    public final void config(Feature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= ~feature.mask);
    }

    public final boolean isEnabled(Feature feature) {
        return (this.features & feature.mask) != 0;
    }

    public final void nextTokenWithChar(char expect) {
        this.sp = 0;
        while (true) {
            if (this.ch == expect) {
                int index;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + expect + " - " + this.ch);
    }

    public final boolean isRef() {
        return this.sp == 4 && this.text.startsWith("$ref", this.np + 1);
    }

    public final String numberString() {
        int index = this.np + this.sp - 1;
        char chLocal = this.text.charAt(index);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.subString(this.np, sp);
    }

    protected char charAt(int index) {
        return index >= this.len ? (char)'\u001a' : this.text.charAt(index);
    }

    public final void nextToken() {
        block23: {
            this.sp = 0;
            block15: while (true) {
                boolean eof;
                this.pos = this.bp;
                if (this.ch == '/') {
                    this.skipComment();
                    continue;
                }
                if (this.ch == '\"') {
                    this.scanString();
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9' || this.ch == '-') {
                    this.scanNumber();
                    return;
                }
                if (this.ch == ',') {
                    this.next();
                    this.token = 16;
                    return;
                }
                switch (this.ch) {
                    case '\'': {
                        if ((this.features & Feature.AllowSingleQuotes.mask) == 0) {
                            throw new JSONException("Feature.AllowSingleQuotes is false");
                        }
                        this.scanString();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block15;
                    }
                    case 't': {
                        this.scanTrue();
                        return;
                    }
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        this.scanIdent();
                        return;
                    }
                    case 'f': {
                        this.scanFalse();
                        return;
                    }
                    case 'n': {
                        this.scanNullOrNew();
                        return;
                    }
                    case '(': {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case '[': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 14;
                        return;
                    }
                    case ']': {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case '{': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 12;
                        return;
                    }
                    case '}': {
                        int index = ++this.bp;
                        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                        this.token = 13;
                        return;
                    }
                    case ':': {
                        this.next();
                        this.token = 17;
                        return;
                    }
                }
                boolean bl = eof = this.bp == this.len || this.ch == '\u001a' && this.bp + 1 == this.len;
                if (eof) {
                    if (this.token == 20) {
                        throw new JSONException("EOF error");
                    }
                    this.token = 20;
                    this.pos = this.bp = this.eofPos;
                    break block23;
                }
                if (this.ch > '\u001f' && this.ch != '\u007f') break;
                this.next();
            }
            this.token = 1;
            this.next();
        }
    }

    public final void nextToken(int expect) {
        this.sp = 0;
        while (true) {
            switch (expect) {
                case 12: {
                    int index;
                    if (this.ch == '{') {
                        int index2;
                        this.token = 12;
                        this.ch = (char)((index2 = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index2));
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        int index;
                        this.token = 16;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch == '}') {
                        int index;
                        this.token = 13;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch == ']') {
                        int index;
                        this.token = 15;
                        this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    int index;
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (true) {
            boolean whitespace;
            boolean bl = whitespace = this.ch <= ' ' && (this.ch == ' ' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b');
            if (!whitespace) break;
            this.next();
        }
        if (this.ch == '_' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    private String stringDefaultValue() {
        return (this.features & Feature.InitStringFieldAsEmpty.mask) != 0 ? "" : null;
    }

    public final Number integerValue() throws NumberFormatException {
        int digit;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        switch (this.charAt(max - 1)) {
            case 'L': {
                --max;
                type = 76;
                break;
            }
            case 'S': {
                --max;
                type = 83;
                break;
            }
            case 'B': {
                --max;
                type = 66;
                break;
            }
        }
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < -922337203685477580L) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    public final String scanSymbol(SymbolTable symbolTable) {
        while (this.ch == ' ' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
            this.next();
        }
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if ((this.features & Feature.AllowSingleQuotes.mask) == 0) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if ((this.features & Feature.AllowUnQuotedFieldNames.mask) == 0) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    public String scanSymbol(SymbolTable symbolTable, char quoteChar) {
        String strVal;
        int i;
        String strVal2;
        int hash = 0;
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        if (V6 && endIndex - startIndex > 5 && (strVal2 = this.text.substring(startIndex, endIndex)).indexOf(92) == -1) {
            this.bp = endIndex + 1;
            int index = this.bp;
            this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
            return strVal2;
        }
        int chars_len = endIndex - startIndex;
        char[] chars = this.sub_chars(this.bp + 1, chars_len);
        while (chars_len > 0 && chars[chars_len - 1] == '\\') {
            int slashCount = 1;
            for (i = chars_len - 2; i >= 0 && chars[i] == '\\'; --i) {
                ++slashCount;
            }
            if (slashCount % 2 == 0) break;
            int nextIndex = this.text.indexOf(quoteChar, endIndex + 1);
            int nextLen = nextIndex - endIndex;
            int next_chars_len = chars_len + nextLen;
            if (next_chars_len < chars.length) {
                this.text.getChars(endIndex, nextIndex, chars, chars_len);
            } else {
                chars = this.sub_chars(this.bp + 1, next_chars_len);
            }
            chars_len = next_chars_len;
            endIndex = nextIndex;
            hasSpecial = true;
        }
        if (!hasSpecial) {
            for (i = 0; i < chars_len; ++i) {
                char ch = chars[i];
                hash = 31 * hash + ch;
                if (ch != '\\') continue;
                hasSpecial = true;
            }
            strVal = hasSpecial ? JSONLexer.readString(chars, chars_len) : (chars_len < 20 ? symbolTable.addSymbol(chars, 0, chars_len, hash) : new String(chars, 0, chars_len));
        } else {
            strVal = JSONLexer.readString(chars, chars_len);
        }
        int index = this.bp = endIndex + 1;
        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        return strVal;
    }

    private static String readString(char[] chars, int chars_len) {
        char[] sbuf = new char[chars_len];
        int len = 0;
        block22: for (int i = 0; i < chars_len; ++i) {
            char ch = chars[i];
            if (ch != '\\') {
                sbuf[len++] = ch;
                continue;
            }
            ch = chars[++i];
            switch (ch) {
                case '0': {
                    sbuf[len++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    sbuf[len++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    sbuf[len++] = 2;
                    continue block22;
                }
                case '3': {
                    sbuf[len++] = 3;
                    continue block22;
                }
                case '4': {
                    sbuf[len++] = 4;
                    continue block22;
                }
                case '5': {
                    sbuf[len++] = 5;
                    continue block22;
                }
                case '6': {
                    sbuf[len++] = 6;
                    continue block22;
                }
                case '7': {
                    sbuf[len++] = 7;
                    continue block22;
                }
                case 'b': {
                    sbuf[len++] = 8;
                    continue block22;
                }
                case 't': {
                    sbuf[len++] = 9;
                    continue block22;
                }
                case 'n': {
                    sbuf[len++] = 10;
                    continue block22;
                }
                case 'v': {
                    sbuf[len++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    sbuf[len++] = 12;
                    continue block22;
                }
                case 'r': {
                    sbuf[len++] = 13;
                    continue block22;
                }
                case '\"': {
                    sbuf[len++] = 34;
                    continue block22;
                }
                case '\'': {
                    sbuf[len++] = 39;
                    continue block22;
                }
                case '/': {
                    sbuf[len++] = 47;
                    continue block22;
                }
                case '\\': {
                    sbuf[len++] = 92;
                    continue block22;
                }
                case 'x': {
                    sbuf[len++] = (char)(digits[chars[++i]] * 16 + digits[chars[++i]]);
                    continue block22;
                }
                case 'u': {
                    sbuf[len++] = (char)Integer.parseInt(new String(new char[]{chars[++i], chars[++i], chars[++i], chars[++i]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(sbuf, 0, len);
    }

    public String info() {
        return "pos " + this.bp + ", json : " + (this.text.length() < 65536 ? this.text : this.text.substring(0, 65536));
    }

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
            } while (this.ch != '\n');
            this.next();
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    break;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char ch;
        boolean firstFlag;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch + ", " + this.info());
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((ch = this.next()) >= identifierFlags.length || identifierFlags[ch]) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        if (this.sp == 4 && this.text.startsWith("null", this.np)) {
            return null;
        }
        return symbolTable.addSymbol(this.text, this.np, this.sp, hash);
    }

    public final void scanString() {
        char quoteChar = this.ch;
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        int chars_len = endIndex - startIndex;
        char[] chars = this.sub_chars(this.bp + 1, chars_len);
        while (chars_len > 0 && chars[chars_len - 1] == '\\') {
            int slashCount = 1;
            for (int i = chars_len - 2; i >= 0 && chars[i] == '\\'; --i) {
                ++slashCount;
            }
            if (slashCount % 2 == 0) break;
            int nextIndex = this.text.indexOf(quoteChar, endIndex + 1);
            int nextLen = nextIndex - endIndex;
            int next_chars_len = chars_len + nextLen;
            if (next_chars_len < chars.length) {
                this.text.getChars(endIndex, nextIndex, chars, chars_len);
            } else {
                chars = this.sub_chars(this.bp + 1, next_chars_len);
            }
            chars_len = next_chars_len;
            endIndex = nextIndex;
            hasSpecial = true;
        }
        if (!hasSpecial) {
            for (int i = 0; i < chars_len; ++i) {
                if (chars[i] != '\\') continue;
                hasSpecial = true;
            }
        }
        this.sbuf = chars;
        this.sp = chars_len;
        this.np = this.bp;
        this.hasSpecial = hasSpecial;
        this.bp = endIndex + 1;
        int index = this.bp;
        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        this.token = 4;
    }

    public String scanStringValue(char quoteChar) {
        String strVal;
        int i;
        boolean hasSpecial = false;
        int startIndex = this.bp + 1;
        int endIndex = this.text.indexOf(quoteChar, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        if (V6) {
            String strVal2 = this.text.substring(startIndex, endIndex);
            if (strVal2.indexOf(92) == -1) {
                this.bp = endIndex + 1;
                int index = this.bp;
                this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
                return strVal2;
            }
            hasSpecial = true;
        }
        int chars_len = endIndex - startIndex;
        char[] chars = this.sub_chars(this.bp + 1, chars_len);
        while (chars_len > 0 && chars[chars_len - 1] == '\\') {
            int slashCount = 1;
            for (i = chars_len - 2; i >= 0 && chars[i] == '\\'; --i) {
                ++slashCount;
            }
            if (slashCount % 2 == 0) break;
            int nextIndex = this.text.indexOf(quoteChar, endIndex + 1);
            int nextLen = nextIndex - endIndex;
            int next_chars_len = chars_len + nextLen;
            if (next_chars_len < chars.length) {
                this.text.getChars(endIndex, nextIndex, chars, chars_len);
            } else {
                chars = this.sub_chars(this.bp + 1, next_chars_len);
            }
            chars_len = next_chars_len;
            endIndex = nextIndex;
            hasSpecial = true;
        }
        if (!hasSpecial) {
            for (i = 0; i < chars_len; ++i) {
                if (chars[i] != '\\') continue;
                hasSpecial = true;
            }
            strVal = hasSpecial ? JSONLexer.readString(chars, chars_len) : new String(chars, 0, chars_len);
        } else {
            strVal = JSONLexer.readString(chars, chars_len);
        }
        int index = this.bp = endIndex + 1;
        this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        return strVal;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public final int intValue() {
        char ch;
        int digit;
        int limit;
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = -214748364;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (ch = this.charAt(i++)) != 'L' && ch != 'S' && ch != 'B') {
            digit = digits[ch];
            if (result < -214748364) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public byte[] bytesValue() {
        return JSONLexer.decodeFast(this.text, this.np + 1, this.sp);
    }

    private void scanTrue() {
        if (this.text.startsWith("true", this.bp)) {
            this.bp += 4;
            this.ch = this.charAt(this.bp);
            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':') {
                this.token = 6;
                return;
            }
        }
        throw new JSONException("scan true error");
    }

    private void scanNullOrNew() {
        int token = 0;
        if (this.text.startsWith("null", this.bp)) {
            this.bp += 4;
            token = 8;
        } else if (this.text.startsWith("new", this.bp)) {
            this.bp += 3;
            token = 9;
        }
        if (token != 0) {
            this.ch = this.charAt(this.bp);
            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b') {
                this.token = token;
                return;
            }
        }
        throw new JSONException("scan null/new error");
    }

    private void scanFalse() {
        if (this.text.startsWith("false", this.bp)) {
            this.bp += 5;
            this.ch = this.charAt(this.bp);
            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':') {
                this.token = 7;
                return;
            }
        }
        throw new JSONException("scan false error");
    }

    private void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        this.token = ident.equals("null") ? 8 : (ident.equals("true") ? 6 : (ident.equals("false") ? 7 : (ident.equals("new") ? 9 : (ident.equals("undefined") ? 23 : (ident.equals("Set") ? 21 : (ident.equals("TreeSet") ? 22 : 18))))));
    }

    public final String stringVal() {
        return this.hasSpecial ? JSONLexer.readString(this.sbuf, this.sp) : this.subString(this.np + 1, this.sp);
    }

    private final String subString(int offset, int count) {
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new String(this.sbuf, 0, count);
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return new String(chars);
    }

    final char[] sub_chars(int offset, int count) {
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return this.sbuf;
        }
        this.sbuf = new char[count];
        char[] chars = this.sbuf;
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    public final boolean isBlankInput() {
        char ch;
        int i = 0;
        while ((ch = this.charAt(i)) != '\u001a') {
            boolean whitespace;
            boolean bl = whitespace = ch <= ' ' && (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b');
            if (!whitespace) {
                return false;
            }
            ++i;
        }
        return true;
    }

    final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    public final void scanNumber() {
        int index;
        int index2;
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            index2 = this.bp;
            this.ch = (char)(index2 >= this.len ? 26 : (int)this.text.charAt(index2));
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = (char)((index2 = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index2));
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.sp;
                this.next();
            }
            isDouble = true;
        }
        this.token = isDouble ? 3 : 2;
    }

    public final Number scanNumberValue() {
        int len;
        long limit;
        boolean negative;
        int start = this.bp++;
        boolean overflow = false;
        Number number = null;
        this.np = 0;
        if (this.ch == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++this.np;
            int index = this.bp;
            this.ch = (char)(index >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            negative = false;
            limit = -9223372036854775807L;
        }
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            int index;
            int digit = this.ch - 48;
            if (longValue < -922337203685477580L) {
                overflow = true;
            }
            if ((longValue *= 10L) < limit + (long)digit) {
                overflow = true;
            }
            longValue -= (long)digit;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        }
        if (!negative) {
            longValue = -longValue;
        }
        if (this.ch == 'L') {
            ++this.np;
            this.next();
            number = longValue;
        } else if (this.ch == 'S') {
            ++this.np;
            this.next();
            number = (short)longValue;
        } else if (this.ch == 'B') {
            ++this.np;
            this.next();
            number = (byte)longValue;
        } else if (this.ch == 'F') {
            ++this.np;
            this.next();
            number = Float.valueOf(longValue);
        } else if (this.ch == 'D') {
            ++this.np;
            this.next();
            number = longValue;
        }
        boolean isDouble = false;
        boolean exp = false;
        if (this.ch == '.') {
            int index;
            isDouble = true;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.np;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
        }
        int type = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            int index;
            ++this.np;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            if (this.ch == '+' || this.ch == '-') {
                ++this.np;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.np;
                this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.np;
                type = this.ch;
                this.next();
            }
            exp = true;
        }
        if (!isDouble && !exp) {
            if (overflow) {
                len = this.bp - start;
                char[] chars = new char[len];
                this.text.getChars(start, this.bp, chars, 0);
                String strVal = new String(chars);
                number = new BigInteger(strVal);
            }
            if (number == null) {
                number = longValue > Integer.MIN_VALUE && longValue < Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
            }
            return number;
        }
        len = this.bp - start;
        if (type != 0) {
            --len;
        }
        char[] chars = new char[len];
        this.text.getChars(start, start + len, chars, 0);
        if (!exp && (this.features & Feature.UseBigDecimal.mask) != 0) {
            number = new BigDecimal(chars);
        } else {
            String strVal = new String(chars);
            try {
                number = type == 70 ? (Number)Float.valueOf(strVal) : (Number)Double.parseDouble(strVal);
            }
            catch (NumberFormatException ex) {
                throw new JSONException(ex.getMessage() + ", " + this.info(), ex);
            }
        }
        return number;
    }

    public final long longValue() throws NumberFormatException {
        int digit;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            int index;
            int chLocal;
            int n = chLocal = (index = i++) >= this.len ? 26 : (int)this.text.charAt(index);
            if (chLocal == 76 || chLocal == 83 || chLocal == 66) break;
            digit = digits[chLocal];
            if (result < -922337203685477580L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public final Number decimalValue(boolean decimal) {
        char chLocal = this.charAt(this.np + this.sp - 1);
        try {
            if (chLocal == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (chLocal == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (decimal) {
                return this.decimalValue();
            }
            return Double.parseDouble(this.numberString());
        }
        catch (NumberFormatException ex) {
            throw new JSONException(ex.getMessage() + ", " + this.info());
        }
    }

    public final BigDecimal decimalValue() {
        return new BigDecimal(this.numberString());
    }

    public boolean matchField(char[] fieldName) {
        if (!this.charArrayCompare(fieldName)) {
            return false;
        }
        this.bp += fieldName.length;
        if (this.bp >= this.len) {
            throw new JSONException("unclosed str, " + this.info());
        }
        this.ch = this.text.charAt(this.bp);
        if (this.ch == '{') {
            int index;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.token = 12;
        } else if (this.ch == '[') {
            int index;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    private boolean charArrayCompare(char[] chars) {
        int destLen = chars.length;
        if (destLen + this.bp > this.len) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (chars[i] == this.text.charAt(this.bp + i)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] fieldName) {
        int index;
        int value;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0;
        }
        int offset = fieldName.length;
        int chLocal = this.charAt(this.bp + offset++);
        boolean quote = false;
        if (chLocal == 34) {
            int index2;
            quote = true;
            int n = chLocal = (index2 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index2);
        }
        if (chLocal >= 48 && chLocal <= 57) {
            value = digits[chLocal];
            while ((chLocal = (int)this.charAt(this.bp + offset++)) >= 48 && chLocal <= 57) {
                value = value * 10 + digits[chLocal];
            }
            if (chLocal == 46) {
                this.matchStat = -1;
                return 0;
            }
            if (chLocal == 34) {
                if (!quote) {
                    this.matchStat = -1;
                    return 0;
                }
                int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return 0;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] fieldName) {
        int index;
        int index2;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0L;
        }
        int offset = fieldName.length;
        int chLocal = (index2 = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index2);
        boolean quote = false;
        if (chLocal == 34) {
            quote = true;
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
        }
        if (chLocal < 48 || chLocal > 57) {
            this.matchStat = -1;
            return 0L;
        }
        long value = digits[chLocal];
        while (true) {
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
            if (chLocal < 48 || chLocal > 57) break;
            value = value * 10L + (long)digits[chLocal];
        }
        if (chLocal == 46) {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == 34) {
            if (!quote) {
                this.matchStat = -1;
                return 0L;
            }
            int n = chLocal = (index = this.bp + offset++) >= this.len ? 26 : (int)this.text.charAt(index);
        }
        if (value < 0L) {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == 44) {
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != 125) {
            this.matchStat = -1;
            return 0L;
        }
        if ((chLocal = (int)this.charAt(this.bp + offset++)) == 44) {
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] fieldName) {
        int index;
        int index2;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int offset = fieldName.length;
        if ((index2 = this.bp + offset++) >= this.len) {
            throw new JSONException("unclosed str, " + this.info());
        }
        int chLocal = this.text.charAt(index2);
        if (chLocal != 34) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int quoteChar = 34;
        boolean hasSpecial = false;
        int startIndex = this.bp + offset;
        int endIndex = this.text.indexOf(34, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str, " + this.info());
        }
        String strVal = null;
        boolean match = false;
        if (V6) {
            strVal = this.text.substring(startIndex, endIndex);
            if (strVal.indexOf(92) == -1) {
                match = true;
            } else {
                hasSpecial = true;
            }
        }
        if (!match) {
            int chars_len = endIndex - startIndex;
            char[] chars = this.sub_chars(this.bp + offset, chars_len);
            while (chars_len > 0 && chars[chars_len - 1] == '\\') {
                int slashCount = 1;
                for (int i = chars_len - 2; i >= 0 && chars[i] == '\\'; ++slashCount, --i) {
                }
                if (slashCount % 2 == 0) break;
                int nextIndex = this.text.indexOf(34, endIndex + 1);
                int nextLen = nextIndex - endIndex;
                int next_chars_len = chars_len + nextLen;
                if (next_chars_len < chars.length) {
                    this.text.getChars(endIndex, nextIndex, chars, chars_len);
                } else {
                    chars = this.sub_chars(this.bp + offset, next_chars_len);
                }
                chars_len = next_chars_len;
                endIndex = nextIndex;
                hasSpecial = true;
            }
            if (!hasSpecial) {
                for (int i = 0; i < chars_len; ++i) {
                    if (chars[i] != '\\') continue;
                    hasSpecial = true;
                }
                strVal = hasSpecial ? JSONLexer.readString(chars, chars_len) : new String(chars, 0, chars_len);
            } else {
                strVal = JSONLexer.readString(chars, chars_len);
            }
        }
        int n = chLocal = (index = ++endIndex) >= this.len ? 26 : (int)this.text.charAt(index);
        if (chLocal != 125) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((chLocal = (int)this.charAt(++endIndex)) == 44) {
            this.token = 16;
            this.bp = endIndex;
            this.next();
        } else if (chLocal == 93) {
            this.token = 15;
            this.bp = endIndex;
            this.next();
        } else if (chLocal == 125) {
            this.token = 13;
            this.bp = endIndex;
            this.next();
        } else {
            if (chLocal != 26) {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp = endIndex;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return false;
        }
        int offset = fieldName.length;
        if (this.text.startsWith("false", this.bp + offset)) {
            offset += 5;
            value = false;
        } else if (this.text.startsWith("true", this.bp + offset)) {
            offset += 4;
            value = true;
        } else if (this.text.startsWith("\"false\"", this.bp + offset)) {
            offset += 7;
            value = false;
        } else {
            if (!this.text.startsWith("\"true\"", this.bp + offset)) {
                this.matchStat = -1;
                return false;
            }
            offset += 6;
            value = true;
        }
        char chLocal = this.charAt(this.bp + offset++);
        if (chLocal == ',') {
            int index;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            int index;
            this.token = 16;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == ']') {
            int index;
            this.token = 15;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else if (chLocal == '}') {
            int index;
            this.token = 13;
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] fieldName) {
        float value;
        char chLocal;
        int offset;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block14;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Float.parseFloat(text);
                    if (chLocal != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] fieldName) {
        double value;
        char chLocal;
        int offset;
        block18: {
            block19: {
                block17: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block17;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (chLocal == 'e' || chLocal == 'E') {
                        if ((chLocal = this.charAt(this.bp + offset++)) == '+' || chLocal == '-') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                        while (chLocal >= '0' && chLocal <= '9') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Double.parseDouble(text);
                    if (chLocal != ',') break block18;
                    break block19;
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char chLocal;
        int offset;
        block12: {
            int index;
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(fieldName)) {
                    this.matchStat = -2;
                    return null;
                }
                offset = fieldName.length;
                if ((chLocal = this.charAt(this.bp + offset++)) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int hash = 0;
                do {
                    if ((chLocal = this.charAt(this.bp + offset++)) == '\"') {
                        int start = this.bp + fieldName.length + 1;
                        int len = this.bp + offset - start - 1;
                        strVal = symbolTable.addSymbol(this.text, start, len, hash);
                        if ((chLocal = this.charAt(this.bp + offset++)) != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + chLocal;
                } while (chLocal != '\\');
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.ch = (char)((index = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(index));
            this.matchStat = 3;
            return strVal;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        char S2;
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        char d1;
        char d0;
        char M1;
        char M0;
        char y3;
        char y2;
        char y1;
        int rest = this.text.length() - this.bp;
        if (!strict && rest > 13 && this.text.startsWith("/Date(", this.bp) && this.charAt(this.bp + rest - 1) == '/' && this.charAt(this.bp + rest - 2) == ')') {
            int plusIndex = -1;
            for (int i = 6; i < rest; ++i) {
                char c = this.charAt(this.bp + i);
                if (c == '+') {
                    plusIndex = i;
                    continue;
                }
                if (c < '0' || c > '9') break;
            }
            if (plusIndex == -1) {
                return false;
            }
            int offset = this.bp + 6;
            String numberText = this.subString(offset, plusIndex - offset);
            long millis = Long.parseLong(numberText);
            this.calendar = Calendar.getInstance(this.timeZone, this.locale);
            this.calendar.setTimeInMillis(millis);
            this.token = 5;
            return true;
        }
        if (rest == 8 || rest == 14 || rest == 17) {
            int seconds;
            int minute;
            int hour;
            int millis;
            char d12;
            char d02;
            char M12;
            char M02;
            char y32;
            char y22;
            char y12;
            if (strict) {
                return false;
            }
            char y0 = this.charAt(this.bp);
            if (!JSONLexer.checkDate(y0, y12 = this.charAt(this.bp + 1), y22 = this.charAt(this.bp + 2), y32 = this.charAt(this.bp + 3), M02 = this.charAt(this.bp + 4), M12 = this.charAt(this.bp + 5), d02 = this.charAt(this.bp + 6), d12 = this.charAt(this.bp + 7))) {
                return false;
            }
            this.setCalendar(y0, y12, y22, y32, M02, M12, d02, d12);
            if (rest != 8) {
                char s12;
                char s02;
                char m12;
                char m02;
                char h12;
                char h0 = this.charAt(this.bp + 8);
                if (!JSONLexer.checkTime(h0, h12 = this.charAt(this.bp + 9), m02 = this.charAt(this.bp + 10), m12 = this.charAt(this.bp + 11), s02 = this.charAt(this.bp + 12), s12 = this.charAt(this.bp + 13))) {
                    return false;
                }
                if (rest == 17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S1 = this.charAt(this.bp + 15);
                    char S22 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S1 < '0' || S1 > '9') {
                        return false;
                    }
                    if (S22 < '0' || S22 > '9') {
                        return false;
                    }
                    millis = digits[S0] * 100 + digits[S1] * 10 + digits[S22];
                } else {
                    millis = 0;
                }
                hour = digits[h0] * 10 + digits[h12];
                minute = digits[m02] * 10 + digits[m12];
                seconds = digits[s02] * 10 + digits[s12];
            } else {
                millis = 0;
                seconds = 0;
                minute = 0;
                hour = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < 10) {
            return false;
        }
        if (this.charAt(this.bp + 4) != '-') {
            return false;
        }
        if (this.charAt(this.bp + 7) != '-') {
            return false;
        }
        char y0 = this.charAt(this.bp);
        if (!JSONLexer.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 5), M1 = this.charAt(this.bp + 6), d0 = this.charAt(this.bp + 8), d1 = this.charAt(this.bp + 9))) {
            return false;
        }
        this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
        char t = this.charAt(this.bp + 10);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < 19) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            return false;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        if (!JSONLexer.checkTime(h0, h1 = this.charAt(this.bp + 12), m0 = this.charAt(this.bp + 14), m1 = this.charAt(this.bp + 15), s0 = this.charAt(this.bp + 17), s1 = this.charAt(this.bp + 18))) {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < 23) {
                return false;
            }
        } else {
            String[] timeZoneIDs;
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            if (dot == 'Z' && this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        int millis = digits[S0];
        int millisLen = 1;
        char S1 = this.charAt(this.bp + 21);
        if (S1 >= '0' && S1 <= '9') {
            millis = millis * 10 + digits[S1];
            millisLen = 2;
        }
        if (millisLen == 2 && (S2 = this.charAt(this.bp + 22)) >= '0' && S2 <= '9') {
            millis = millis * 10 + digits[S2];
            millisLen = 3;
        }
        this.calendar.set(14, millis);
        int timzeZoneLength = 0;
        char timeZoneFlag = this.charAt(this.bp + 20 + millisLen);
        if (timeZoneFlag == '+' || timeZoneFlag == '-') {
            String[] timeZoneIDs;
            char t3;
            char t0 = this.charAt(this.bp + 20 + millisLen + 1);
            if (t0 < '0' || t0 > '1') {
                return false;
            }
            char t1 = this.charAt(this.bp + 20 + millisLen + 2);
            if (t1 < '0' || t1 > '9') {
                return false;
            }
            char t2 = this.charAt(this.bp + 20 + millisLen + 3);
            if (t2 == ':') {
                t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                char t4 = this.charAt(this.bp + 20 + millisLen + 5);
                if (t4 != '0') {
                    return false;
                }
                timzeZoneLength = 6;
            } else if (t2 == '0') {
                t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                timzeZoneLength = 5;
            } else {
                timzeZoneLength = 3;
            }
            int timeZoneOffset = (digits[t0] * 10 + digits[t1]) * 3600 * 1000;
            if (timeZoneFlag == '-') {
                timeZoneOffset = -timeZoneOffset;
            }
            if (this.calendar.getTimeZone().getRawOffset() != timeZoneOffset && (timeZoneIDs = TimeZone.getAvailableIDs(timeZoneOffset)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        } else if (timeZoneFlag == 'Z') {
            String[] timeZoneIDs;
            timzeZoneLength = 1;
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        }
        char end = this.charAt(this.bp + (20 + millisLen + timzeZoneLength));
        if (end != '\u001a' && end != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += 20 + millisLen + timzeZoneLength);
        this.token = 5;
        return true;
    }

    static boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static final byte[] decodeFast(char[] chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars[eIx]] < 0) {
            --eIx;
        }
        int pad = chars[eIx] == '=' ? (chars[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[chars[sIx++]] << 18 | IA[chars[sIx++]] << 12 | IA[chars[sIx++]] << 6 | IA[chars[sIx++]];
            bytes[d++] = (byte)(i >> 16);
            bytes[d++] = (byte)(i >> 8);
            bytes[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[chars[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                bytes[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return bytes;
    }

    public static final byte[] decodeFast(String chars, int offset, int charsLen) {
        int sIx;
        if (charsLen == 0) {
            return new byte[0];
        }
        int eIx = offset + charsLen - 1;
        for (sIx = offset; sIx < eIx && IA[chars.charAt(sIx)] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[chars.charAt(eIx)] < 0) {
            --eIx;
        }
        int pad = chars.charAt(eIx) == '=' ? (chars.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = charsLen > 76 ? (chars.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] bytes = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[chars.charAt(sIx++)] << 18 | IA[chars.charAt(sIx++)] << 12 | IA[chars.charAt(sIx++)] << 6 | IA[chars.charAt(sIx++)];
            bytes[d++] = (byte)(i >> 16);
            bytes[d++] = (byte)(i >> 8);
            bytes[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[chars.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                bytes[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return bytes;
    }

    public static final byte[] decodeFast(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        int c;
        int i;
        int version = -1;
        try {
            Class<?> clazz = Class.forName("android.os.Build$VERSION");
            Field field = clazz.getField("SDK_INT");
            version = field.getInt(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        V6 = version >= 23;
        sbufLocal = new ThreadLocal();
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONLexer.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONLexer.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONLexer.digits[i] = i - 65 + 10;
        }
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            JSONLexer.IA[JSONLexer.CA[i]] = i;
        }
        JSONLexer.IA[61] = 0;
        firstIdentifierFlags = new boolean[256];
        for (c = 0; c < firstIdentifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                JSONLexer.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                JSONLexer.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c != 95) continue;
            JSONLexer.firstIdentifierFlags[c] = true;
        }
        identifierFlags = new boolean[256];
        for (c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c == 95) {
                JSONLexer.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            JSONLexer.identifierFlags[c] = true;
        }
    }
}

