/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static MapCodec instance = new MapCodec();

    private MapCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        boolean containsKey;
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        TreeMap map = (TreeMap)object;
        Class<?> mapClass = map.getClass();
        boolean bl = containsKey = (mapClass == JSONObject.class || mapClass == HashMap.class || mapClass == LinkedHashMap.class) && map.containsKey("@type");
        if ((out.features & SerializerFeature.SortField.mask) != 0 && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            try {
                map = new TreeMap(map);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (serializer.references != null && serializer.references.containsKey(object)) {
            serializer.writeReference(object);
            return;
        }
        SerialContext parent = serializer.context;
        serializer.setContext(parent, object, fieldName, 0);
        try {
            out.write(123);
            serializer.incrementIndent();
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            boolean first = true;
            if ((out.features & SerializerFeature.WriteClassName.mask) != 0 && !containsKey) {
                out.writeFieldName("@type", false);
                out.writeString(object.getClass().getName());
                first = false;
            }
            for (Map.Entry entry : map.entrySet()) {
                List<ValueFilter> valueFilters;
                String strKey;
                Object value = entry.getValue();
                Object entryKey = entry.getKey();
                List<PropertyPreFilter> preFilters = serializer.getPropertyPreFiltersDirect();
                if (preFilters != null && preFilters.size() > 0 && (entryKey != null && !(entryKey instanceof String) ? (entryKey.getClass().isPrimitive() || entryKey instanceof Number) && !JSONSerializer.applyName(serializer, object, strKey = JSON.toJSONString(entryKey)) : !JSONSerializer.applyName(serializer, object, (String)entryKey))) continue;
                List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
                if (propertyFilters != null && propertyFilters.size() > 0 && (entryKey != null && !(entryKey instanceof String) ? (entryKey.getClass().isPrimitive() || entryKey instanceof Number) && !JSONSerializer.apply(serializer, object, strKey = JSON.toJSONString(entryKey), value) : !JSONSerializer.apply(serializer, object, (String)entryKey, value))) continue;
                List<NameFilter> nameFilters = serializer.getNameFiltersDirect();
                if (nameFilters != null && nameFilters.size() > 0) {
                    if (entryKey == null || entryKey instanceof String) {
                        entryKey = JSONSerializer.processKey(serializer, object, (String)entryKey, value);
                    } else if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                        strKey = JSON.toJSONString(entryKey);
                        entryKey = JSONSerializer.processKey(serializer, object, strKey, value);
                    }
                }
                if ((valueFilters = serializer.getValueFiltersDirect()) != null && valueFilters.size() > 0) {
                    if (entryKey == null || entryKey instanceof String) {
                        value = JSONSerializer.processValue(serializer, object, (String)entryKey, value);
                    } else if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                        strKey = JSON.toJSONString(entryKey);
                        value = JSONSerializer.processValue(serializer, object, strKey, value);
                    }
                }
                if (value == null && (out.features & SerializerFeature.WriteMapNullValue.mask) == 0) continue;
                if (entryKey instanceof String) {
                    String key = (String)entryKey;
                    if (!first) {
                        out.write(44);
                    }
                    if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                        serializer.println();
                    }
                    out.writeFieldName(key, true);
                } else {
                    if (!first) {
                        out.write(44);
                    }
                    if ((out.features & SerializerFeature.BrowserCompatible.mask) != 0 || (out.features & SerializerFeature.WriteNonStringKeyAsString.mask) != 0) {
                        String strEntryKey = JSON.toJSONString(entryKey);
                        serializer.write(strEntryKey);
                    } else {
                        serializer.write(entryKey);
                    }
                    out.write(58);
                }
                first = false;
                if (value == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = value.getClass();
                if (clazz == preClazz) {
                    preWriter.write(serializer, value, entryKey, null);
                    continue;
                }
                preClazz = clazz;
                preWriter = serializer.getObjectWriter(clazz);
                preWriter.write(serializer, value, entryKey, null);
            }
        }
        finally {
            serializer.context = parent;
        }
        serializer.decrementIdent();
        if ((out.features & SerializerFeature.PrettyFormat.mask) != 0 && map.size() > 0) {
            serializer.println();
        }
        out.write(125);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type == JSONObject.class) {
            return (T)parser.parseObject();
        }
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        Map<Object, Object> map = this.createMap(type);
        ParseContext context = parser.getContext();
        try {
            parser.setContext(context, map, fieldName);
            Object object = this.deserialze(parser, type, fieldName, map);
            return (T)object;
        }
        finally {
            parser.setContext(context);
        }
    }

    protected Object deserialze(DefaultJSONParser parser, Type type, Object fieldName, Map map) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            if (String.class == keyType) {
                return MapCodec.parseMap(parser, map, valueType, fieldName);
            }
            return MapCodec.parseMap(parser, map, keyType, valueType, fieldName);
        }
        return parser.parseObject(map, fieldName);
    }

    public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object value;
                String key;
                lexer.skipWhitespace();
                char ch = lexer.getCurrent();
                if ((lexer.features & Feature.AllowArbitraryCommas.mask) != 0) {
                    while (ch == ',') {
                        lexer.next();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                if (ch == '\"') {
                    key = lexer.scanSymbol(parser.symbolTable, '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (ch == '}') {
                        lexer.next();
                        lexer.resetStringPosition();
                        lexer.nextToken(16);
                        Map<String, Object> map2 = map;
                        return map2;
                    }
                    if (ch == '\'') {
                        if ((lexer.features & Feature.AllowSingleQuotes.mask) == 0) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(parser.symbolTable, '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if ((lexer.features & Feature.AllowUnQuotedFieldNames.mask) == 0) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbolUnQuoted(parser.symbolTable);
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                        }
                    }
                }
                lexer.next();
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                if (key == "@type") {
                    String typeName = lexer.scanSymbol(parser.symbolTable, '\"');
                    Class<?> clazz = TypeUtils.loadClass(typeName, parser.config.defaultClassLoader);
                    if (clazz == map.getClass()) {
                        lexer.nextToken(16);
                        if (lexer.token() != 13) continue;
                        lexer.nextToken(16);
                        Map<String, Object> map3 = map;
                        return map3;
                    }
                    ObjectDeserializer deserializer = parser.config.getDeserializer(clazz);
                    lexer.nextToken(16);
                    parser.resolveStatus = 2;
                    if (context != null && !(fieldName instanceof Integer)) {
                        parser.popContext();
                    }
                    Map map4 = (Map)deserializer.deserialze(parser, clazz, fieldName);
                    return map4;
                }
                lexer.nextToken();
                if (lexer.token() == 8) {
                    value = null;
                    lexer.nextToken();
                } else {
                    value = parser.parseObject(valueType);
                }
                map.put(key, value);
                parser.checkMapResolve(map, key);
                parser.setContext(context, value, key);
                int tok = lexer.token();
                if (tok == 20 || tok == 15) {
                    Map<String, Object> map5 = map;
                    return map5;
                }
                if (tok != 13) continue;
                lexer.nextToken();
                Map<String, Object> map6 = map;
                return map6;
            }
        }
        finally {
            parser.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseMap(DefaultJSONParser parser, Map<Object, Object> map, Type keyType, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ObjectDeserializer keyDeserializer = parser.config.getDeserializer(keyType);
        ObjectDeserializer valueDeserializer = parser.config.getDeserializer(valueType);
        lexer.nextToken();
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object object;
                int token;
                if ((token = lexer.token()) == 13) {
                    lexer.nextToken(16);
                    break;
                }
                if (token == 4 && lexer.isRef()) {
                    Object ref;
                    object = null;
                    lexer.nextTokenWithChar(':');
                    if (lexer.token() == 4) {
                        ref = lexer.stringVal();
                        if ("..".equals(ref)) {
                            ParseContext parentContext = context.parent;
                            object = parentContext.object;
                        } else if ("$".equals(ref)) {
                            ParseContext rootContext = context;
                            while (rootContext.parent != null) {
                                rootContext = rootContext.parent;
                            }
                            object = rootContext.object;
                        } else {
                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                            parser.resolveStatus = 1;
                        }
                    } else {
                        throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                    }
                    lexer.nextToken(13);
                    if (lexer.token() != 13) {
                        throw new JSONException("illegal ref");
                    }
                    lexer.nextToken(16);
                    ref = object;
                    return ref;
                }
                if (map.size() == 0 && token == 4 && "@type".equals(lexer.stringVal())) {
                    lexer.nextTokenWithChar(':');
                    lexer.nextToken(16);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        object = map;
                        return object;
                    }
                    lexer.nextToken();
                }
                Object key = keyDeserializer.deserialze(parser, keyType, null);
                if (lexer.token() != 17) {
                    throw new JSONException("syntax error, expect :, actual " + lexer.token());
                }
                lexer.nextToken();
                Object value = valueDeserializer.deserialze(parser, valueType, key);
                map.put(key, value);
                if (lexer.token() != 16) continue;
                lexer.nextToken();
            }
        }
        finally {
            parser.setContext(context);
        }
        return map;
    }

    protected Map<Object, Object> createMap(Type type) {
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type == Map.class || type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.createMap(parameterizedType.getRawType());
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new JSONException("unsupport type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("unsupport type " + type, e);
        }
    }
}

