/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        boolean writeClassName = (out.features & SerializerFeature.WriteClassName.mask) != 0;
        Type elementType = null;
        if (writeClassName && fieldType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)fieldType;
            elementType = param.getActualTypeArguments()[0];
        }
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        List list = (List)object;
        int size = list.size();
        if (size == 0) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.context;
        if ((out.features & SerializerFeature.DisableCircularReferenceDetect.mask) == 0) {
            serializer.context = new SerialContext(context, object, fieldName, 0);
            if (serializer.references == null) {
                serializer.references = new IdentityHashMap();
            }
            serializer.references.put(object, context);
        }
        ObjectSerializer itemSerializer = null;
        try {
            if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                out.write(91);
                serializer.incrementIndent();
                for (int i = 0; i < size; ++i) {
                    Object item = list.get(i);
                    if (i != 0) {
                        out.write(44);
                    }
                    serializer.println();
                    if (item != null) {
                        SerialContext itemContext;
                        if (serializer.references != null && serializer.references.containsKey(item)) {
                            serializer.writeReference(item);
                            continue;
                        }
                        itemSerializer = serializer.getObjectWriter(item.getClass());
                        serializer.context = itemContext = new SerialContext(context, object, fieldName, 0);
                        itemSerializer.write(serializer, item, i, elementType);
                        continue;
                    }
                    serializer.out.writeNull();
                }
                serializer.decrementIdent();
                serializer.println();
                out.write(93);
                return;
            }
            int newcount = out.count + 1;
            if (newcount > out.buf.length) {
                if (out.writer == null) {
                    out.expandCapacity(newcount);
                } else {
                    out.flush();
                    newcount = 1;
                }
            }
            out.buf[out.count] = 91;
            out.count = newcount;
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                if (i != 0) {
                    int newcount2 = out.count + 1;
                    if (newcount2 > out.buf.length) {
                        if (out.writer == null) {
                            out.expandCapacity(newcount2);
                        } else {
                            out.flush();
                            newcount2 = 1;
                        }
                    }
                    out.buf[out.count] = 44;
                    out.count = newcount2;
                }
                if (item == null) {
                    out.append("null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    if (writeClassName) {
                        out.writeLong(val);
                        out.write(76);
                        continue;
                    }
                    out.writeLong(val);
                    continue;
                }
                if (clazz == String.class) {
                    String itemStr = (String)item;
                    if ((out.features & SerializerFeature.UseSingleQuotes.mask) != 0) {
                        out.writeStringWithSingleQuote(itemStr);
                        continue;
                    }
                    out.writeStringWithDoubleQuote(itemStr, '\u0000', true);
                    continue;
                }
                if ((out.features & SerializerFeature.DisableCircularReferenceDetect.mask) == 0) {
                    SerialContext itemContext;
                    serializer.context = itemContext = new SerialContext(context, object, fieldName, 0);
                }
                if (serializer.references != null && serializer.references.containsKey(item)) {
                    serializer.writeReference(item);
                    continue;
                }
                itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i, elementType);
            }
            newcount = out.count + 1;
            if (newcount > out.buf.length) {
                if (out.writer == null) {
                    out.expandCapacity(newcount);
                } else {
                    out.flush();
                    newcount = 1;
                }
            }
            out.buf[out.count] = 93;
            out.count = newcount;
        }
        finally {
            serializer.context = context;
        }
    }
}

