/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaObjectDeserializer
implements ObjectDeserializer {
    public static final JavaObjectDeserializer instance = new JavaObjectDeserializer();

    JavaObjectDeserializer() {
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                TypeVariable componentVar = (TypeVariable)componentType;
                componentType = componentVar.getBounds()[0];
            }
            ArrayList list = new ArrayList();
            parser.parseArray(componentType, list);
            if (componentType instanceof Class) {
                Class componentClass = (Class)componentType;
                if (componentClass == Boolean.TYPE) {
                    return (T)TypeUtils.cast(list, boolean[].class, parser.config);
                }
                if (componentClass == Short.TYPE) {
                    return (T)TypeUtils.cast(list, short[].class, parser.config);
                }
                if (componentClass == Integer.TYPE) {
                    return (T)TypeUtils.cast(list, int[].class, parser.config);
                }
                if (componentClass == Long.TYPE) {
                    return (T)TypeUtils.cast(list, long[].class, parser.config);
                }
                if (componentClass == Float.TYPE) {
                    return (T)TypeUtils.cast(list, float[].class, parser.config);
                }
                if (componentClass == Double.TYPE) {
                    return (T)TypeUtils.cast(list, double[].class, parser.config);
                }
                Object[] array = (Object[])Array.newInstance(componentClass, list.size());
                list.toArray(array);
                return (T)array;
            }
            return (T)list.toArray();
        }
        return (T)parser.parse(fieldName);
    }
}

