/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NumberFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;
    private final FieldSerializer[] sortedGetters;
    private int features = 0;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        this.features = TypeUtils.getSerializeFeatures(clazz);
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(clazz, aliasMap, false);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        getterList = new ArrayList();
        fieldInfoList = TypeUtils.computeGetters(clazz, aliasMap, true);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.sortedGetters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    protected boolean isWriteClassName(JSONSerializer serializer, Object obj, Type fieldType, Object fieldName) {
        return serializer.isWriteClassName(fieldType, obj);
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        if (this.writeReference(serializer, object)) {
            return;
        }
        FieldSerializer[] getters = out.isEnabled(SerializerFeature.SortField) ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName, this.features);
        boolean writeAsArray = this.isWriteAsArray(serializer);
        try {
            Class<?> objClass;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char endSeperator = writeAsArray ? (char)']' : '}';
            out.append(startSeperator);
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer, object, fieldType, fieldName) && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                serializer.write(object.getClass());
                commaFlag = true;
            }
            char seperator = commaFlag ? (char)',' : '\u0000';
            char newSeperator = FilterUtils.writeBefore(serializer, object, seperator);
            commaFlag = newSeperator == ',';
            for (int i = 0; i < getters.length; ++i) {
                Class<?> fieldCLass;
                Field field;
                FieldSerializer fieldSerializer = getters[i];
                if (serializer.isEnabled(SerializerFeature.SkipTransientField) && (field = fieldSerializer.getField()) != null && Modifier.isTransient(field.getModifiers()) || !FilterUtils.applyName(serializer, object, fieldSerializer.getName())) continue;
                Object propertyValue = fieldSerializer.getPropertyValue(object);
                if (!FilterUtils.apply(serializer, object, fieldSerializer.getName(), propertyValue)) continue;
                String key = FilterUtils.processKey(serializer, object, fieldSerializer.getName(), propertyValue);
                Object originalValue = propertyValue;
                propertyValue = FilterUtils.processValue(serializer, object, fieldSerializer.getName(), propertyValue);
                if (propertyValue == null && !writeAsArray && !fieldSerializer.isWriteNull() && !serializer.isEnabled(SerializerFeature.WriteMapNullValue) || propertyValue != null && serializer.isEnabled(SerializerFeature.NotWriteDefaultValue) && ((fieldCLass = fieldSerializer.fieldInfo.getFieldClass()) == Byte.TYPE && propertyValue instanceof Byte && (Byte)propertyValue == 0 || fieldCLass == Short.TYPE && propertyValue instanceof Short && (Short)propertyValue == 0 || fieldCLass == Integer.TYPE && propertyValue instanceof Integer && (Integer)propertyValue == 0 || fieldCLass == Long.TYPE && propertyValue instanceof Long && (Long)propertyValue == 0L || fieldCLass == Float.TYPE && propertyValue instanceof Float && ((Float)propertyValue).floatValue() == 0.0f || fieldCLass == Double.TYPE && propertyValue instanceof Double && (Double)propertyValue == 0.0 || fieldCLass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue())) continue;
                if (commaFlag) {
                    out.append(',');
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                }
                if (key != fieldSerializer.getName()) {
                    if (!writeAsArray) {
                        out.writeFieldName(key);
                    }
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else if (!writeAsArray) {
                    fieldSerializer.writeProperty(serializer, propertyValue);
                } else {
                    fieldSerializer.writeValue(serializer, propertyValue);
                }
                commaFlag = true;
            }
            FilterUtils.writeAfter(serializer, object, commaFlag ? (char)',' : '\u0000');
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.append(endSeperator);
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
        finally {
            serializer.setContext(parent);
        }
    }

    public boolean writeReference(JSONSerializer serializer, Object object) {
        SerialContext context = serializer.getContext();
        if (context != null && context.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return false;
        }
        if (!serializer.containsReference(object)) {
            return false;
        }
        serializer.writeReference(object);
        return true;
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getFieldClass();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }

    public boolean isWriteAsArray(JSONSerializer serializer) {
        if (SerializerFeature.isEnabled(this.features, SerializerFeature.BeanToArray)) {
            return true;
        }
        boolean writeAsArray = serializer.isEnabled(SerializerFeature.BeanToArray);
        return writeAsArray;
    }
}

