/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.util.MapUtils;
import java.util.Map;

public class ConverterKeyBuild {
    private static final Map<String, String> BOXING_MAP = MapUtils.newHashMap();

    public static String buildKey(Class<?> clazz) {
        String className = clazz.getName();
        String boxingClassName = BOXING_MAP.get(clazz.getName());
        if (boxingClassName == null) {
            return className;
        }
        return boxingClassName;
    }

    public static String buildKey(Class<?> clazz, CellDataTypeEnum cellDataTypeEnum) {
        String key = ConverterKeyBuild.buildKey(clazz);
        if (cellDataTypeEnum == null) {
            return key;
        }
        return key + "-" + (Object)((Object)cellDataTypeEnum);
    }

    static {
        BOXING_MAP.put(Integer.TYPE.getName(), Integer.class.getName());
        BOXING_MAP.put(Byte.TYPE.getName(), Byte.class.getName());
        BOXING_MAP.put(Long.TYPE.getName(), Long.class.getName());
        BOXING_MAP.put(Double.TYPE.getName(), Double.class.getName());
        BOXING_MAP.put(Float.TYPE.getName(), Float.class.getName());
        BOXING_MAP.put(Character.TYPE.getName(), Character.class.getName());
        BOXING_MAP.put(Short.TYPE.getName(), Short.class.getName());
        BOXING_MAP.put(Boolean.TYPE.getName(), Boolean.class.getName());
    }
}

