/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.metadata.holder;

import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.cache.selector.EternalReadCacheSelector;
import com.alibaba.excel.cache.selector.ReadCacheSelector;
import com.alibaba.excel.cache.selector.SimpleReadCacheSelector;
import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.AbstractReadHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ReadWorkbookHolder
extends AbstractReadHolder {
    private ReadWorkbook readWorkbook;
    private InputStream inputStream;
    private File file;
    private Boolean mandatoryUseInputStream;
    private Boolean autoCloseStream;
    private ExcelTypeEnum excelType;
    private Object customObject;
    private Boolean ignoreEmptyRow;
    private ReadCache readCache;
    private ReadCacheSelector readCacheSelector;
    private File tempFile;
    private String password;
    @Deprecated
    private Boolean convertAllFiled;
    @Deprecated
    private Boolean defaultReturnMap;
    private Set<Integer> hasReadSheet;
    private OPCPackage opcPackage;
    private POIFSFileSystem poifsFileSystem;
    private Boolean ignoreRecord03;

    public ReadWorkbookHolder(ReadWorkbook readWorkbook) {
        super(readWorkbook, null, readWorkbook.getConvertAllFiled());
        this.readWorkbook = readWorkbook;
        if (readWorkbook.getInputStream() != null) {
            this.inputStream = readWorkbook.getInputStream().markSupported() ? readWorkbook.getInputStream() : new BufferedInputStream(readWorkbook.getInputStream());
        }
        this.file = readWorkbook.getFile();
        if (this.file == null && this.inputStream == null) {
            throw new ExcelAnalysisException("File and inputStream must be a non-null.");
        }
        this.mandatoryUseInputStream = readWorkbook.getMandatoryUseInputStream() == null ? Boolean.FALSE : readWorkbook.getMandatoryUseInputStream();
        this.autoCloseStream = readWorkbook.getAutoCloseStream() == null ? Boolean.TRUE : readWorkbook.getAutoCloseStream();
        this.excelType = ExcelTypeEnum.valueOf(this.file, this.inputStream, readWorkbook.getExcelType());
        if (ExcelTypeEnum.XLS == this.excelType && this.getGlobalConfiguration().getUse1904windowing() == null) {
            this.getGlobalConfiguration().setUse1904windowing(Boolean.FALSE);
        }
        this.customObject = readWorkbook.getCustomObject();
        this.ignoreEmptyRow = readWorkbook.getIgnoreEmptyRow() == null ? Boolean.TRUE : readWorkbook.getIgnoreEmptyRow();
        if (readWorkbook.getReadCache() != null) {
            if (readWorkbook.getReadCacheSelector() != null) {
                throw new ExcelAnalysisException("'readCache' and 'readCacheSelector' only one choice.");
            }
            this.readCacheSelector = new EternalReadCacheSelector(readWorkbook.getReadCache());
        } else {
            this.readCacheSelector = readWorkbook.getReadCacheSelector() == null ? new SimpleReadCacheSelector() : readWorkbook.getReadCacheSelector();
        }
        this.defaultReturnMap = readWorkbook.getDefaultReturnMap() == null ? Boolean.TRUE : readWorkbook.getDefaultReturnMap();
        this.hasReadSheet = new HashSet<Integer>();
        this.ignoreRecord03 = Boolean.FALSE;
        this.password = readWorkbook.getPassword();
    }

    public ReadWorkbook getReadWorkbook() {
        return this.readWorkbook;
    }

    public void setReadWorkbook(ReadWorkbook readWorkbook) {
        this.readWorkbook = readWorkbook;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Boolean getAutoCloseStream() {
        return this.autoCloseStream;
    }

    public void setAutoCloseStream(Boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(Object customObject) {
        this.customObject = customObject;
    }

    public Boolean getIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public void setIgnoreEmptyRow(Boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
    }

    public ReadCache getReadCache() {
        return this.readCache;
    }

    public void setReadCache(ReadCache readCache) {
        this.readCache = readCache;
    }

    public ReadCacheSelector getReadCacheSelector() {
        return this.readCacheSelector;
    }

    public void setReadCacheSelector(ReadCacheSelector readCacheSelector) {
        this.readCacheSelector = readCacheSelector;
    }

    public Boolean getMandatoryUseInputStream() {
        return this.mandatoryUseInputStream;
    }

    public void setMandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.mandatoryUseInputStream = mandatoryUseInputStream;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public Boolean getConvertAllFiled() {
        return this.convertAllFiled;
    }

    public void setConvertAllFiled(Boolean convertAllFiled) {
        this.convertAllFiled = convertAllFiled;
    }

    public Set<Integer> getHasReadSheet() {
        return this.hasReadSheet;
    }

    public void setHasReadSheet(Set<Integer> hasReadSheet) {
        this.hasReadSheet = hasReadSheet;
    }

    public Boolean getDefaultReturnMap() {
        return this.defaultReturnMap;
    }

    public void setDefaultReturnMap(Boolean defaultReturnMap) {
        this.defaultReturnMap = defaultReturnMap;
    }

    public OPCPackage getOpcPackage() {
        return this.opcPackage;
    }

    public void setOpcPackage(OPCPackage opcPackage) {
        this.opcPackage = opcPackage;
    }

    public POIFSFileSystem getPoifsFileSystem() {
        return this.poifsFileSystem;
    }

    public void setPoifsFileSystem(POIFSFileSystem poifsFileSystem) {
        this.poifsFileSystem = poifsFileSystem;
    }

    public Boolean getIgnoreRecord03() {
        return this.ignoreRecord03;
    }

    public void setIgnoreRecord03(Boolean ignoreRecord03) {
        this.ignoreRecord03 = ignoreRecord03;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.WORKBOOK;
    }
}

