/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;

public class NumberUtils {
    private NumberUtils() {
    }

    public static String format(Number num, ExcelContentProperty contentProperty) {
        if (contentProperty == null || contentProperty.getNumberFormatProperty() == null || StringUtils.isEmpty(contentProperty.getNumberFormatProperty().getFormat())) {
            if (num instanceof BigDecimal) {
                return ((BigDecimal)num).toPlainString();
            }
            return num.toString();
        }
        String format = contentProperty.getNumberFormatProperty().getFormat();
        RoundingMode roundingMode = contentProperty.getNumberFormatProperty().getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        return decimalFormat.format(num);
    }

    public static CellData formatToCellData(Number num, ExcelContentProperty contentProperty) {
        return new CellData(NumberUtils.format(num, contentProperty));
    }

    public static Short parseShort(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Short.valueOf(string);
        }
        return NumberUtils.parse(string, contentProperty).shortValue();
    }

    public static Long parseLong(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Long.valueOf(string);
        }
        return NumberUtils.parse(string, contentProperty).longValue();
    }

    public static Integer parseInteger(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Integer.valueOf(string);
        }
        return NumberUtils.parse(string, contentProperty).intValue();
    }

    public static Float parseFloat(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Float.valueOf(string);
        }
        return Float.valueOf(NumberUtils.parse(string, contentProperty).floatValue());
    }

    public static BigDecimal parseBigDecimal(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return new BigDecimal(string);
        }
        return BigDecimal.valueOf(NumberUtils.parse(string, contentProperty).doubleValue());
    }

    public static Byte parseByte(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Byte.valueOf(string);
        }
        return NumberUtils.parse(string, contentProperty).byteValue();
    }

    public static Double parseDouble(String string, ExcelContentProperty contentProperty) throws ParseException {
        if (!NumberUtils.hasFormat(contentProperty)) {
            return Double.valueOf(string);
        }
        return NumberUtils.parse(string, contentProperty).doubleValue();
    }

    private static boolean hasFormat(ExcelContentProperty contentProperty) {
        return contentProperty != null && contentProperty.getNumberFormatProperty() != null && !StringUtils.isEmpty(contentProperty.getNumberFormatProperty().getFormat());
    }

    private static Number parse(String string, ExcelContentProperty contentProperty) throws ParseException {
        String format = contentProperty.getNumberFormatProperty().getFormat();
        RoundingMode roundingMode = contentProperty.getNumberFormatProperty().getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        return decimalFormat.parse(string);
    }
}

