/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style;

import com.alibaba.excel.event.NotRepeatExecutor;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractCellStyleStrategy
implements CellWriteHandler,
SheetWriteHandler,
NotRepeatExecutor {
    boolean hasInitialized = false;

    @Override
    public String uniqueValue() {
        return "CellStyleStrategy";
    }

    @Override
    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        this.initCellStyle(writeWorkbookHolder.getWorkbook());
        this.hasInitialized = true;
    }

    @Override
    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, int relativeRowIndex, boolean isHead) {
        if (!this.hasInitialized) {
            this.initCellStyle(writeSheetHolder.getParentWriteWorkbookHolder().getWorkbook());
            this.hasInitialized = true;
        }
    }

    @Override
    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, int relativeRowIndex, boolean isHead) {
        if (isHead) {
            this.setHeadCellStyle(cell, head, relativeRowIndex);
        } else {
            this.setContentCellStyle(cell, head, relativeRowIndex);
        }
    }

    protected abstract void initCellStyle(Workbook var1);

    protected abstract void setHeadCellStyle(Cell var1, Head var2, int var3);

    protected abstract void setContentCellStyle(Cell var1, Head var2, int var3);
}

