/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;

public class WriteWorkbookHolder
extends AbstractWriteHolder {
    private Workbook workbook;
    private WriteWorkbook writeWorkbook;
    private File file;
    private OutputStream outputStream;
    private InputStream templateInputStream;
    private File templateFile;
    private Boolean autoCloseStream;
    private ExcelTypeEnum excelType;
    private Boolean mandatoryUseInputStream;
    private Map<Integer, WriteSheetHolder> hasBeenInitializedSheet;
    private Map<Integer, Integer> templateLastRowMap;

    public WriteWorkbookHolder(WriteWorkbook writeWorkbook) {
        super(writeWorkbook, null, writeWorkbook.getConvertAllFiled());
        this.writeWorkbook = writeWorkbook;
        this.file = writeWorkbook.getFile();
        if (this.file != null) {
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ExcelGenerateException("Can not found file.", e);
            }
        } else {
            this.outputStream = writeWorkbook.getOutputStream();
        }
        if (writeWorkbook.getTemplateInputStream() != null) {
            this.templateInputStream = writeWorkbook.getTemplateInputStream().markSupported() ? writeWorkbook.getTemplateInputStream() : new BufferedInputStream(writeWorkbook.getTemplateInputStream());
        }
        this.templateFile = writeWorkbook.getTemplateFile();
        this.autoCloseStream = writeWorkbook.getAutoCloseStream() == null ? Boolean.TRUE : writeWorkbook.getAutoCloseStream();
        this.excelType = writeWorkbook.getExcelType() == null ? (this.file != null && this.file.getName().endsWith(ExcelTypeEnum.XLS.getValue()) ? ExcelTypeEnum.XLS : ExcelTypeEnum.XLSX) : writeWorkbook.getExcelType();
        this.mandatoryUseInputStream = writeWorkbook.getMandatoryUseInputStream() == null ? Boolean.FALSE : writeWorkbook.getMandatoryUseInputStream();
        this.hasBeenInitializedSheet = new HashMap<Integer, WriteSheetHolder>();
        this.templateLastRowMap = new HashMap<Integer, Integer>(8);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Map<Integer, WriteSheetHolder> getHasBeenInitializedSheet() {
        return this.hasBeenInitializedSheet;
    }

    public void setHasBeenInitializedSheet(Map<Integer, WriteSheetHolder> hasBeenInitializedSheet) {
        this.hasBeenInitializedSheet = hasBeenInitializedSheet;
    }

    public WriteWorkbook getWriteWorkbook() {
        return this.writeWorkbook;
    }

    public void setWriteWorkbook(WriteWorkbook writeWorkbook) {
        this.writeWorkbook = writeWorkbook;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public Boolean getAutoCloseStream() {
        return this.autoCloseStream;
    }

    public void setAutoCloseStream(Boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public Boolean getMandatoryUseInputStream() {
        return this.mandatoryUseInputStream;
    }

    public void setMandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.mandatoryUseInputStream = mandatoryUseInputStream;
    }

    public Map<Integer, Integer> getTemplateLastRowMap() {
        return this.templateLastRowMap;
    }

    public void setTemplateLastRowMap(Map<Integer, Integer> templateLastRowMap) {
        this.templateLastRowMap = templateLastRowMap;
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.WORKBOOK;
    }
}

