/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07.handlers;

import com.alibaba.excel.analysis.v07.XlsxCellHandler;
import com.alibaba.excel.analysis.v07.XlsxRowResultHolder;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.util.BooleanUtils;
import com.alibaba.excel.util.PositionUtils;
import java.math.BigDecimal;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;

public class DefaultCellHandler
implements XlsxCellHandler,
XlsxRowResultHolder {
    private final AnalysisContext analysisContext;
    private Deque<String> currentTagDeque = new LinkedList<String>();
    private int curCol;
    private Map<Integer, CellData> curRowContent = new TreeMap<Integer, CellData>();
    private CellData currentCellData;
    private StringBuilder dataStringBuilder;
    private StringBuilder formulaStringBuilder;
    private StylesTable stylesTable;

    public DefaultCellHandler(AnalysisContext analysisContext, StylesTable stylesTable) {
        this.analysisContext = analysisContext;
        this.stylesTable = stylesTable;
    }

    @Override
    public void clearResult() {
        this.curRowContent = new TreeMap<Integer, CellData>();
    }

    @Override
    public boolean support(String name) {
        return "v".equals(name) || "f".equals(name) || "t".equals(name) || "c".equals(name);
    }

    @Override
    public void startHandle(String name, Attributes attributes) {
        this.currentTagDeque.push(name);
        if ("c".equals(name)) {
            this.curCol = PositionUtils.getCol(attributes.getValue("r"));
            CellDataTypeEnum type = CellDataTypeEnum.buildFromCellType(attributes.getValue("t"));
            this.currentCellData = new CellData(type);
            this.dataStringBuilder = new StringBuilder();
            String dateFormatIndex = attributes.getValue("s");
            if (dateFormatIndex != null) {
                int dateFormatIndexInteger = Integer.parseInt(dateFormatIndex);
                XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(dateFormatIndexInteger);
                short dataFormat = xssfCellStyle.getDataFormat();
                String dataFormatString = xssfCellStyle.getDataFormatString();
                this.currentCellData.setDataFormat(Integer.valueOf(dataFormat));
                if (dataFormatString == null) {
                    this.currentCellData.setDataFormatString(BuiltinFormats.getBuiltinFormat((int)dataFormat));
                } else {
                    this.currentCellData.setDataFormatString(dataFormatString);
                }
            }
        }
        if ("f".equals(name)) {
            this.currentCellData.setFormula(Boolean.TRUE);
            this.formulaStringBuilder = new StringBuilder();
        }
    }

    @Override
    public void endHandle(String name) {
        this.currentTagDeque.pop();
        if ("f".equals(name)) {
            this.currentCellData.setFormulaValue(this.formulaStringBuilder.toString());
            return;
        }
        if ("v".equals(name) || "t".equals(name)) {
            CellDataTypeEnum oldType = this.currentCellData.getType();
            switch (oldType) {
                case DIRECT_STRING: 
                case STRING: 
                case ERROR: {
                    this.currentCellData.setStringValue(this.dataStringBuilder.toString());
                    break;
                }
                case BOOLEAN: {
                    this.currentCellData.setBooleanValue(BooleanUtils.valueOf(this.dataStringBuilder.toString()));
                    break;
                }
                case NUMBER: 
                case EMPTY: {
                    this.currentCellData.setType(CellDataTypeEnum.NUMBER);
                    this.currentCellData.setNumberValue(new BigDecimal(this.dataStringBuilder.toString()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot set values now");
                }
            }
            if ("v".equals(name)) {
                if (this.currentCellData.getType() == CellDataTypeEnum.STRING) {
                    String stringValue = this.analysisContext.readWorkbookHolder().getReadCache().get(Integer.valueOf(this.currentCellData.getStringValue()));
                    if (stringValue != null && this.analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
                        stringValue = stringValue.trim();
                    }
                    this.currentCellData.setStringValue(stringValue);
                } else if (this.currentCellData.getType() == CellDataTypeEnum.DIRECT_STRING) {
                    this.currentCellData.setType(CellDataTypeEnum.STRING);
                }
            }
            if ("t".equals(name)) {
                XSSFRichTextString richTextString = new XSSFRichTextString(this.currentCellData.getStringValue());
                String stringValue = richTextString.toString();
                if (stringValue != null && this.analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
                    stringValue = stringValue.trim();
                }
                this.currentCellData.setStringValue(stringValue);
            }
            this.currentCellData.checkEmpty();
            this.curRowContent.put(this.curCol, this.currentCellData);
        }
    }

    @Override
    public void appendCurrentCellValue(char[] ch, int start, int length) {
        String currentTag = this.currentTagDeque.peek();
        if (currentTag == null) {
            return;
        }
        if ("f".equals(currentTag)) {
            this.formulaStringBuilder.append(ch, start, length);
            return;
        }
        if (!"v".equals(currentTag) && !"t".equals(currentTag)) {
            return;
        }
        this.dataStringBuilder.append(ch, start, length);
    }

    @Override
    public Map<Integer, CellData> getCurRowContent() {
        return this.curRowContent;
    }
}

