/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03;

import com.alibaba.excel.analysis.v03.XlsRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.BofRecordHandler;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadSheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XlsListSheetListener
implements HSSFListener {
    private POIFSFileSystem poifsFileSystem;
    private List<ReadSheet> sheetList;
    private XlsRecordHandler bofRecordHandler;

    public XlsListSheetListener(AnalysisContext analysisContext, POIFSFileSystem poifsFileSystem) {
        this.poifsFileSystem = poifsFileSystem;
        this.sheetList = new ArrayList<ReadSheet>();
        this.bofRecordHandler = new BofRecordHandler(analysisContext, this.sheetList, false);
        this.bofRecordHandler.init();
    }

    public void processRecord(Record record) {
        this.bofRecordHandler.processRecord(record);
    }

    public List<ReadSheet> getSheetList() {
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        FormatTrackingHSSFListener formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)formatListener);
        request.addListenerForAllRecords((HSSFListener)workbookBuildingListener);
        try {
            factory.processWorkbookEvents(request, this.poifsFileSystem);
        }
        catch (IOException e) {
            throw new ExcelAnalysisException(e);
        }
        return this.sheetList;
    }
}

