/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07;

import com.alibaba.excel.analysis.v07.XlsxCellHandler;
import com.alibaba.excel.analysis.v07.XlsxHandlerFactory;
import com.alibaba.excel.analysis.v07.XlsxRowResultHolder;
import com.alibaba.excel.context.AnalysisContext;
import java.util.List;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxRowHandler
extends DefaultHandler {
    private List<XlsxCellHandler> cellHandlers;
    private XlsxRowResultHolder rowResultHolder;

    public XlsxRowHandler(AnalysisContext analysisContext, StylesTable stylesTable) {
        this.cellHandlers = XlsxHandlerFactory.buildCellHandlers(analysisContext, stylesTable);
        for (XlsxCellHandler cellHandler : this.cellHandlers) {
            if (!(cellHandler instanceof XlsxRowResultHolder)) continue;
            this.rowResultHolder = (XlsxRowResultHolder)((Object)cellHandler);
            break;
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        for (XlsxCellHandler cellHandler : this.cellHandlers) {
            if (!cellHandler.support(name)) continue;
            cellHandler.startHandle(name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        for (XlsxCellHandler cellHandler : this.cellHandlers) {
            if (!cellHandler.support(name)) continue;
            cellHandler.endHandle(name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.rowResultHolder != null) {
            this.rowResultHolder.appendCurrentCellValue(new String(ch, start, length));
        }
    }
}

