/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03;

import com.alibaba.excel.analysis.ExcelExecutor;
import com.alibaba.excel.analysis.v03.XlsRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.BlankOrErrorRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.BofRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.FormulaRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.LabelRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.MissingCellDummyRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.NoteRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.NumberRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.RkRecordHandler;
import com.alibaba.excel.analysis.v03.handlers.SstRecordHandler;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.listener.event.EachRowAnalysisFinishEvent;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XlsSaxAnalyser
implements HSSFListener,
ExcelExecutor {
    private boolean outputFormulaValues = true;
    private POIFSFileSystem poifsFileSystem;
    private int lastRowNumber;
    private int lastColumnNumber;
    private boolean notAllEmpty = false;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private FormatTrackingHSSFListener formatListener;
    private Map<Integer, CellData> records;
    private List<ReadSheet> sheets = new ArrayList<ReadSheet>();
    private HSSFWorkbook stubWorkbook;
    private List<XlsRecordHandler> recordHandlers = new ArrayList<XlsRecordHandler>();
    private AnalysisContext analysisContext;

    public XlsSaxAnalyser(AnalysisContext context, POIFSFileSystem poifsFileSystem) throws IOException {
        this.analysisContext = context;
        this.records = new TreeMap<Integer, CellData>();
        this.poifsFileSystem = poifsFileSystem;
        this.analysisContext.readWorkbookHolder().setPoifsFileSystem(poifsFileSystem);
    }

    @Override
    public List<ReadSheet> sheetList() {
        return this.sheets;
    }

    @Override
    public void execute() {
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
        if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
            this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
        }
        this.init();
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        if (this.outputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        try {
            factory.processWorkbookEvents(request, this.poifsFileSystem);
        }
        catch (IOException e) {
            throw new ExcelAnalysisException(e);
        }
        if (!this.records.isEmpty()) {
            this.endRow();
        }
    }

    private void init() {
        this.lastRowNumber = 0;
        this.lastColumnNumber = 0;
        this.records = new TreeMap<Integer, CellData>();
        this.sheets = new ArrayList<ReadSheet>();
        this.buildXlsRecordHandlers();
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        CellData cellData = null;
        for (XlsRecordHandler handler : this.recordHandlers) {
            if (!handler.support(record)) continue;
            handler.processRecord(record);
            thisRow = handler.getRow();
            thisColumn = handler.getColumn();
            cellData = handler.getCellData();
            if (cellData == null) break;
            cellData.checkEmpty();
            this.records.put(thisColumn, cellData);
            break;
        }
        if (cellData != null) {
            if (this.analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue() && CellDataTypeEnum.STRING == cellData.getType()) {
                cellData.setStringValue(cellData.getStringValue().trim());
            }
            if (CellDataTypeEnum.EMPTY != cellData.getType()) {
                this.notAllEmpty = true;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        this.processLastCellOfRow(record);
    }

    private void processLastCellOfRow(Record record) {
        if (record instanceof LastCellOfRowDummyRecord) {
            this.endRow();
        }
    }

    private void endRow() {
        if (this.lastColumnNumber == -1) {
            this.lastColumnNumber = 0;
        }
        if (this.notAllEmpty) {
            this.analysisContext.readRowHolder(new ReadRowHolder(this.lastRowNumber, this.analysisContext.readSheetHolder().getGlobalConfiguration()));
            this.analysisContext.readSheetHolder().notifyEndOneRow(new EachRowAnalysisFinishEvent(this.records), this.analysisContext);
        }
        this.records.clear();
        this.lastColumnNumber = -1;
    }

    private void buildXlsRecordHandlers() {
        if (CollectionUtils.isEmpty(this.recordHandlers)) {
            this.recordHandlers.add(new BlankOrErrorRecordHandler());
            this.recordHandlers.add(new BofRecordHandler(this.workbookBuildingListener, this.analysisContext, this.sheets));
            this.recordHandlers.add(new FormulaRecordHandler(this.stubWorkbook, this.formatListener));
            this.recordHandlers.add(new LabelRecordHandler());
            this.recordHandlers.add(new NoteRecordHandler());
            this.recordHandlers.add(new NumberRecordHandler(this.formatListener));
            this.recordHandlers.add(new RkRecordHandler());
            this.recordHandlers.add(new SstRecordHandler());
            this.recordHandlers.add(new MissingCellDummyRecordHandler());
            Collections.sort(this.recordHandlers);
        }
        for (XlsRecordHandler x : this.recordHandlers) {
            x.init();
        }
    }
}

