/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.util.EasyExcelTempFileCreationStrategy;
import com.alibaba.excel.util.IoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;

public class FileUtils {
    public static final String POI_FILES = "poifiles";
    public static final String EX_CACHE = "excache";
    private static String tempFilePrefix = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString() + File.separator;
    private static String poiFilesPath = tempFilePrefix + "poifiles" + File.separator;
    private static String cachePath = tempFilePrefix + "excache" + File.separator;
    private static final int WRITE_BUFF_SIZE = 8192;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        try (FileInputStream in = FileUtils.openInputStream(file);){
            long fileLength = file.length();
            byte[] byArray = fileLength > 0L ? IoUtils.toByteArray(in, (int)fileLength) : IoUtils.toByteArray(in);
            return byArray;
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static void writeToFile(File file, InputStream inputStream) {
        FileUtils.writeToFile(file, inputStream, true);
    }

    public static void writeToFile(File file, InputStream inputStream, boolean closeInputStream) {
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new ExcelAnalysisException("Can not create temporary file!", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new ExcelAnalysisException("Can not close 'outputStream'!", e);
                }
            }
            if (inputStream != null && closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ExcelAnalysisException("Can not close 'inputStream'", e);
                }
            }
        }
    }

    public static void createPoiFilesDirectory() {
        TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new EasyExcelTempFileCreationStrategy());
    }

    public static File createCacheTmpFile() {
        return FileUtils.createDirectory(new File(cachePath + UUID.randomUUID().toString()));
    }

    public static File createTmpFile(String fileName) {
        File directory = FileUtils.createDirectory(new File(tempFilePrefix));
        return new File(directory, fileName);
    }

    public static File createDirectory(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ExcelCommonException("Cannot create directory:" + directory.getAbsolutePath());
        }
        return directory;
    }

    public static void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return;
            }
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtils.delete(childFiles[i]);
            }
            file.delete();
        }
    }

    public static String getTempFilePrefix() {
        return tempFilePrefix;
    }

    public static void setTempFilePrefix(String tempFilePrefix) {
        FileUtils.tempFilePrefix = tempFilePrefix;
    }

    public static String getPoiFilesPath() {
        return poiFilesPath;
    }

    public static void setPoiFilesPath(String poiFilesPath) {
        FileUtils.poiFilesPath = poiFilesPath;
    }

    public static String getCachePath() {
        return cachePath;
    }

    public static void setCachePath(String cachePath) {
        FileUtils.cachePath = cachePath;
    }

    static {
        File tempFile = new File(tempFilePrefix);
        FileUtils.createDirectory(tempFile);
        tempFile.deleteOnExit();
        File cacheFile = new File(cachePath);
        FileUtils.createDirectory(cacheFile);
    }
}

