/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.ImageURL;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MessageContentBase;
import com.alibaba.dashscope.common.MessageContentImageURL;
import com.alibaba.dashscope.common.MessageContentText;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MessageAdapter
extends TypeAdapter<Message> {
    public void write(JsonWriter out, Message value) throws IOException {
        out.beginObject();
        out.name("role");
        out.value(value.getRole());
        if (value.getContent() != null) {
            out.name("content");
            out.value(value.getContent());
        }
        if (value.getContents() != null) {
            out.name("content").beginArray();
            for (MessageContentBase content : value.getContents()) {
                if (content.getType().equals("text")) {
                    out.beginObject();
                    out.name("type");
                    out.value("text");
                    out.name("text");
                    out.value(((MessageContentText)content).getText());
                    out.endObject();
                    continue;
                }
                if (!content.getType().equals("image_url")) continue;
                out.beginObject();
                out.name("type");
                out.value("image_url");
                out.name("image_url");
                out.beginObject();
                out.name("url");
                ImageURL imageURL = ((MessageContentImageURL)content).getImageURL();
                out.value(imageURL.getUrl());
                if (imageURL.getDetail() != null) {
                    out.name("detail");
                    out.value(imageURL.getDetail());
                }
                out.endObject();
                out.endObject();
            }
            out.endArray();
        }
        if (value.getReasoningContent() != null) {
            out.name("reasoning_content");
            out.value(value.getReasoningContent());
        }
        if (value.getToolCalls() != null) {
            out.name("tool_calls").beginArray();
            for (ToolCallBase toolCall : value.getToolCalls()) {
                out.beginObject();
                String type = toolCall.getType();
                out.name("type");
                out.value(type);
                out.name("id");
                out.value(toolCall.getId());
                out.name("function");
                if (type.equals("function")) {
                    this.writeCallFunction(out, (ToolCallFunction)toolCall);
                }
                out.endObject();
            }
            out.endArray();
        }
        if (value.getToolCallId() != null) {
            out.name("tool_call_id");
            out.value(value.getToolCallId());
        }
        if (value.getName() != null) {
            out.name("name");
            out.value(value.getName());
        }
        out.endObject();
    }

    private void writeCallFunction(JsonWriter out, ToolCallFunction toolCall) throws IOException {
        out.beginObject();
        ToolCallFunction.CallFunction callFunction = toolCall.getFunction();
        out.name("name");
        out.value(callFunction.getName());
        out.name("arguments");
        out.value(callFunction.getArguments());
        out.endObject();
    }

    private ToolCallFunction convertToCallFunction(LinkedTreeMap<String, Object> toolCall) {
        ToolCallFunction functionCall = new ToolCallFunction();
        if (toolCall.containsKey((Object)"function")) {
            ToolCallFunction.CallFunction callFunction = functionCall.new ToolCallFunction.CallFunction();
            LinkedTreeMap fc = (LinkedTreeMap)toolCall.get((Object)"function");
            if (fc.containsKey((Object)"name")) {
                callFunction.setName(fc.get((Object)"name").toString());
            }
            if (fc.containsKey((Object)"arguments")) {
                callFunction.setArguments(fc.get((Object)"arguments").toString());
            }
            functionCall.setFunction(callFunction);
        }
        functionCall.setType(toolCall.get((Object)"type").toString());
        if (toolCall.containsKey((Object)"id")) {
            functionCall.setId(toolCall.get((Object)"id").toString());
        }
        return functionCall;
    }

    public Message read(JsonReader in) throws IOException {
        Map objectMap = (Map)JsonUtils.gson.fromJson(in, Map.class);
        Message msg = new Message();
        if (objectMap.containsKey("role")) {
            msg.setRole((String)objectMap.get("role"));
            objectMap.remove("role");
        }
        if (objectMap.containsKey("content")) {
            msg.setContent((String)objectMap.get("content"));
            objectMap.remove("content");
        }
        if (objectMap.containsKey("reasoning_content")) {
            msg.setReasoningContent((String)objectMap.get("reasoning_content"));
            objectMap.remove("reasoning_content");
        }
        if (objectMap.containsKey("tool_calls")) {
            msg.toolCalls = new ArrayList<ToolCallBase>();
            ArrayList toolCalls = (ArrayList)objectMap.get("tool_calls");
            if (toolCalls == null) {
                toolCalls = new ArrayList();
            }
            for (LinkedTreeMap toolCall : toolCalls) {
                String type = toolCall.get((Object)"type").toString();
                if (!type.equals("function")) continue;
                msg.toolCalls.add(this.convertToCallFunction((LinkedTreeMap<String, Object>)toolCall));
            }
            objectMap.remove("tool_calls");
        }
        return msg;
    }
}

