/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowSlot;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ParamFlowRuleManager {
    private static final Map<String, Set<ParamFlowRule>> paramFlowRules = new ConcurrentHashMap<String, Set<ParamFlowRule>>();
    private static final RulePropertyListener PROPERTY_LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<ParamFlowRule>> currentProperty = new DynamicSentinelProperty();

    public static void loadRules(List<ParamFlowRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.info((String)"[ParamFlowRuleManager] Failed to load rules", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<ParamFlowRule>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        RulePropertyListener rulePropertyListener = PROPERTY_LISTENER;
        synchronized (rulePropertyListener) {
            currentProperty.removeListener((PropertyListener)PROPERTY_LISTENER);
            property.addListener((PropertyListener)PROPERTY_LISTENER);
            currentProperty = property;
            RecordLog.info((String)"[ParamFlowRuleManager] New property has been registered to hot param rule manager", (Object[])new Object[0]);
        }
    }

    public static List<ParamFlowRule> getRulesOfResource(String resourceName) {
        return new ArrayList<ParamFlowRule>((Collection)paramFlowRules.get(resourceName));
    }

    public static boolean hasRules(String resourceName) {
        Set<ParamFlowRule> rules = paramFlowRules.get(resourceName);
        return rules != null && !rules.isEmpty();
    }

    public static List<ParamFlowRule> getRules() {
        ArrayList<ParamFlowRule> rules = new ArrayList<ParamFlowRule>();
        for (Map.Entry<String, Set<ParamFlowRule>> entry : paramFlowRules.entrySet()) {
            rules.addAll((Collection<ParamFlowRule>)entry.getValue());
        }
        return rules;
    }

    private ParamFlowRuleManager() {
    }

    static {
        currentProperty.addListener((PropertyListener)PROPERTY_LISTENER);
    }

    static class RulePropertyListener
    implements PropertyListener<List<ParamFlowRule>> {
        RulePropertyListener() {
        }

        public void configUpdate(List<ParamFlowRule> list) {
            Map<String, Set<ParamFlowRule>> rules = this.aggregateHotParamRules(list);
            if (rules != null) {
                paramFlowRules.clear();
                paramFlowRules.putAll(rules);
            }
            RecordLog.info((String)("[ParamFlowRuleManager] Hot spot parameter flow rules received: " + paramFlowRules), (Object[])new Object[0]);
        }

        public void configLoad(List<ParamFlowRule> list) {
            Map<String, Set<ParamFlowRule>> rules = this.aggregateHotParamRules(list);
            if (rules != null) {
                paramFlowRules.clear();
                paramFlowRules.putAll(rules);
            }
            RecordLog.info((String)("[ParamFlowRuleManager] Hot spot parameter flow rules received: " + paramFlowRules), (Object[])new Object[0]);
        }

        private Map<String, Set<ParamFlowRule>> aggregateHotParamRules(List<ParamFlowRule> list) {
            ConcurrentHashMap<String, Set<ParamFlowRule>> newRuleMap = new ConcurrentHashMap<String, Set<ParamFlowRule>>();
            if (list == null || list.isEmpty()) {
                ParamFlowSlot.getMetricsMap().clear();
                RecordLog.info((String)"[ParamFlowRuleManager] No parameter flow rules, clearing all parameter metrics", (Object[])new Object[0]);
                return newRuleMap;
            }
            for (ParamFlowRule rule : list) {
                if (!ParamFlowRuleUtil.isValidRule(rule)) {
                    RecordLog.warn((String)("[ParamFlowRuleManager] Ignoring invalid rule when loading new rules: " + (Object)((Object)rule)), (Object[])new Object[0]);
                    continue;
                }
                if (StringUtil.isBlank((String)rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                ParamFlowRuleUtil.fillExceptionFlowItems(rule);
                String resourceName = rule.getResource();
                HashSet<ParamFlowRule> ruleSet = (HashSet<ParamFlowRule>)newRuleMap.get(resourceName);
                if (ruleSet == null) {
                    ruleSet = new HashSet<ParamFlowRule>();
                    newRuleMap.put(resourceName, ruleSet);
                }
                ruleSet.add(rule);
            }
            Set previousResources = paramFlowRules.keySet();
            for (String resource : previousResources) {
                if (newRuleMap.containsKey(resource)) continue;
                ParamFlowSlot.clearHotParamMetricForName(resource);
            }
            return newRuleMap;
        }
    }
}

