/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.builder;

import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.StateMachineFactory;
import com.alibaba.cola.statemachine.builder.ExternalParallelTransitionBuilder;
import com.alibaba.cola.statemachine.builder.ExternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.ExternalTransitionsBuilder;
import com.alibaba.cola.statemachine.builder.FailCallback;
import com.alibaba.cola.statemachine.builder.InternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.NumbFailCallback;
import com.alibaba.cola.statemachine.builder.ParallelTransitionBuilderImpl;
import com.alibaba.cola.statemachine.builder.StateMachineBuilder;
import com.alibaba.cola.statemachine.builder.TransitionBuilderImpl;
import com.alibaba.cola.statemachine.builder.TransitionsBuilderImpl;
import com.alibaba.cola.statemachine.impl.StateMachineImpl;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateMachineBuilderImpl<S, E, C>
implements StateMachineBuilder<S, E, C> {
    private final Map<S, State<S, E, C>> stateMap = new ConcurrentHashMap<S, State<S, E, C>>();
    private final StateMachineImpl<S, E, C> stateMachine = new StateMachineImpl<S, E, C>(this.stateMap);
    private FailCallback<S, E, C> failCallback = new NumbFailCallback();

    @Override
    public ExternalTransitionBuilder<S, E, C> externalTransition() {
        return new TransitionBuilderImpl<S, E, C>(this.stateMap, TransitionType.EXTERNAL);
    }

    @Override
    public ExternalTransitionsBuilder<S, E, C> externalTransitions() {
        return new TransitionsBuilderImpl<S, E, C>(this.stateMap, TransitionType.EXTERNAL);
    }

    @Override
    public ExternalParallelTransitionBuilder<S, E, C> externalParallelTransition() {
        return new ParallelTransitionBuilderImpl<S, E, C>(this.stateMap, TransitionType.EXTERNAL);
    }

    @Override
    public InternalTransitionBuilder<S, E, C> internalTransition() {
        return new TransitionBuilderImpl<S, E, C>(this.stateMap, TransitionType.INTERNAL);
    }

    @Override
    public void setFailCallback(FailCallback<S, E, C> callback) {
        this.failCallback = callback;
    }

    @Override
    public StateMachine<S, E, C> build(String machineId) {
        this.stateMachine.setMachineId(machineId);
        this.stateMachine.setReady(true);
        this.stateMachine.setFailCallback(this.failCallback);
        StateMachineFactory.register(this.stateMachine);
        return this.stateMachine;
    }
}

