/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.builder;

import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.Condition;
import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.builder.AbstractParallelTransitionBuilder;
import com.alibaba.cola.statemachine.builder.ExternalParallelTransitionBuilder;
import com.alibaba.cola.statemachine.builder.On;
import com.alibaba.cola.statemachine.builder.ParallelFrom;
import com.alibaba.cola.statemachine.builder.When;
import com.alibaba.cola.statemachine.impl.StateHelper;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.List;
import java.util.Map;

class ParallelTransitionBuilderImpl<S, E, C>
extends AbstractParallelTransitionBuilder<S, E, C>
implements ExternalParallelTransitionBuilder<S, E, C> {
    private State<S, E, C> source;
    private List<Transition<S, E, C>> transitions;

    public ParallelTransitionBuilderImpl(Map<S, State<S, E, C>> stateMap, TransitionType transitionType) {
        super(stateMap, transitionType);
    }

    @Override
    public ParallelFrom<S, E, C> from(S stateId) {
        this.source = StateHelper.getState(this.stateMap, stateId);
        return this;
    }

    @Override
    public When<S, E, C> when(Condition<C> condition) {
        for (Transition<S, E, C> transition : this.transitions) {
            transition.setCondition(condition);
        }
        return this;
    }

    @Override
    public On<S, E, C> on(E event) {
        this.transitions = this.source.addTransitions(event, this.targets, this.transitionType);
        return this;
    }

    @Override
    public void perform(Action<S, E, C> action) {
        for (Transition<S, E, C> transition : this.transitions) {
            transition.setAction(action);
        }
    }
}

