/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.provisioning.selector;

import java.util.List;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMessageQueueSelector
implements MessageQueueSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionMessageQueueSelector.class);

    public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
        Integer partition = 0;
        try {
            partition = Math.abs(Integer.parseInt(msg.getProperty("scst_partition")));
            if (partition >= mqs.size()) {
                LOGGER.warn("the partition '{}' is greater than the number of queues '{}'.", (Object)partition, (Object)mqs.size());
                partition = partition % mqs.size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return mqs.get(partition);
    }
}

