/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service;

import com.alibaba.cloud.dubbo.http.HttpServerRequest;
import com.alibaba.cloud.dubbo.metadata.MethodMetadata;
import com.alibaba.cloud.dubbo.metadata.MethodParameterMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceExecutionContext;
import com.alibaba.cloud.dubbo.service.parameter.DubboGenericServiceParameterResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DubboGenericServiceExecutionContextFactory {
    @Autowired(required=false)
    private final List<DubboGenericServiceParameterResolver> resolvers = Collections.emptyList();

    @PostConstruct
    public void init() {
        AnnotationAwareOrderComparator.sort(this.resolvers);
    }

    public DubboGenericServiceExecutionContext create(RestMethodMetadata dubboRestMethodMetadata, RestMethodMetadata clientMethodMetadata, Object[] arguments) {
        MethodMetadata dubboMethodMetadata = dubboRestMethodMetadata.getMethod();
        String methodName = dubboMethodMetadata.getName();
        String[] parameterTypes = this.resolveParameterTypes(dubboMethodMetadata);
        Object[] parameters = this.resolveParameters(dubboRestMethodMetadata, clientMethodMetadata, arguments);
        return new DubboGenericServiceExecutionContext(methodName, parameterTypes, parameters);
    }

    public DubboGenericServiceExecutionContext create(RestMethodMetadata dubboRestMethodMetadata, HttpServerRequest request) {
        MethodMetadata methodMetadata = dubboRestMethodMetadata.getMethod();
        String methodName = methodMetadata.getName();
        String[] parameterTypes = this.resolveParameterTypes(methodMetadata);
        Object[] parameters = this.resolveParameters(dubboRestMethodMetadata, request);
        return new DubboGenericServiceExecutionContext(methodName, parameterTypes, parameters);
    }

    private Map<String, Integer> buildParamNameToIndex(List<MethodParameterMetadata> params) {
        LinkedHashMap<String, Integer> paramNameToIndex = new LinkedHashMap<String, Integer>();
        for (MethodParameterMetadata param : params) {
            paramNameToIndex.put(param.getName(), param.getIndex());
        }
        return paramNameToIndex;
    }

    protected String[] resolveParameterTypes(MethodMetadata methodMetadata) {
        List<MethodParameterMetadata> params = methodMetadata.getParams();
        String[] parameterTypes = new String[params.size()];
        for (MethodParameterMetadata parameterMetadata : params) {
            String parameterType;
            int index = parameterMetadata.getIndex();
            parameterTypes[index] = parameterType = parameterMetadata.getType();
        }
        return parameterTypes;
    }

    protected Object[] resolveParameters(RestMethodMetadata dubboRestMethodMetadata, HttpServerRequest request) {
        MethodMetadata dubboMethodMetadata = dubboRestMethodMetadata.getMethod();
        List<MethodParameterMetadata> params = dubboMethodMetadata.getParams();
        Object[] parameters = new Object[params.size()];
        block0: for (MethodParameterMetadata parameterMetadata : params) {
            int index = parameterMetadata.getIndex();
            for (DubboGenericServiceParameterResolver resolver : this.resolvers) {
                Object parameter = resolver.resolve(dubboRestMethodMetadata, parameterMetadata, request);
                if (parameter == null) continue;
                parameters[index] = parameter;
                continue block0;
            }
        }
        return parameters;
    }

    protected Object[] resolveParameters(RestMethodMetadata dubboRestMethodMetadata, RestMethodMetadata clientRestMethodMetadata, Object[] arguments) {
        MethodMetadata dubboMethodMetadata = dubboRestMethodMetadata.getMethod();
        List<MethodParameterMetadata> params = dubboMethodMetadata.getParams();
        Object[] parameters = new Object[params.size()];
        block0: for (MethodParameterMetadata parameterMetadata : params) {
            int index = parameterMetadata.getIndex();
            for (DubboGenericServiceParameterResolver resolver : this.resolvers) {
                Object parameter = resolver.resolve(dubboRestMethodMetadata, parameterMetadata, clientRestMethodMetadata, arguments);
                if (parameter == null) continue;
                parameters[index] = parameter;
                continue block0;
            }
        }
        return parameters;
    }
}

