/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.NameValueExpression;
import org.springframework.http.HttpRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class AbstractNameValueExpression<T>
implements NameValueExpression<T> {
    protected final String name;
    protected final T value;
    protected final boolean negated;

    AbstractNameValueExpression(String expression) {
        int separator = expression.indexOf(61);
        if (separator == -1) {
            this.negated = expression.startsWith("!");
            this.name = StringUtils.trimWhitespace((String)(this.negated ? expression.substring(1) : expression));
            this.value = null;
        } else {
            this.negated = separator > 0 && expression.charAt(separator - 1) == '!';
            this.name = StringUtils.trimWhitespace((String)(this.negated ? expression.substring(0, separator - 1) : expression.substring(0, separator)));
            String valueExpression = this.getValueExpression(expression, separator);
            this.value = this.isExcludedValue(valueExpression) ? null : this.parseValue(valueExpression);
        }
    }

    private String getValueExpression(String expression, int separator) {
        return StringUtils.trimWhitespace((String)expression.substring(separator + 1));
    }

    protected boolean isExcludedValue(String valueExpression) {
        return StringUtils.hasText((String)valueExpression) && valueExpression.startsWith("{") && valueExpression.endsWith("}");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public final boolean match(HttpRequest request) {
        boolean isMatch = this.value != null ? this.matchValue(request) : this.matchName(request);
        return this.negated ? !isMatch : isMatch;
    }

    protected abstract boolean isCaseSensitiveName();

    protected abstract T parseValue(String var1);

    protected abstract boolean matchName(HttpRequest var1);

    protected abstract boolean matchValue(HttpRequest var1);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractNameValueExpression that = (AbstractNameValueExpression)other;
        return (this.isCaseSensitiveName() ? this.name.equals(that.name) : this.name.equalsIgnoreCase(that.name)) && ObjectUtils.nullSafeEquals(this.value, that.value) && this.negated == that.negated;
    }

    public int hashCode() {
        int result = this.isCaseSensitiveName() ? this.name.hashCode() : this.name.toLowerCase().hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.negated ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.value != null) {
            builder.append(this.name);
            if (this.negated) {
                builder.append('!');
            }
            builder.append('=');
            builder.append(this.value);
        } else {
            if (this.negated) {
                builder.append('!');
            }
            builder.append(this.name);
        }
        return builder.toString();
    }
}

