/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultHttpRequest
implements HttpRequest {
    private final String method;
    private final URI uri;
    private final HttpHeaders headers = new HttpHeaders();

    public DefaultHttpRequest(String method, String path, Map<String, List<String>> params, Map<String, List<String>> headers) {
        this.method = method == null ? HttpMethod.GET.name() : method.toUpperCase();
        this.uri = this.buildURI(path, params);
        this.headers.putAll(headers);
    }

    public static Builder builder() {
        return new Builder();
    }

    private URI buildURI(String path, Map<String, List<String>> params) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)path).queryParams((MultiValueMap)new LinkedMultiValueMap(params));
        return builder.build().toUri();
    }

    public HttpMethod getMethod() {
        return HttpMethod.resolve((String)this.getMethodValue());
    }

    public String getMethodValue() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public static class Builder {
        String method;
        String path;
        MultiValueMap<String, String> params = new LinkedMultiValueMap();
        MultiValueMap<String, String> headers = new LinkedMultiValueMap();

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder param(String name, String value) {
            this.params.add((Object)name, (Object)value);
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.add((Object)name, (Object)value);
            return this;
        }

        public Builder params(Map<String, List<String>> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public HttpRequest build() {
            return new DefaultHttpRequest(this.method, this.path, (Map<String, List<String>>)this.params, (Map<String, List<String>>)this.headers);
        }
    }
}

