/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure;

import com.alibaba.cloud.dubbo.autoconfigure.DubboMetadataAutoConfiguration;
import com.alibaba.cloud.dubbo.autoconfigure.condition.MissingSpringCloudRegistryConfigPropertyCondition;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.DubboServiceRegistrationEventPublishingAspect;
import com.alibaba.cloud.dubbo.registry.SpringCloudRegistryFactory;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancePreRegisteredEvent;
import com.ecwid.consul.v1.agent.model.NewService;
import com.netflix.appinfo.InstanceInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.spring.ServiceBean;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.util.ObjectUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={DubboServiceRegistrationEventPublishingAspect.class})
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration", "org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration", "org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration"}, value={DubboMetadataAutoConfiguration.class})
public class DubboServiceRegistrationAutoConfiguration {
    public static final String EUREKA_CLIENT_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration";
    public static final String CONSUL_AUTO_SERVICE_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration";
    public static final String CONSUL_AUTO_SERVICE_AUTO_REGISTRATION_CLASS_NAME = "org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration";
    public static final String ZOOKEEPER_AUTO_SERVICE_AUTO_CONFIGURATION_CLASS_NAME = "org.springframework.cloud.zookeeper.serviceregistry.ZookeeperAutoServiceRegistrationAutoConfiguration";
    private static final Logger logger = LoggerFactory.getLogger(DubboServiceRegistrationAutoConfiguration.class);
    @Autowired
    private DubboServiceMetadataRepository dubboServiceMetadataRepository;

    @Bean
    @Conditional(value={MissingSpringCloudRegistryConfigPropertyCondition.class})
    public RegistryConfig defaultSpringCloudRegistryConfig() {
        return new RegistryConfig(SpringCloudRegistryFactory.ADDRESS, SpringCloudRegistryFactory.PROTOCOL);
    }

    @EventListener(value={ServiceInstancePreRegisteredEvent.class})
    public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
        Registration registration = event.getSource();
        this.attachDubboMetadataServiceMetadata(registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachDubboMetadataServiceMetadata(Registration registration) {
        if (registration == null) {
            return;
        }
        Registration registration2 = registration;
        synchronized (registration2) {
            Map metadata = registration.getMetadata();
            this.attachDubboMetadataServiceMetadata(metadata);
        }
    }

    private void attachDubboMetadataServiceMetadata(Map<String, String> metadata) {
        Map<String, String> serviceMetadata = this.dubboServiceMetadataRepository.getDubboMetadataServiceMetadata();
        if (!ObjectUtils.isEmpty(serviceMetadata)) {
            metadata.putAll(serviceMetadata);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration"})
    @AutoConfigureOrder
    class ConsulConfiguration {
        ConsulConfiguration() {
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            Registration registration = event.getSource();
            Class registrationClass = AopUtils.getTargetClass((Object)registration);
            String registrationClassName = registrationClass.getName();
            if (DubboServiceRegistrationAutoConfiguration.CONSUL_AUTO_SERVICE_AUTO_REGISTRATION_CLASS_NAME.equalsIgnoreCase(registrationClassName)) {
                ConsulRegistration consulRegistration = (ConsulRegistration)registration;
                this.attachURLsIntoMetadata(consulRegistration);
            }
        }

        private void attachURLsIntoMetadata(ConsulRegistration consulRegistration) {
            NewService newService = consulRegistration.getService();
            Map<String, String> serviceMetadata = DubboServiceRegistrationAutoConfiguration.this.dubboServiceMetadataRepository.getDubboMetadataServiceMetadata();
            if (!ObjectUtils.isEmpty(serviceMetadata)) {
                List tags = newService.getTags();
                for (Map.Entry<String, String> entry : serviceMetadata.entrySet()) {
                    tags.add(entry.getKey() + "=" + entry.getValue());
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
    @Aspect
    class EurekaConfiguration
    implements SmartInitializingSingleton {
        @Autowired
        private ObjectProvider<Collection<ServiceBean>> serviceBeans;

        EurekaConfiguration() {
        }

        @EventListener(value={ServiceInstancePreRegisteredEvent.class})
        public void onServiceInstancePreRegistered(ServiceInstancePreRegisteredEvent event) {
            Registration registration = event.getSource();
            EurekaRegistration eurekaRegistration = (EurekaRegistration)EurekaRegistration.class.cast(registration);
            InstanceInfo instanceInfo = eurekaRegistration.getApplicationInfoManager().getInfo();
            DubboServiceRegistrationAutoConfiguration.this.attachDubboMetadataServiceMetadata(instanceInfo.getMetadata());
        }

        public void afterSingletonsInstantiated() {
            Collection serviceBeans = (Collection)this.serviceBeans.getIfAvailable();
            if (!ObjectUtils.isEmpty((Object)serviceBeans)) {
                serviceBeans.forEach(ServiceConfig::export);
            }
        }
    }
}

