/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientException;
import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientThreadFactory;
import com.alibaba.cloud.analyticdb.adb4pgclient.ClientDataSource;
import com.alibaba.cloud.analyticdb.adb4pgclient.ColumnDataType;
import com.alibaba.cloud.analyticdb.adb4pgclient.ColumnInfo;
import com.alibaba.cloud.analyticdb.adb4pgclient.DatabaseConfig;
import com.alibaba.cloud.analyticdb.adb4pgclient.Row;
import com.alibaba.cloud.analyticdb.adb4pgclient.TableInfo;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Adb4pgClient {
    private DatabaseConfig databaseConfig;
    private DruidDataSource dataSource;
    private Map<String, TableInfo> tableInfo;
    private Map<String, Boolean> isAllColumn;
    private CopyManager copyManager;
    private static final String TABLE_NAME_QUOTE_CHARACTER = "\"";
    private static final String COLUMN_QUOTE_CHARACTER = "\"";
    private static final String ALL_COLUMN_CHARACTER = "*";
    private static final String FIELD_DELIMITER = "|";
    private static final String DOT = ".";
    private static final String SET_AUTOSTATS_MODE_OFF = "set gp_autostats_mode=none";
    private static final String SET_OPTIMIZER_OFF_SQL = "set optimizer = off";
    private static final String INFO = "info";
    private static final String ERROR = "error";
    private static final String SET_SEQSCAN_OFF_SQL = "set enable_seqscan = off";
    private final ExecutorService executorService;
    private LinkedBlockingQueue<Task> executeTaskQueue = new LinkedBlockingQueue();
    private List<String> commitExceptionDataList = Collections.synchronizedList(new ArrayList());
    private Map<String, Map<String, String>> schemNameTableNameCache;
    private Map<String, Map<String, Pair<Integer, String>>> tableColumnsMetaData;
    private Map<String, Map<String, Pair<Integer, String>>> configColumnsMetaData;
    private Map<String, List<String>> dataBuffer;
    private Map<String, Long> bufferTableSize;
    private long totalCommittedSize = 0L;
    private ClientDataSource clientDataSource;
    CSVParser csvParser;
    CSVParserBuilder builder = new CSVParserBuilder();

    public Adb4pgClient(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
        this.clientDataSource = ClientDataSource.getInstance();
        this.schemNameTableNameCache = new HashMap<String, Map<String, String>>(16);
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new Adb4pgClientThreadFactory(String.format("%s", databaseConfig.getDatabase())));
        this.initDatasource();
        this.initInstance();
        this.builder.withSeparator(FIELD_DELIMITER.charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS);
        this.csvParser = this.builder.build();
    }

    public Adb4pgClient(DatabaseConfig databaseConfig, DruidDataSource dataSource) {
        this.dataSource = dataSource;
        this.databaseConfig = databaseConfig;
        this.clientDataSource = ClientDataSource.getInstance();
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new Adb4pgClientThreadFactory(String.format("%s", databaseConfig.getTable())));
        this.initDatasource();
        this.initInstance();
        this.builder.withSeparator(FIELD_DELIMITER.charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS);
        this.csvParser = this.builder.build();
    }

    public void addRow(Row row, String tableName, String schemaName) {
        String schemaNameTableName;
        if (schemaName == null) {
            schemaName = "public";
        }
        if (this.tableInfo.get(schemaNameTableName = this.schemNameTableNameCache.get(schemaName).get(tableName)) == null) {
            throw new Adb4pgClientException(106, "The table " + schemaName + DOT + tableName + " do not exist", null);
        }
        if (row.getColumnValues().size() != this.databaseConfig.getColumns(tableName, schemaName).size()) {
            throw new Adb4pgClientException(103, "Add row data is illegal, column size is not equal as config", null);
        }
        if (this.dataBuffer.get(schemaNameTableName) == null) {
            this.dataBuffer.put(schemaNameTableName, new ArrayList());
        }
        if (this.bufferTableSize.get(schemaNameTableName) == null) {
            this.bufferTableSize.put(schemaNameTableName, 0L);
        }
        try {
            String copyString = this.generateCopyString(tableName, schemaName, row);
            this.dataBuffer.get(schemaNameTableName).add(copyString);
            this.bufferTableSize.put(schemaNameTableName, this.bufferTableSize.get(schemaNameTableName) + (long)copyString.getBytes(Charset.forName("UTF-8")).length);
            if (this.bufferTableSize.get(schemaNameTableName) > this.databaseConfig.getCommitSize()) {
                this.commit(schemaNameTableName);
            }
        }
        catch (Adb4pgClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Adb4pgClientException(103, String.format("Add row data (%s) error: %s", row.getColumnValues().toString(), e.getMessage()), (Throwable)e);
        }
    }

    public TableInfo getTableInfo(String tableName, String schemaName) {
        return this.tableInfo.get(schemaName + DOT + tableName);
    }

    public List<ColumnInfo> getColumnInfo(String tableName, String schemaName) {
        return this.tableInfo.get(schemaName + DOT + tableName).getColumns();
    }

    public void addRows(List<Row> rows, String tableName, String schemaName) {
        for (Row row : rows) {
            this.addRow(row, tableName, schemaName);
        }
    }

    public void addMap(Map<String, String> oriMap, String tableName, String schemaName) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : oriMap.entrySet()) {
            dataMap.put(entry.getKey(), entry.getValue());
        }
        if (this.tableInfo.get(this.schemNameTableNameCache.get(schemaName).get(tableName)) == null) {
            throw new Adb4pgClientException(106, "The table " + tableName + " do not exist", null);
        }
        Row row = this.mapToRow(dataMap, tableName, schemaName);
        this.addRow(row, tableName, schemaName);
    }

    public void addMaps(List<Map<String, String>> maps, String tableName, String schemaName) {
        for (Map<String, String> map : maps) {
            this.addMap(map, tableName, schemaName);
        }
    }

    private void commit(String schemaNameTableName) {
        String[] s = schemaNameTableName.split("\\.");
        this.executeTaskQueue.add(new Task(this.dataBuffer.get(schemaNameTableName), schemaNameTableName, this.databaseConfig.getColumns(s[1], s[0])));
        this.taskQueueExecute();
        this.dataBuffer.get(schemaNameTableName).clear();
        this.totalCommittedSize += this.bufferTableSize.get(schemaNameTableName).longValue();
        this.bufferTableSize.put(schemaNameTableName, 0L);
    }

    public void commit() {
        for (Map.Entry<String, List<String>> entry : this.dataBuffer.entrySet()) {
            String schemaNameTableName = entry.getKey();
            String schemaName = schemaNameTableName.split("\\.")[0];
            String tableName = schemaNameTableName.split("\\.")[1];
            this.executeTaskQueue.add(new Task(entry.getValue(), schemaNameTableName, this.databaseConfig.getColumns(tableName, schemaName)));
        }
        this.taskQueueExecute();
        this.dataBuffer.clear();
        for (Map.Entry<String, Object> entry : this.bufferTableSize.entrySet()) {
            this.totalCommittedSize += ((Long)entry.getValue()).longValue();
        }
        this.bufferTableSize.clear();
    }

    public long getTotalCommittedSize() {
        return this.totalCommittedSize;
    }

    private void taskQueueExecute() {
        ArrayList futureList = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(this.databaseConfig.getParallelNumber());
        for (int i = 0; i < this.databaseConfig.getParallelNumber(); ++i) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        Task task;
                        while ((task = (Task)Adb4pgClient.this.executeTaskQueue.poll()) != null) {
                            Adb4pgClient.this.copyBatchData(task);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            futureList.add(future);
        }
        try {
            latch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            this.logger(ERROR, "commit " + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.commitExceptionDataList.size() > 0) {
            throw new Adb4pgClientException(101, this.commitExceptionDataList, null);
        }
    }

    private String generateCopyString(String tableName, String schemaName, Row row) {
        StringBuilder rowsb = new StringBuilder();
        String schemaNameTableName = this.schemNameTableNameCache.get(schemaName).get(tableName);
        try {
            rowsb.setLength(0);
            List<Object> columnValues = row.getColumnValues();
            for (int i = 0; i < this.databaseConfig.getColumns(tableName, schemaName).size(); ++i) {
                String columnName = this.databaseConfig.getColumns(tableName, schemaName).get(i);
                int columnSqltype = (Integer)this.configColumnsMetaData.get(schemaNameTableName).get(columnName).getLeft();
                String s = row.getColumnValues().get(i) == null ? (this.tableInfo.get(schemaNameTableName).getColumns().get(i).getDefaultValue() != null ? this.dataConvertor(columnSqltype, this.tableInfo.get(schemaNameTableName).getColumns().get(i).getDefaultValue(), schemaNameTableName, columnName) : this.dataConvertor(columnSqltype, null, schemaNameTableName, columnName)) : this.dataConvertor(columnSqltype, columnValues.get(i), schemaNameTableName, columnName);
                if (s != null) {
                    rowsb.append("\"").append(s).append("\"");
                }
                if (i == row.getColumnValues().size() - 1) continue;
                rowsb.append(FIELD_DELIMITER);
            }
            rowsb.append(IOUtils.LINE_SEPARATOR);
        }
        catch (Exception e) {
            throw new Adb4pgClientException(103, e.getMessage(), (Throwable)e);
        }
        return rowsb.toString();
    }

    private String generateColumnString(List<String> tableColumns) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String col : tableColumns) {
            sb.append("\"").append(col).append("\"");
            if (++i >= tableColumns.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCopy(ByteArrayOutputStream outputStream, String schemaNameTableName, List<String> tableColumns, Connection conn) throws SQLException, Exception {
        long res = 0L;
        String table = "\"" + this.databaseConfig.getDatabase() + "\"" + DOT + "\"" + this.tableInfo.get(schemaNameTableName).getTableSchema() + "\"" + DOT + "\"" + schemaNameTableName.split("\\.")[1] + "\"";
        String columnString = this.generateColumnString(tableColumns);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try {
            BaseConnection baseConnection = (BaseConnection)conn.getMetaData().getConnection();
            this.copyManager = new CopyManager(baseConnection);
            res = this.copyManager.copyIn("COPY " + table + " (" + columnString + ") FROM STDIN DELIMITER '" + FIELD_DELIMITER + "'  ESCAPE '\\' CSV QUOTE '" + "\"" + "'", (InputStream)inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private ByteArrayOutputStream getByteStream(List<String> strings) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String copyString : strings) {
            byteArrayOutputStream.write(copyString.getBytes(Charset.forName("UTF-8")));
        }
        return byteArrayOutputStream;
    }

    private void copyBatchData(Task task) {
        this.copyBatchData(task.outputStream, task.schemaNameTableName, task.tableColumns);
    }

    private void copyBatchData(List<String> outputStream, String schemaNameTableName, List<String> tableColumns) {
        ByteArrayOutputStream w = null;
        Connection connection = this.getConnection();
        try {
            w = this.getByteStream(outputStream);
            this.executeCopy(w, schemaNameTableName, tableColumns, connection);
            w.close();
        }
        catch (SQLException e) {
            this.copyEachRow(schemaNameTableName, tableColumns);
        }
        catch (Adb4pgClientException e1) {
            throw e1;
        }
        catch (Exception e2) {
            this.logger(ERROR, "commit " + e2.getMessage());
            throw new RuntimeException(e2.getMessage(), e2);
        }
        finally {
            this.closeDBResources(null, null, connection);
        }
    }

    private void copyEachRow(String schemaNameTableName, List<String> userInputTableColumns) {
        if (this.databaseConfig.isInsertIgnore()) {
            this.copyEachRowIgnore(schemaNameTableName, userInputTableColumns);
        } else {
            this.copyEachRowOverride(schemaNameTableName, userInputTableColumns);
        }
    }

    private void copyEachRowIgnore(String schemaNameTableName, List<String> userInputTableColumns) {
        List<String> copyStrings = this.dataBuffer.get(schemaNameTableName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Connection connection = null;
        for (String copyString : copyStrings) {
            byte[] rawData = copyString.getBytes(Charset.forName("UTF-8"));
            try {
                connection = this.getConnection();
                byteArrayOutputStream.write(rawData);
                this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, connection);
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                if (errorMessage.contains("duplicate key violates unique constraint")) continue;
                this.commitExceptionDataList.add(copyString);
            }
            catch (Exception e) {
                throw new Adb4pgClientException(102, e.getMessage() + e.getCause().toString(), (Throwable)e);
            }
            finally {
                byteArrayOutputStream.reset();
                this.closeDBResources(null, null, connection);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyEachRowOverride(String schemaNameTableName, List<String> userInputTableColumns) {
        List<String> copyStrings = this.dataBuffer.get(schemaNameTableName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TableInfo tableInfo = this.tableInfo.get(schemaNameTableName);
        List<String> primaryKeys = tableInfo.getPrimaryKeyColumns();
        String schemaName = schemaNameTableName.split("\\.")[0];
        String tableName = schemaNameTableName.split("\\.")[1];
        List<String> userInputColumns = this.databaseConfig.getColumns(tableName, schemaName);
        ArrayList<Integer> primaryKeysIndex = new ArrayList<Integer>();
        for (String primaryKey : primaryKeys) {
            primaryKeysIndex.add(userInputColumns.indexOf(primaryKey));
        }
        String table = "\"" + this.databaseConfig.getDatabase() + "\"" + DOT + "\"" + this.tableInfo.get(schemaNameTableName).getTableSchema() + "\"" + DOT + "\"" + tableName + "\"";
        String deleteSQLPrefix = String.format("DELETE FROM %s WHERE ", table);
        Connection conn1 = null;
        Iterator<String> iterator = copyStrings.iterator();
        while (iterator.hasNext()) {
            String copyString = iterator.next();
            byte[] rawData = copyString.getBytes(Charset.forName("UTF-8"));
            try {
                conn1 = this.getConnection();
                byteArrayOutputStream.write(rawData);
                this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, conn1);
                continue;
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                Connection connection = null;
                PreparedStatement pstmt = null;
                if (errorMessage.contains("duplicate key violates unique constraint") && primaryKeys.size() > 0) {
                    try {
                        String[] values = this.csvParser.parseLine(copyString.substring(0, copyString.length() - IOUtils.LINE_SEPARATOR.length()));
                        StringBuilder deleteSqlsb = new StringBuilder();
                        deleteSqlsb.append(deleteSQLPrefix);
                        for (Integer i : primaryKeysIndex) {
                            if (i != 0) {
                                deleteSqlsb.append(String.format("AND %s = ? ", "\"" + userInputColumns.get(i) + "\""));
                                continue;
                            }
                            deleteSqlsb.append(String.format("%s = ? ", "\"" + userInputColumns.get(i) + "\""));
                        }
                        connection = this.getConnection();
                        connection.setAutoCommit(false);
                        pstmt = connection.prepareStatement(deleteSqlsb.toString());
                        block19: for (int j = 0; j < primaryKeysIndex.size(); ++j) {
                            int columnType = (Integer)this.configColumnsMetaData.get(schemaNameTableName).get(userInputColumns.get((Integer)primaryKeysIndex.get(j))).getLeft();
                            switch (columnType) {
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    pstmt.setBigDecimal(j + 1, new BigDecimal(values[(Integer)primaryKeysIndex.get(j)]));
                                    continue block19;
                                }
                                case -5: 
                                case 4: 
                                case 5: {
                                    pstmt.setLong(j + 1, Long.valueOf(values[(Integer)primaryKeysIndex.get(j)]));
                                    continue block19;
                                }
                                default: {
                                    pstmt.setString(j + 1, values[(Integer)primaryKeysIndex.get(j)]);
                                }
                            }
                        }
                        pstmt.executeUpdate();
                        this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, connection);
                        connection.commit();
                        connection.setAutoCommit(true);
                        this.closeDBResources(null, pstmt, connection);
                        continue;
                    }
                    catch (SQLException e1) {
                        try {
                            throw new Adb4pgClientException(102, "Delete the violation row Error: " + e1.getMessage(), (Throwable)e);
                            catch (Exception e2) {
                                throw new Adb4pgClientException(102, "Override Row Error: " + e2.getMessage(), (Throwable)e2);
                            }
                        }
                        catch (Throwable throwable) {
                            this.closeDBResources(null, pstmt, connection);
                            throw throwable;
                        }
                    }
                }
                this.commitExceptionDataList.add(copyString);
                continue;
            }
            catch (Exception e) {
                throw new Adb4pgClientException(102, "Override Row Error: " + e.getMessage() + e.getCause(), (Throwable)e);
            }
            finally {
                this.closeDBResources(null, null, conn1);
                byteArrayOutputStream.reset();
                continue;
            }
            break;
        }
        return;
    }

    private void initDatasource() {
        if (this.dataSource != null) {
            Connection testConn = null;
            try {
                testConn = this.getConnection();
            }
            finally {
                this.closeDBResources(null, null, testConn);
            }
            return;
        }
        if (this.databaseConfig.isShareDataSource()) {
            this.dataSource = this.clientDataSource.getDataSource(this.databaseConfig);
            return;
        }
        this.dataSource = this.clientDataSource.newDataSource(this.databaseConfig);
    }

    private Boolean initInstance() {
        this.tableInfo = new HashMap<String, TableInfo>(16);
        this.isAllColumn = new HashMap<String, Boolean>(16);
        this.configColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>(16);
        this.tableColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>(16);
        for (String tableName : this.databaseConfig.getTable()) {
            this.isAllColumn.put(tableName, false);
        }
        this.dataBuffer = new HashMap<String, List<String>>(16);
        this.bufferTableSize = new HashMap<String, Long>(16);
        this.checkConfig();
        this.logger(INFO, "init adb client successfully");
        return true;
    }

    private Boolean checkConfig() {
        try {
            this.checkDatabaseConfig();
            this.getTableInfo(this.databaseConfig.getDatabase(), this.databaseConfig.getTable(), this.getConnection());
            for (String schemaNameTableName : this.databaseConfig.getTable()) {
                this.checkTableConfig(schemaNameTableName);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Adb4pgClientException(106, "Check config exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkTableConfig(String schemaNameTableName) {
        TableInfo tableInfoTmp = this.tableInfo.get(schemaNameTableName);
        if (tableInfoTmp == null) {
            return;
        }
        String[] s = schemaNameTableName.split("\\.");
        this.dealColumnConf(s[0], s[1]);
        this.tableColumnsMetaData.put(schemaNameTableName, this.getColumnMetaData(tableInfoTmp));
        HashMap<String, Pair<Integer, String>> configColumnMetaDataTmp = new HashMap<String, Pair<Integer, String>>(16);
        for (int i = 0; i < this.databaseConfig.getColumns(s[1], s[0]).size(); ++i) {
            String oriEachColumn = this.databaseConfig.getColumns(s[1], s[0]).get(i);
            String eachColumn = oriEachColumn;
            if (eachColumn.startsWith("\"") && eachColumn.endsWith("\"")) {
                eachColumn = eachColumn.substring(1, eachColumn.length() - 1);
            }
            for (String eachAdsColumn : tableInfoTmp.getColumnsNames()) {
                if (!eachColumn.equalsIgnoreCase(eachAdsColumn)) continue;
                configColumnMetaDataTmp.put(oriEachColumn, this.tableColumnsMetaData.get(schemaNameTableName).get(eachAdsColumn));
            }
        }
        this.configColumnsMetaData.put(schemaNameTableName, configColumnMetaDataTmp);
        if (this.tableInfo.get(schemaNameTableName).getPrimaryKeyColumns().size() > 0) {
            for (int k = 0; k < this.tableInfo.get(schemaNameTableName).getPrimaryKeyColumns().size(); ++k) {
                if (this.databaseConfig.getColumns(s[1], s[0]).indexOf(this.tableInfo.get(schemaNameTableName).getPrimaryKeyColumns().get(k)) >= 0) continue;
                throw new Adb4pgClientException(106, "config lack of primary key column(s)", null);
            }
        }
    }

    private Map<String, Pair<Integer, String>> getColumnMetaData(TableInfo tableInfo) {
        HashMap<String, Pair<Integer, String>> columnMetaData = new HashMap<String, Pair<Integer, String>>(16);
        List<ColumnInfo> columnInfoList = tableInfo.getColumns();
        for (ColumnInfo columnInfo : columnInfoList) {
            ImmutablePair eachPair = new ImmutablePair((Object)columnInfo.getDataType().sqlType, (Object)columnInfo.getDataType().name);
            columnMetaData.put(columnInfo.getName(), (Pair<Integer, String>)eachPair);
        }
        return columnMetaData;
    }

    private void dealColumnConf(String schemaName, String tableName) {
        List<String> userConfiguredColumns = this.databaseConfig.getColumns(tableName, schemaName);
        List<String> tableAllColumnsNames = this.tableInfo.get(schemaName + DOT + tableName).getColumnsNames();
        if (null == userConfiguredColumns || userConfiguredColumns.isEmpty()) {
            throw new Adb4pgClientException(106, "Config is error. Do not have column list", null);
        }
        if (1 == userConfiguredColumns.size() && ALL_COLUMN_CHARACTER.equals(userConfiguredColumns.get(0))) {
            this.isAllColumn.put(schemaName + DOT + tableName, true);
            this.databaseConfig.setColumns(tableAllColumnsNames, tableName, schemaName);
        } else {
            if (userConfiguredColumns.size() > tableAllColumnsNames.size()) {
                throw new Adb4pgClientException(106, String.format("Database config is error. The count of writer columns %s is bigger than the count of read table's columns {}.", userConfiguredColumns.size(), tableAllColumnsNames.size()), null);
            }
            Adb4pgClient.makeSureNoValueDuplicate(userConfiguredColumns, false);
            ArrayList<String> removeQuotedColumns = new ArrayList<String>();
            for (String each : userConfiguredColumns) {
                if (each.startsWith("\"") && each.endsWith("\"")) {
                    removeQuotedColumns.add(each.substring(1, each.length() - 1));
                    continue;
                }
                removeQuotedColumns.add(each);
            }
            Adb4pgClient.makeSureBInA(tableAllColumnsNames, removeQuotedColumns, false);
        }
    }

    private void checkDatabaseConfig() {
        String[] s;
        if (this.databaseConfig.getTable() == null || this.databaseConfig.getTable().size() == 0) {
            throw new RuntimeException("Table can not be null");
        }
        for (String schemaNameTableName : this.databaseConfig.getTable()) {
            s = schemaNameTableName.split("\\.");
            if (this.schemNameTableNameCache.get(s[0]) == null) {
                this.schemNameTableNameCache.put(s[0], new HashMap(16));
            }
            this.schemNameTableNameCache.get(s[0]).put(s[1], s[0] + DOT + s[1]);
        }
        this.databaseConfig.setSchemNameTableNameCache(this.schemNameTableNameCache);
        for (String schemaNameTableName : this.databaseConfig.getTable()) {
            s = schemaNameTableName.split("\\.");
            if (this.databaseConfig.getColumns(s[1], s[0]) != null) continue;
            throw new RuntimeException(String.format("Columns of table %s can not be null", schemaNameTableName));
        }
        if (this.databaseConfig.getHost() == null) {
            throw new RuntimeException("Host can not be null");
        }
        if (this.databaseConfig.getDatabase() == null) {
            throw new RuntimeException("Database can not be null");
        }
        if (this.databaseConfig.getPassword() == null) {
            throw new RuntimeException("Password can not be null");
        }
        if (this.databaseConfig.getUser() == null) {
            throw new RuntimeException("Username can not be null");
        }
        if (this.databaseConfig.getPort() == 0) {
            throw new RuntimeException("Port can not be 0");
        }
        if (this.databaseConfig.getEmptyAsNull() == null) {
            throw new RuntimeException("EmptyAsNull can not be null");
        }
    }

    private void getTableInfo(String userInputDatabase, List<String> userInputTables, Connection connection) {
        if (userInputTables == null) {
            throw new RuntimeException("tables is not exist");
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            HashMap columnInfoListMap = new HashMap(16);
            for (int k = 0; k < userInputTables.size(); ++k) {
                String schemaTable = userInputTables.get(k);
                String[] schemaAndTable = schemaTable.split("\\.");
                String schemaName = schemaAndTable[0];
                String tableName = schemaAndTable[1];
                String schemaTableQuote = "\"" + schemaName + "\"" + DOT + "\"" + tableName + "\"";
                if (columnInfoListMap.get(schemaTable) == null) {
                    columnInfoListMap.put(schemaTable, new ArrayList());
                }
                statement = connection.createStatement();
                String columnMetaSql = String.format("select * from %s where 1=2", schemaTableQuote);
                rs = statement.executeQuery(columnMetaSql);
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    ColumnInfo columnInfo = new ColumnInfo();
                    columnInfo.setName(resultSetMetaData.getColumnName(i));
                    columnInfo.setDataType(ColumnDataType.getTypeByName(resultSetMetaData.getColumnTypeName(i).toUpperCase()));
                    boolean nullable = resultSetMetaData.isNullable(i) == 1;
                    columnInfo.setNullable(nullable);
                    columnInfo.setDefaultValue(null);
                    ((List)columnInfoListMap.get(schemaTable)).add(columnInfo);
                }
                ResultSet ts = md.getTables(userInputDatabase, schemaName, tableName, null);
                while (ts.next()) {
                    String t = ts.getString(3);
                    String sc = ts.getString(2);
                    TableInfo tableInfoTmp = new TableInfo();
                    tableInfoTmp.setColumns((List)columnInfoListMap.get(sc + DOT + t));
                    tableInfoTmp.setTableCatalog(userInputDatabase);
                    tableInfoTmp.setTableSchema(sc);
                    tableInfoTmp.setTableName(sc + DOT + t);
                    tableInfoTmp.setTableType(ts.getString(4));
                    this.tableInfo.put(sc + DOT + t, tableInfoTmp);
                }
            }
            this.closeDBResources(rs, statement, null);
            for (String schemaNameTableName : userInputTables) {
                if (this.tableInfo.get(schemaNameTableName) == null) {
                    this.logger(ERROR, "Table" + schemaNameTableName + " is not existed or do not has any column");
                    throw new Adb4pgClientException(106, "Table" + schemaNameTableName + " is not existed or do not has any column", null);
                }
                this.tableInfo.get(schemaNameTableName).setPrimaryKeyColumns(this.getTablePrimaryKeys(connection, this.tableInfo.get(schemaNameTableName).getTableCatalog(), this.tableInfo.get(schemaNameTableName).getTableSchema(), schemaNameTableName.split("\\.")[1]));
            }
        }
        catch (Exception e) {
            throw new Adb4pgClientException(106, "GetTableInfo exception: " + e.getMessage(), null);
        }
        finally {
            this.closeDBResources(rs, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTablePrimaryKeys(Connection connection, String catalog, String schema, String table) throws SQLException {
        ArrayList<String> primaryKeyColumns = new ArrayList<String>();
        DatabaseMetaData dbMetaData = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            dbMetaData = connection.getMetaData();
            rs = dbMetaData.getPrimaryKeys(catalog, schema, table);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                primaryKeyColumns.add(columnName);
            }
            this.closeDBResources(rs, statement, null);
        }
        catch (Throwable throwable) {
            this.closeDBResources(rs, statement, null);
            throw throwable;
        }
        return primaryKeyColumns;
    }

    private Connection getConnection() {
        int retryNum = 0;
        Exception ex = null;
        while (retryNum <= this.databaseConfig.getRetryTimes()) {
            try {
                DruidPooledConnection res = this.dataSource.getConnection(60000L);
                Statement statement = res.createStatement();
                statement.executeUpdate(SET_AUTOSTATS_MODE_OFF);
                statement.executeUpdate(SET_OPTIMIZER_OFF_SQL);
                statement.executeUpdate(SET_SEQSCAN_OFF_SQL);
                return res;
            }
            catch (Exception e) {
                ex = e;
                this.logger(ERROR, "Create connection error after " + retryNum + " times retry " + e.getMessage());
                ++retryNum;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.databaseConfig.getRetryIntervalTime());
                }
                catch (InterruptedException e2) {
                    this.logger(ERROR, "create connection error " + e2.getMessage());
                }
            }
        }
        throw new Adb4pgClientException(104, "Creating statement and connection failed", (Throwable)ex);
    }

    private void logger(String level, String msg) {
        if (this.databaseConfig.getLogger() != null) {
            if (INFO.equals(level)) {
                this.databaseConfig.getLogger().info("Adb4PGClient info: {}", (Object)msg);
            } else if (ERROR.equals(level)) {
                this.databaseConfig.getLogger().error("Adb4PGClient error: {}", (Object)msg);
            }
        }
    }

    private void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        ArrayList<String> errList = new ArrayList<String>();
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Exception e) {
                errList.add("Close ResultSet occur SQLException " + e.getMessage());
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                errList.add("Close Statement occur SQLException " + e.getMessage());
            }
        }
        if (null != conn) {
            try {
                if (conn.getWarnings() != null) {
                    conn.clearWarnings();
                }
                conn.close();
            }
            catch (Exception e) {
                errList.add("Close Connection occur SQLException " + e.getMessage());
            }
        }
        if (errList.size() > 0) {
            throw new Adb4pgClientException(105, ((Object)errList).toString(), null);
        }
    }

    private static void makeSureNoValueDuplicate(List<String> aList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        if (1 == aList.size()) {
            return;
        }
        List<String> list = null;
        list = !caseSensitive ? Adb4pgClient.valueToLowerCase(aList) : new ArrayList<String>(aList);
        Collections.sort(list);
        int len = list.size() - 1;
        for (int i = 0; i < len; ++i) {
            if (!list.get(i).equals(list.get(i + 1))) continue;
            throw new RuntimeException(String.format("The column %s in config must be uniq", list.get(i)));
        }
    }

    private static List<String> valueToLowerCase(List<String> aList) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        ArrayList<String> result = new ArrayList<String>(aList.size());
        for (String oneValue : aList) {
            result.add(null != oneValue ? oneValue.toLowerCase() : null);
        }
        return result;
    }

    private static void makeSureBInA(List<String> aList, List<String> bList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty() || null == bList || bList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        List<String> all = null;
        List<String> part = null;
        if (!caseSensitive) {
            all = Adb4pgClient.valueToLowerCase(aList);
            part = Adb4pgClient.valueToLowerCase(bList);
        } else {
            all = new ArrayList<String>(aList);
            part = new ArrayList<String>(bList);
        }
        for (String oneValue : part) {
            if (all.contains(oneValue)) continue;
            throw new RuntimeException(String.format("The column %s is not exist in table", oneValue));
        }
    }

    private String convertDate(String columnValue) throws SQLException {
        java.util.Date utilDate;
        try {
            utilDate = Date.valueOf(columnValue);
            if (utilDate == null) {
                utilDate = new SimpleDateFormat("yyyy-MM-dd").parse(columnValue);
            }
        }
        catch (Exception e) {
            throw new SQLException(String.format("Date transform error\uff1a[%s]", columnValue), e);
        }
        if (utilDate == null) {
            throw new SQLException(String.format("Date transform error\uff1a[%s]", columnValue));
        }
        return ((java.util.Date)utilDate).toString();
    }

    private String convertTime(String columnValue) throws SQLException {
        Time sqlTime = null;
        try {
            sqlTime = Time.valueOf(columnValue);
            return sqlTime.toString();
        }
        catch (Exception e) {
            throw new SQLException(String.format("TIME transform error\uff1a[%s]", columnValue), e);
        }
    }

    private String convertTimeStamp(String columnValue) throws SQLException {
        Timestamp sqlTimestamp;
        try {
            sqlTimestamp = Timestamp.valueOf(columnValue);
        }
        catch (Exception e) {
            throw new SQLException(String.format("TIMESTAMP transform error\uff1a[%s]", columnValue), e);
        }
        return sqlTimestamp.toString();
    }

    private String dataConvertor(int columnSqltype, Object columnObject, String schemaNameTableName, String columnName) throws SQLException {
        boolean isEmpty;
        if (columnObject == null) {
            return null;
        }
        String value = columnObject.toString();
        boolean bl = isEmpty = this.databaseConfig.getEmptyAsNull() != false && "".equals(value);
        if (isEmpty) {
            return null;
        }
        switch (columnSqltype) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new BigDecimal(value).toString();
            }
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(value).toString();
            }
            case 91: {
                return this.convertDate(value);
            }
            case 92: {
                return this.convertTime(value);
            }
            case 93: {
                return this.convertTimeStamp(value);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 16: 
            case 1111: 
            case 2005: 
            case 2011: {
                return this.escapeString(value);
            }
        }
        return this.escapeString(value);
    }

    private Row mapToRow(Map<String, String> dataMap, String tableName, String schemaName) {
        List<String> userConfigColumn = this.databaseConfig.getColumns(tableName, schemaName);
        Row row = new Row();
        for (int k = 0; k < userConfigColumn.size(); ++k) {
            row.setColumn(k, null);
        }
        int i = 0;
        String schemaNameTableName = this.schemNameTableNameCache.get(schemaName).get(tableName);
        for (ColumnInfo ci : this.tableInfo.get(schemaNameTableName).getColumns()) {
            if (!this.isAllColumn.get(schemaNameTableName).booleanValue()) {
                i = this.databaseConfig.getColumns(tableName, schemaName).indexOf(ci.getName());
            }
            if (dataMap.get(ci.getName()) != null) {
                row.updateColumn(i, dataMap.get(ci.getName()));
                dataMap.remove(ci.getName());
            } else {
                if (!ci.isNullable()) {
                    throw new Adb4pgClientException(103, String.format("The column %s of table %s can not be null", ci.getName(), tableName), null);
                }
                row.updateColumn(i, ci.getDefaultValue());
            }
            if (!this.isAllColumn.get(schemaNameTableName).booleanValue()) continue;
            ++i;
        }
        if (dataMap.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> e : dataMap.entrySet()) {
                sb.append(e.getKey());
                sb.append(" ");
            }
            throw new Adb4pgClientException(103, String.format("The columns %s do not exit in table %s or not be configured", sb.toString(), schemaName + DOT + tableName), null);
        }
        return row;
    }

    public void stop() {
        if (this.dataBuffer.size() > 0 && this.commitExceptionDataList.size() == 0) {
            throw new Adb4pgClientException(107, "Batch data do not commit, please commit first", null);
        }
        this.forceStop();
    }

    public void forceStop() {
        this.executorService.shutdown();
        if (this.dataBuffer != null) {
            this.dataBuffer.clear();
        }
        this.tableInfo.clear();
        this.tableColumnsMetaData.clear();
        this.configColumnsMetaData.clear();
    }

    private String escapeString(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\u0000", "").replace("\\", "\\\\").replace("\"", "\\\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Task {
        List<String> outputStream;
        String schemaNameTableName;
        List<String> tableColumns;

        Task(List<String> outputStream, String schemaNameTableName, List<String> tableColumns) {
            this.outputStream = outputStream;
            this.schemaNameTableName = schemaNameTableName;
            this.tableColumns = tableColumns;
        }
    }
}

