/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.meta;

import com.alibaba.bytekit.asm.meta.ClassMetaCache;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassMeta {
    private String internalClassName;
    private String internalSuperName;
    private Set<String> interfaces = new HashSet<String>();
    private ClassMeta superClassMeta;
    private List<ClassMeta> interfaceClassMetas = null;
    private int access;
    private ClassLoader classLoader;

    public ClassMeta() {
    }

    public ClassMeta(byte[] classfileBuffer, ClassLoader classLoader) {
        ClassReader reader = new ClassReader(classfileBuffer);
        this.internalClassName = reader.getClassName();
        this.internalSuperName = reader.getSuperName();
        String[] interfacesArray = reader.getInterfaces();
        if (interfacesArray != null) {
            for (String i : interfacesArray) {
                this.interfaces.add(i);
            }
        }
        this.access = reader.getAccess();
        this.classLoader = ClassLoaderUtils.wrap(classLoader);
    }

    public static ClassMeta fromByteCode(byte[] classfileBuffer, ClassLoader classLoader) {
        if (classfileBuffer == null) {
            return null;
        }
        return new ClassMeta(classfileBuffer, classLoader);
    }

    public boolean isInterface() {
        return (this.access & 0x200) > 0;
    }

    public ClassMeta getSuperclass() {
        if (this.internalSuperName == null) {
            return null;
        }
        if (this.superClassMeta == null) {
            byte[] classBytes = ClassLoaderUtils.readBytecodeByName(this.classLoader, this.internalSuperName);
            if (classBytes == null) {
                return null;
            }
            this.superClassMeta = new ClassMeta(classBytes, this.classLoader);
        }
        return this.superClassMeta;
    }

    private boolean isSubclassOf(ClassMeta other) {
        for (ClassMeta c = this; c != null; c = c.getSuperclass()) {
            ClassMeta sc = c.getSuperclass();
            if (sc == null || !sc.internalClassName.equals(other.internalClassName)) continue;
            return true;
        }
        return false;
    }

    List<ClassMeta> interfaceMetas() {
        if (this.interfaceClassMetas == null) {
            this.interfaceClassMetas = new ArrayList<ClassMeta>();
            for (String interfaceName : this.interfaces) {
                byte[] classBytes = ClassLoaderUtils.readBytecodeByName(this.classLoader, interfaceName);
                if (classBytes == null) continue;
                ClassMeta meta = new ClassMeta(classBytes, this.classLoader);
                this.interfaceClassMetas.add(meta);
            }
        }
        return this.interfaceClassMetas;
    }

    private boolean implementsInterface(ClassMeta other) {
        if (this.equals(other)) {
            return true;
        }
        for (ClassMeta c = this; c != null; c = c.getSuperclass()) {
            for (ClassMeta in : c.interfaceMetas()) {
                if (!in.internalClassName.equals(other.internalClassName) && !in.implementsInterface(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAssignableFrom(ClassMeta other) {
        return this.equals(other) || other.implementsInterface(this) || other.isSubclassOf(this) || other.isInterface() && this.internalClassName.equals("Ljava/lang/Object;");
    }

    public Set<String> allInterfaces(ClassMetaCache classMetaCache) {
        ClassMeta classMeta;
        HashSet<String> result = new HashSet<String>(this.interfaces);
        if (this.internalSuperName != null && (classMeta = classMetaCache.findClassMeta(this.internalSuperName)) != null) {
            result.addAll(classMeta.allInterfaces(classMetaCache));
        }
        for (String interfaceName : this.interfaces) {
            ClassMeta classMeta2 = classMetaCache.findClassMeta(interfaceName);
            if (classMeta2 == null) continue;
            result.addAll(classMeta2.allInterfaces(classMetaCache));
        }
        return result;
    }

    public List<String> allSuperNames(ClassMetaCache classMetaCache) {
        ArrayList<String> result = new ArrayList<String>();
        String superName = this.internalSuperName;
        while (superName != null) {
            result.add(superName);
            ClassMeta classMeta = classMetaCache.findClassMeta(superName);
            if (classMeta == null) break;
            superName = classMeta.getInternalSuperName();
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalClassName == null ? 0 : this.internalClassName.hashCode());
        result = 31 * result + (this.internalSuperName == null ? 0 : this.internalSuperName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMeta other = (ClassMeta)obj;
        if (this.internalClassName == null ? other.internalClassName != null : !this.internalClassName.equals(other.internalClassName)) {
            return false;
        }
        return !(this.internalSuperName == null ? other.internalSuperName != null : !this.internalSuperName.equals(other.internalSuperName));
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public void setInternalClassName(String internalClassName) {
        this.internalClassName = internalClassName;
    }

    public String getInternalSuperName() {
        return this.internalSuperName;
    }

    public void setInternalSuperName(String internalSuperName) {
        this.internalSuperName = internalSuperName;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }
}

