/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.utils;

import com.alibaba.arthas.deps.org.objectweb.asm.ClassReader;
import com.alibaba.arthas.deps.org.objectweb.asm.ClassVisitor;
import com.alibaba.arthas.deps.org.objectweb.asm.ClassWriter;
import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.alibaba.arthas.deps.org.objectweb.asm.util.CheckClassAdapter;
import com.taobao.arthas.bytekit.utils.AsmUtils;
import com.taobao.arthas.bytekit.utils.ClassLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class VerifyUtils {
    public static void asmVerify(byte[] bytes, boolean printResults) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ClassReader cr = new ClassReader((InputStream)inputStream);
        CheckClassAdapter.verify((ClassReader)cr, (boolean)true, (PrintWriter)new PrintWriter(System.out));
    }

    public static void asmVerify(byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ClassReader cr = new ClassReader((InputStream)inputStream);
        ClassWriter cw = new ClassWriter(1);
        CheckClassAdapter cv = new CheckClassAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
    }

    public static Object instanceVerity(byte[] bytes) throws Exception {
        String name = Type.getObjectType((String)AsmUtils.toClassNode((byte[])bytes).name).getClassName();
        ClassbyteClassLoader cl = new ClassbyteClassLoader(ClassLoaderUtils.getUrls(ClassLoader.getSystemClassLoader()), ClassLoader.getSystemClassLoader().getParent());
        cl.addClass(name, bytes);
        Class<?> loadClass = cl.loadClass(name);
        return loadClass.newInstance();
    }

    public static Object invoke(Object instance, String name, Object ... args) throws Exception {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (!name.contentEquals(method.getName())) continue;
            return method.invoke(instance, args);
        }
        throw new NoSuchMethodError("name: " + name);
    }

    public static class ClassbyteClassLoader
    extends URLClassLoader {
        public ClassbyteClassLoader(URL[] urls, ClassLoader cl) {
            super(urls, cl);
        }

        public Class<?> addClass(String name, byte[] bytes) throws ClassFormatError {
            Class<?> cl = this.defineClass(name, bytes, 0, bytes.length);
            this.resolveClass(cl);
            return cl;
        }
    }
}

