/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.binding;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.LineNumberNode;
import com.taobao.arthas.bytekit.asm.binding.Binding;
import com.taobao.arthas.bytekit.asm.binding.BindingContext;
import com.taobao.arthas.bytekit.asm.location.Location;
import com.taobao.arthas.bytekit.utils.AsmOpUtils;

public class LineBinding
extends Binding {
    private boolean exact;

    public LineBinding(boolean exact) {
        this.exact = exact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        AbstractInsnNode insnNode;
        Location location = bindingContext.getLocation();
        int line = -1;
        if (this.exact) {
            if (!(insnNode instanceof LineNumberNode)) throw new IllegalArgumentException("LineBinding location is not LineNumberNode, insnNode: " + insnNode);
            line = ((LineNumberNode)insnNode).line;
        } else if (!location.isWhenComplete()) {
            for (insnNode = location.getInsnNode(); insnNode != null; insnNode = insnNode.getPrevious()) {
                if (!(insnNode instanceof LineNumberNode)) continue;
                line = ((LineNumberNode)insnNode).line;
                break;
            }
        } else {
            while (insnNode != null) {
                if (insnNode instanceof LineNumberNode) {
                    line = ((LineNumberNode)insnNode).line;
                    break;
                }
                insnNode = insnNode.getNext();
            }
        }
        AsmOpUtils.push(instructions, line);
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        return Type.getType(Integer.TYPE);
    }
}

