/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.common;

import com.alibaba.nacos.api.exception.NacosException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class NacosFailureAnalyzer
extends AbstractFailureAnalyzer<NacosException> {
    protected FailureAnalysis analyze(Throwable rootFailure, NacosException cause) {
        StringBuilder description = new StringBuilder();
        switch (cause.getErrCode()) {
            case -400: {
                description.append("client error: invalid param");
                break;
            }
            case -503: {
                description.append("client error: over client threshold");
                break;
            }
            case 502: {
                description.append("server error: bad gateway");
                break;
            }
            case 409: {
                description.append("server error: conflict");
                break;
            }
            case 400: {
                description.append("server error: invalid param");
                break;
            }
            case 403: {
                description.append("server error: no right");
                break;
            }
            case 503: {
                description.append("server error: over threshold");
                break;
            }
            case 500: {
                description.append("server error: such as timeout");
                break;
            }
            default: {
                description.append("unknown reason");
            }
        }
        description.append(". ").append(cause.getErrMsg());
        String action = description.toString().contains("client") ? "please check your client configuration" : "please check server status";
        return new FailureAnalysis(description.toString(), action, (Throwable)cause);
    }
}

