/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.compiler.processor;

import com.alibaba.android.arouter.compiler.processor.BaseProcessor;
import com.alibaba.android.arouter.facade.annotation.Interceptor;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedAnnotationTypes(value={"com.alibaba.android.arouter.facade.annotation.Interceptor"})
@AutoService(value={Processor.class})
public class InterceptorProcessor
extends BaseProcessor {
    private Map<Integer, Element> interceptors = new TreeMap<Integer, Element>();
    private TypeMirror iInterceptor = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.iInterceptor = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IInterceptor").asType();
        this.logger.info(">>> InterceptorProcessor init. <<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (CollectionUtils.isNotEmpty(annotations)) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Interceptor.class);
            try {
                this.parseInterceptors(elements);
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            return true;
        }
        return false;
    }

    private void parseInterceptors(Set<? extends Element> elements) throws IOException {
        if (CollectionUtils.isNotEmpty(elements)) {
            this.logger.info(">>> Found interceptors, size is " + elements.size() + " <<<");
            for (Element element : elements) {
                if (this.verify(element)) {
                    this.logger.info("A interceptor verify over, its " + element.asType());
                    Interceptor interceptor = element.getAnnotation(Interceptor.class);
                    Element lastInterceptor = this.interceptors.get(interceptor.priority());
                    if (null != lastInterceptor) {
                        throw new IllegalArgumentException(String.format(Locale.getDefault(), "More than one interceptors use same priority [%d], They are [%s] and [%s].", interceptor.priority(), lastInterceptor.getSimpleName(), element.getSimpleName()));
                    }
                    this.interceptors.put(interceptor.priority(), element);
                    continue;
                }
                this.logger.error("A interceptor verify failed, its " + element.asType());
            }
            TypeElement type_ITollgate = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IInterceptor");
            TypeElement typeElement = this.elementUtils.getTypeElement("com.alibaba.android.arouter.facade.template.IInterceptorGroup");
            ParameterizedTypeName inputMapTypeOfTollgate = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Integer.class), ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get((TypeElement)type_ITollgate))})});
            ParameterSpec tollgateParamSpec = ParameterSpec.builder((TypeName)inputMapTypeOfTollgate, (String)"interceptors", (Modifier[])new Modifier[0]).build();
            MethodSpec.Builder loadIntoMethodOfTollgateBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(tollgateParamSpec);
            if (null != this.interceptors && this.interceptors.size() > 0) {
                for (Map.Entry<Integer, Element> entry : this.interceptors.entrySet()) {
                    loadIntoMethodOfTollgateBuilder.addStatement("interceptors.put(" + entry.getKey() + ", $T.class)", new Object[]{ClassName.get((TypeElement)((TypeElement)entry.getValue()))});
                }
            }
            JavaFile.builder((String)"com.alibaba.android.arouter.routes", (TypeSpec)TypeSpec.classBuilder((String)("ARouter$$Interceptors$$" + this.moduleName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("DO NOT EDIT THIS FILE!!! IT WAS GENERATED BY AROUTER.", new Object[0]).addMethod(loadIntoMethodOfTollgateBuilder.build()).addSuperinterface((TypeName)ClassName.get((TypeElement)typeElement)).build()).build().writeTo(this.mFiler);
            this.logger.info(">>> Interceptor group write over. <<<");
        }
    }

    private boolean verify(Element element) {
        Interceptor interceptor = element.getAnnotation(Interceptor.class);
        return null != interceptor && ((TypeElement)element).getInterfaces().contains(this.iInterceptor);
    }
}

