/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.core.Warehouse;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.enums.TypeKind;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.alibaba.android.arouter.facade.template.IInterceptorGroup;
import com.alibaba.android.arouter.facade.template.IProvider;
import com.alibaba.android.arouter.facade.template.IProviderGroup;
import com.alibaba.android.arouter.facade.template.IRouteGroup;
import com.alibaba.android.arouter.facade.template.IRouteRoot;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.utils.ClassUtils;
import com.alibaba.android.arouter.utils.MapUtils;
import com.alibaba.android.arouter.utils.PackageUtils;
import com.alibaba.android.arouter.utils.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public class LogisticsCenter {
    private static Context mContext;
    static ThreadPoolExecutor executor;
    private static boolean registerByPlugin;

    private static void loadRouterMap() {
        registerByPlugin = false;
    }

    private static void register(String className) {
        if (!TextUtils.isEmpty(className)) {
            try {
                Class<?> clazz = Class.forName(className);
                Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj instanceof IRouteRoot) {
                    LogisticsCenter.registerRouteRoot((IRouteRoot)obj);
                } else if (obj instanceof IProviderGroup) {
                    LogisticsCenter.registerProvider((IProviderGroup)obj);
                } else if (obj instanceof IInterceptorGroup) {
                    LogisticsCenter.registerInterceptor((IInterceptorGroup)obj);
                } else {
                    ARouter.logger.info("ARouter::", "register failed, class name: " + className + " should implements one of IRouteRoot/IProviderGroup/IInterceptorGroup.");
                }
            }
            catch (Exception e) {
                ARouter.logger.error("ARouter::", "register class error:" + className, e);
            }
        }
    }

    private static void registerRouteRoot(IRouteRoot routeRoot) {
        LogisticsCenter.markRegisteredByPlugin();
        if (routeRoot != null) {
            routeRoot.loadInto(Warehouse.groupsIndex);
        }
    }

    private static void registerInterceptor(IInterceptorGroup interceptorGroup) {
        LogisticsCenter.markRegisteredByPlugin();
        if (interceptorGroup != null) {
            interceptorGroup.loadInto(Warehouse.interceptorsIndex);
        }
    }

    private static void registerProvider(IProviderGroup providerGroup) {
        LogisticsCenter.markRegisteredByPlugin();
        if (providerGroup != null) {
            providerGroup.loadInto(Warehouse.providersIndex);
        }
    }

    private static void markRegisteredByPlugin() {
        if (!registerByPlugin) {
            registerByPlugin = true;
        }
    }

    public static synchronized void init(Context context, ThreadPoolExecutor tpe) throws HandlerException {
        mContext = context;
        executor = tpe;
        try {
            long startInit = System.currentTimeMillis();
            LogisticsCenter.loadRouterMap();
            if (registerByPlugin) {
                ARouter.logger.info("ARouter::", "Load router map by arouter-auto-register plugin.");
            } else {
                Set<String> routerMap;
                if (ARouter.debuggable() || PackageUtils.isNewVersion(context)) {
                    ARouter.logger.info("ARouter::", "Run with debug mode or new install, rebuild router map.");
                    routerMap = ClassUtils.getFileNameByPackageName(mContext, "com.alibaba.android.arouter.routes");
                    if (!routerMap.isEmpty()) {
                        context.getSharedPreferences("SP_AROUTER_CACHE", 0).edit().putStringSet("ROUTER_MAP", routerMap).apply();
                    }
                    PackageUtils.updateVersion(context);
                } else {
                    ARouter.logger.info("ARouter::", "Load router map from cache.");
                    routerMap = new HashSet<String>(context.getSharedPreferences("SP_AROUTER_CACHE", 0).getStringSet("ROUTER_MAP", new HashSet()));
                }
                ARouter.logger.info("ARouter::", "Find router map finished, map size = " + routerMap.size() + ", cost " + (System.currentTimeMillis() - startInit) + " ms.");
                startInit = System.currentTimeMillis();
                for (String className : routerMap) {
                    if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Root")) {
                        ((IRouteRoot)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.groupsIndex);
                        continue;
                    }
                    if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Interceptors")) {
                        ((IInterceptorGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.interceptorsIndex);
                        continue;
                    }
                    if (!className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Providers")) continue;
                    ((IProviderGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.providersIndex);
                }
            }
            ARouter.logger.info("ARouter::", "Load root element finished, cost " + (System.currentTimeMillis() - startInit) + " ms.");
            if (Warehouse.groupsIndex.size() == 0) {
                ARouter.logger.error("ARouter::", "No mapping files were found, check your configuration please!");
            }
            if (ARouter.debuggable()) {
                ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "LogisticsCenter has already been loaded, GroupIndex[%d], InterceptorIndex[%d], ProviderIndex[%d]", Warehouse.groupsIndex.size(), Warehouse.interceptorsIndex.size(), Warehouse.providersIndex.size()));
            }
        }
        catch (Exception e) {
            throw new HandlerException("ARouter::ARouter init logistics center exception! [" + e.getMessage() + "]");
        }
    }

    public static Postcard buildProvider(String serviceName) {
        RouteMeta meta = Warehouse.providersIndex.get(serviceName);
        if (null == meta) {
            return null;
        }
        return new Postcard(meta.getPath(), meta.getGroup());
    }

    public static synchronized void completion(Postcard postcard) {
        if (null == postcard) {
            throw new NoRouteFoundException("ARouter::No postcard!");
        }
        RouteMeta routeMeta = Warehouse.routes.get(postcard.getPath());
        if (null == routeMeta) {
            if (!Warehouse.groupsIndex.containsKey(postcard.getGroup())) {
                throw new NoRouteFoundException("ARouter::There is no route match the path [" + postcard.getPath() + "], in group [" + postcard.getGroup() + "]");
            }
            try {
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] starts loading, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
                LogisticsCenter.addRouteGroupDynamic(postcard.getGroup(), null);
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] has already been loaded, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
            }
            catch (Exception e) {
                throw new HandlerException("ARouter::Fatal exception when loading group meta. [" + e.getMessage() + "]");
            }
            LogisticsCenter.completion(postcard);
        } else {
            postcard.setDestination(routeMeta.getDestination());
            postcard.setType(routeMeta.getType());
            postcard.setPriority(routeMeta.getPriority());
            postcard.setExtra(routeMeta.getExtra());
            Uri rawUri = postcard.getUri();
            if (null != rawUri) {
                Map<String, String> resultMap = TextUtils.splitQueryParameters(rawUri);
                Map paramsType = routeMeta.getParamsType();
                if (MapUtils.isNotEmpty(paramsType)) {
                    for (Map.Entry params : paramsType.entrySet()) {
                        LogisticsCenter.setValue(postcard, (Integer)params.getValue(), (String)params.getKey(), resultMap.get(params.getKey()));
                    }
                    postcard.getExtras().putStringArray("wmHzgD4lOj5o4241", paramsType.keySet().toArray(new String[0]));
                }
                postcard.withString("NTeRQWvye18AkPd6G", rawUri.toString());
            }
            switch (routeMeta.getType()) {
                case PROVIDER: {
                    Class providerMeta = routeMeta.getDestination();
                    IProvider instance = Warehouse.providers.get(providerMeta);
                    if (null == instance) {
                        try {
                            IProvider provider = (IProvider)providerMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                            provider.init(mContext);
                            Warehouse.providers.put(providerMeta, provider);
                            instance = provider;
                        }
                        catch (Exception e) {
                            ARouter.logger.error("ARouter::", "Init provider failed!", e);
                            throw new HandlerException("Init provider failed!");
                        }
                    }
                    postcard.setProvider(instance);
                    postcard.greenChannel();
                    break;
                }
                case FRAGMENT: {
                    postcard.greenChannel();
                }
            }
        }
    }

    private static void setValue(Postcard postcard, Integer typeDef, String key, String value) {
        if (TextUtils.isEmpty(key) || TextUtils.isEmpty(value)) {
            return;
        }
        try {
            if (null != typeDef) {
                if (typeDef.intValue() == TypeKind.BOOLEAN.ordinal()) {
                    postcard.withBoolean(key, Boolean.parseBoolean(value));
                } else if (typeDef.intValue() == TypeKind.BYTE.ordinal()) {
                    postcard.withByte(key, Byte.parseByte(value));
                } else if (typeDef.intValue() == TypeKind.SHORT.ordinal()) {
                    postcard.withShort(key, Short.parseShort(value));
                } else if (typeDef.intValue() == TypeKind.INT.ordinal()) {
                    postcard.withInt(key, Integer.parseInt(value));
                } else if (typeDef.intValue() == TypeKind.LONG.ordinal()) {
                    postcard.withLong(key, Long.parseLong(value));
                } else if (typeDef.intValue() == TypeKind.FLOAT.ordinal()) {
                    postcard.withFloat(key, Float.parseFloat(value));
                } else if (typeDef.intValue() == TypeKind.DOUBLE.ordinal()) {
                    postcard.withDouble(key, Double.parseDouble(value));
                } else if (typeDef.intValue() == TypeKind.STRING.ordinal()) {
                    postcard.withString(key, value);
                } else if (typeDef.intValue() != TypeKind.PARCELABLE.ordinal()) {
                    if (typeDef.intValue() == TypeKind.OBJECT.ordinal()) {
                        postcard.withString(key, value);
                    } else {
                        postcard.withString(key, value);
                    }
                }
            } else {
                postcard.withString(key, value);
            }
        }
        catch (Throwable ex) {
            ARouter.logger.warning("ARouter::", "LogisticsCenter setValue failed! " + ex.getMessage());
        }
    }

    public static void suspend() {
        Warehouse.clear();
    }

    public static synchronized void addRouteGroupDynamic(String groupName, IRouteGroup group) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (Warehouse.groupsIndex.containsKey(groupName)) {
            Warehouse.groupsIndex.get(groupName).getConstructor(new Class[0]).newInstance(new Object[0]).loadInto(Warehouse.routes);
            Warehouse.groupsIndex.remove(groupName);
        }
        if (null != group) {
            group.loadInto(Warehouse.routes);
        }
    }
}

