/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.util.LruCache;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.service.AutowiredService;
import com.alibaba.android.arouter.facade.template.ISyringe;
import java.util.ArrayList;
import java.util.List;

@Route(path="/arouter/service/autowired")
public class AutowiredServiceImpl
implements AutowiredService {
    private LruCache<String, ISyringe> classCache;
    private List<String> blackList;

    @Override
    public void init(Context context) {
        this.classCache = new LruCache(50);
        this.blackList = new ArrayList<String>();
    }

    @Override
    public void autowire(Object instance) {
        this.doInject(instance, null);
    }

    private void doInject(Object instance, Class<?> parent) {
        Class<?> superClazz;
        Class<?> clazz = null == parent ? instance.getClass() : parent;
        ISyringe syringe = this.getSyringe(clazz);
        if (null != syringe) {
            syringe.inject(instance);
        }
        if (null != (superClazz = clazz.getSuperclass()) && !superClazz.getName().startsWith("android")) {
            this.doInject(instance, superClazz);
        }
    }

    private ISyringe getSyringe(Class<?> clazz) {
        String className = clazz.getName();
        try {
            if (!this.blackList.contains(className)) {
                ISyringe syringeHelper = (ISyringe)this.classCache.get((Object)className);
                if (null == syringeHelper) {
                    syringeHelper = (ISyringe)Class.forName(clazz.getName() + "$$ARouter$$Autowired").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.classCache.put((Object)className, (Object)syringeHelper);
                return syringeHelper;
            }
        }
        catch (Exception e) {
            this.blackList.add(className);
        }
        return null;
    }
}

