/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.core.Warehouse;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.alibaba.android.arouter.facade.template.IInterceptorGroup;
import com.alibaba.android.arouter.facade.template.IProvider;
import com.alibaba.android.arouter.facade.template.IProviderGroup;
import com.alibaba.android.arouter.facade.template.IRouteGroup;
import com.alibaba.android.arouter.facade.template.IRouteRoot;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.utils.ClassUtils;
import com.alibaba.android.arouter.utils.TextUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.MapUtils;

public class LogisticsCenter {
    private static Context mContext;
    static ThreadPoolExecutor executor;

    public static synchronized void init(Context context, ThreadPoolExecutor tpe) throws HandlerException {
        mContext = context;
        executor = tpe;
        try {
            List<String> classFileNames = ClassUtils.getFileNameByPackageName(mContext, "com.alibaba.android.arouter.routes");
            for (String className : classFileNames) {
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Root")) {
                    ((IRouteRoot)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.groupsIndex);
                    continue;
                }
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Interceptors")) {
                    ((IInterceptorGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.interceptorsIndex);
                    continue;
                }
                if (!className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Providers")) continue;
                ((IProviderGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.providersIndex);
            }
            if (Warehouse.groupsIndex.size() == 0) {
                ARouter.logger.error("ARouter::", "No mapping files were found, check your configuration please!");
            }
            if (ARouter.debuggable()) {
                ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "LogisticsCenter has already been loaded, GroupIndex[%d], InterceptorIndex[%d], ProviderIndex[%d]", Warehouse.groupsIndex.size(), Warehouse.interceptorsIndex.size(), Warehouse.providersIndex.size()));
            }
        }
        catch (Exception e) {
            throw new HandlerException("ARouter::ARouter init logistics center exception! [" + e.getMessage() + "]");
        }
    }

    public static Postcard buildProvider(String serviceName) {
        RouteMeta meta = Warehouse.providersIndex.get(serviceName);
        if (null == meta) {
            return null;
        }
        return new Postcard(meta.getPath(), meta.getGroup());
    }

    public static synchronized void completion(Postcard postcard) {
        if (null == postcard) {
            throw new NoRouteFoundException("ARouter::No postcard!");
        }
        RouteMeta routeMeta = Warehouse.routes.get(postcard.getPath());
        if (null == routeMeta) {
            Class<? extends IRouteGroup> groupMeta = Warehouse.groupsIndex.get(postcard.getGroup());
            if (null == groupMeta) {
                throw new NoRouteFoundException("ARouter::There is no route match the path [" + postcard.getPath() + "], in group [" + postcard.getGroup() + "]");
            }
            try {
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] starts loading, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
                IRouteGroup iGroupInstance = groupMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                iGroupInstance.loadInto(Warehouse.routes);
                Warehouse.groupsIndex.remove(postcard.getGroup());
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] has already been loaded, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
            }
            catch (Exception e) {
                throw new HandlerException("ARouter::Fatal exception when loading group meta. [" + e.getMessage() + "]");
            }
            LogisticsCenter.completion(postcard);
        } else {
            postcard.setDestination(routeMeta.getDestination());
            postcard.setType(routeMeta.getType());
            postcard.setPriority(routeMeta.getPriority());
            postcard.setExtra(routeMeta.getExtra());
            Uri rawUri = postcard.getUri();
            if (null != rawUri) {
                Map<String, String> resultMap = TextUtils.splitQueryParameters(rawUri);
                Map paramsType = routeMeta.getParamsType();
                if (MapUtils.isNotEmpty((Map)paramsType)) {
                    for (Map.Entry params : paramsType.entrySet()) {
                        LogisticsCenter.setValue(postcard, (Integer)params.getValue(), (String)params.getKey(), resultMap.get(TextUtils.getRight((String)params.getKey())));
                    }
                    postcard.getExtras().putStringArray("wmHzgD4lOj5o4241", paramsType.keySet().toArray(new String[0]));
                }
                postcard.withString("NTeRQWvye18AkPd6G", rawUri.toString());
            }
            switch (routeMeta.getType()) {
                case PROVIDER: {
                    Class providerMeta = routeMeta.getDestination();
                    IProvider instance = Warehouse.providers.get(providerMeta);
                    if (null == instance) {
                        try {
                            IProvider provider = (IProvider)providerMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                            provider.init(mContext);
                            Warehouse.providers.put(providerMeta, provider);
                            instance = provider;
                        }
                        catch (Exception e) {
                            throw new HandlerException("Init provider failed! " + e.getMessage());
                        }
                    }
                    postcard.setProvider(instance);
                    postcard.greenChannel();
                    break;
                }
            }
        }
    }

    private static void setValue(Postcard postcard, Integer typeDef, String key, String value) {
        try {
            String currentKey = TextUtils.getLeft(key);
            if (null != typeDef) {
                switch (typeDef) {
                    case 0: {
                        postcard.withBoolean(currentKey, Boolean.parseBoolean(value));
                        break;
                    }
                    case 1: {
                        postcard.withByte(currentKey, Byte.valueOf(value));
                        break;
                    }
                    case 2: {
                        postcard.withShort(currentKey, Short.valueOf(value));
                        break;
                    }
                    case 3: {
                        postcard.withInt(currentKey, Integer.valueOf(value));
                        break;
                    }
                    case 4: {
                        postcard.withLong(currentKey, Long.valueOf(value));
                        break;
                    }
                    case 6: {
                        postcard.withFloat(currentKey, Float.valueOf(value).floatValue());
                        break;
                    }
                    case 7: {
                        postcard.withDouble(currentKey, Double.valueOf(value));
                        break;
                    }
                    default: {
                        postcard.withString(currentKey, value);
                        break;
                    }
                }
            } else {
                postcard.withString(currentKey, value);
            }
        }
        catch (Throwable ex) {
            ARouter.logger.warning("ARouter::", "LogisticsCenter setValue failed! " + ex.getMessage());
        }
    }

    public static void suspend() {
        Warehouse.clear();
    }
}

