/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.callback.InterceptorCallback;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.alibaba.android.arouter.facade.template.IInterceptor;
import com.alibaba.android.arouter.facade.template.IInterceptorGroup;
import com.alibaba.android.arouter.facade.template.IProvider;
import com.alibaba.android.arouter.facade.template.IProviderGroup;
import com.alibaba.android.arouter.facade.template.IRouteGroup;
import com.alibaba.android.arouter.facade.template.IRouteRoot;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.thread.CancelableCountDownLatch;
import com.alibaba.android.arouter.utils.ClassUtils;
import com.alibaba.android.arouter.utils.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class LogisticsCenter {
    private static Map<String, Class<? extends IRouteGroup>> groupsIndex = new HashMap<String, Class<? extends IRouteGroup>>();
    private static Map<String, RouteMeta> routes = new HashMap<String, RouteMeta>();
    private static Map<Class, IProvider> providers = new HashMap<Class, IProvider>();
    private static Map<String, RouteMeta> providersIndex = new HashMap<String, RouteMeta>();
    private static Map<Integer, Class<? extends IInterceptor>> interceptorsIndex = new TreeMap<Integer, Class<? extends IInterceptor>>();
    private static List<IInterceptor> interceptors = new ArrayList<IInterceptor>();
    private static Context mContext;
    private static ThreadPoolExecutor executor;
    private static boolean interceptorHasInit;
    private static final Object interceptorInitLock;

    public static synchronized void init(Context context, ThreadPoolExecutor tpe) throws HandlerException {
        mContext = context;
        executor = tpe;
        try {
            List<String> classFileNames = ClassUtils.getFileNameByPackageName(mContext, "com.alibaba.android.arouter.routes");
            for (String className : classFileNames) {
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Root")) {
                    ((IRouteRoot)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(groupsIndex);
                    continue;
                }
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Interceptors")) {
                    ((IInterceptorGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(interceptorsIndex);
                    continue;
                }
                if (!className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Providers")) continue;
                ((IProviderGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(providersIndex);
            }
            if (ARouter.debuggable()) {
                ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "LogisticsCenter has already been loaded, GroupIndex[%d], InterceptorIndex[%d], ProviderIndex[%d]", groupsIndex.size(), interceptorsIndex.size(), providersIndex.size()));
            }
        }
        catch (Exception e) {
            throw new HandlerException("ARouter::ARouter init atlas exception! [" + e.getMessage() + "]");
        }
    }

    public static void initInterceptors() {
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null != interceptorsIndex && interceptorsIndex.size() > 0) {
                    for (Map.Entry entry : interceptorsIndex.entrySet()) {
                        Class interceptorClass = (Class)entry.getValue();
                        try {
                            IInterceptor iInterceptor = (IInterceptor)interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            iInterceptor.init(mContext);
                            interceptors.add(iInterceptor);
                        }
                        catch (Exception ex) {
                            throw new HandlerException("ARouter::ARouter init interceptor error! name = [" + interceptorClass.getName() + "], reason = [" + ex.getMessage() + "]");
                        }
                    }
                    interceptorHasInit = true;
                    ARouter.logger.info("ARouter::", "ARouter interceptors init over.");
                    Object object = interceptorInitLock;
                    synchronized (object) {
                        interceptorInitLock.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInterceptorsInitStatus() {
        Object object = interceptorInitLock;
        synchronized (object) {
            while (!interceptorHasInit) {
                try {
                    interceptorInitLock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new HandlerException("ARouter::ARouter waiting for interceptor init error! reason = [" + e.getMessage() + "]");
                }
            }
        }
    }

    public static Postcard buildProvider(String serviceName) {
        RouteMeta meta = providersIndex.get(serviceName);
        if (null == meta) {
            return null;
        }
        return new Postcard(meta.getPath(), meta.getGroup());
    }

    public static synchronized void completion(Postcard postcard) {
        if (null == postcard) {
            throw new NoRouteFoundException("ARouter::No postcard!");
        }
        RouteMeta routeMeta = routes.get(postcard.getPath());
        if (null == routeMeta) {
            Class<? extends IRouteGroup> groupMeta = groupsIndex.get(postcard.getGroup());
            if (null == groupMeta) {
                throw new NoRouteFoundException("ARouter::There is no route match the path [" + postcard.getPath() + "], in group [" + postcard.getGroup() + "]");
            }
            try {
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] starts loading, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
                IRouteGroup iGroupInstance = groupMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                iGroupInstance.loadInto(routes);
                groupsIndex.remove(postcard.getGroup());
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] has already been loaded, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
            }
            catch (Exception e) {
                throw new HandlerException("ARouter::Fatal exception when loading group meta. [" + e.getMessage() + "]");
            }
            LogisticsCenter.completion(postcard);
        } else {
            postcard.setDestination(routeMeta.getDestination());
            postcard.setType(routeMeta.getType());
            postcard.setPriority(routeMeta.getPriority());
            postcard.setExtra(routeMeta.getExtra());
            Uri rawUri = postcard.getUri();
            if (null != rawUri) {
                Map<String, String> resultMap = TextUtils.splitQueryParameters(rawUri);
                Map paramsType = routeMeta.getParamsType();
                if (MapUtils.isNotEmpty((Map)paramsType)) {
                    for (Map.Entry params : paramsType.entrySet()) {
                        LogisticsCenter.setValue(postcard, (Integer)params.getValue(), (String)params.getKey(), resultMap.get(LogisticsCenter.getRight((String)params.getKey())));
                    }
                    postcard.getExtras().putStringArray("wmHzgD4lOj5o4241", paramsType.keySet().toArray(new String[0]));
                }
                postcard.withString("NTeRQWvye18AkPd6G", rawUri.toString());
            }
            switch (routeMeta.getType()) {
                case PROVIDER: {
                    Class providerMeta = routeMeta.getDestination();
                    IProvider instance = providers.get(providerMeta);
                    if (null == instance) {
                        try {
                            IProvider provider = (IProvider)providerMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                            provider.init(mContext);
                            providers.put(providerMeta, provider);
                            instance = provider;
                        }
                        catch (Exception e) {
                            throw new HandlerException("Init provider failed! " + e.getMessage());
                        }
                    }
                    postcard.setProvider(instance);
                    postcard.greenChannel();
                    break;
                }
            }
        }
    }

    private static void setValue(Postcard postcard, Integer typeDef, String key, String value) {
        try {
            String currentKey = LogisticsCenter.getLeft(key);
            if (null != typeDef) {
                switch (typeDef) {
                    case 0: {
                        postcard.withBoolean(currentKey, Boolean.parseBoolean(value));
                        break;
                    }
                    case 1: {
                        postcard.withByte(currentKey, Byte.valueOf(value));
                        break;
                    }
                    case 2: {
                        postcard.withShort(currentKey, Short.valueOf(value));
                        break;
                    }
                    case 3: {
                        postcard.withInt(currentKey, Integer.valueOf(value));
                        break;
                    }
                    case 4: {
                        postcard.withLong(currentKey, Long.valueOf(value));
                        break;
                    }
                    case 6: {
                        postcard.withFloat(currentKey, Float.valueOf(value).floatValue());
                        break;
                    }
                    case 7: {
                        postcard.withDouble(currentKey, Double.valueOf(value));
                        break;
                    }
                    default: {
                        postcard.withString(currentKey, value);
                        break;
                    }
                }
            } else {
                postcard.withString(currentKey, value);
            }
        }
        catch (Throwable ex) {
            ARouter.logger.warning("ARouter::", "LogisticsCenter setValue failed! " + ex.getMessage());
        }
    }

    public static String getLeft(String key) {
        if (key.contains("|") && !key.endsWith("|")) {
            return key.substring(0, key.indexOf("|"));
        }
        return key;
    }

    private static String getRight(String key) {
        if (key.contains("|") && !key.startsWith("|")) {
            return key.substring(key.indexOf("|") + 1);
        }
        return key;
    }

    public static void interceptions(final Postcard postcard, final InterceptorCallback callback) throws HandlerException {
        if (CollectionUtils.isNotEmpty(interceptors)) {
            LogisticsCenter.checkInterceptorsInitStatus();
            if (!interceptorHasInit) {
                callback.onInterrupt(new HandlerException("Interceptors initialization takes too much time."));
                return;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    CancelableCountDownLatch interceptorCounter = new CancelableCountDownLatch(interceptors.size());
                    try {
                        LogisticsCenter._excute(0, interceptorCounter, postcard);
                        interceptorCounter.await(postcard.getTimeout(), TimeUnit.SECONDS);
                        if (null != postcard.getTag()) {
                            callback.onInterrupt(new HandlerException(postcard.getTag().toString()));
                        } else {
                            callback.onContinue(postcard);
                        }
                    }
                    catch (Exception e) {
                        callback.onInterrupt(e);
                    }
                }
            });
        } else {
            callback.onContinue(postcard);
        }
    }

    private static void _excute(final int index, final CancelableCountDownLatch counter, final Postcard postcard) {
        if (index < interceptors.size()) {
            IInterceptor iInterceptor = interceptors.get(index);
            iInterceptor.process(postcard, new InterceptorCallback(){

                @Override
                public void onContinue(Postcard postcard2) {
                    counter.countDown();
                    LogisticsCenter._excute(index + 1, counter, postcard2);
                }

                @Override
                public void onInterrupt(Throwable exception) {
                    postcard.setTag(null == exception ? new HandlerException("No message.") : exception.getMessage());
                    counter.cancel();
                }
            });
        }
    }

    public static void suspend() {
        routes.clear();
        groupsIndex.clear();
        providers.clear();
        providersIndex.clear();
        interceptors.clear();
        interceptorsIndex.clear();
        interceptorHasInit = false;
    }

    static {
        interceptorInitLock = new Object();
    }
}

