/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutManagerHelper;

public abstract class MarginLayoutHelper
extends LayoutHelper {
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mMarginLeft;
    protected int mMarginRight;
    protected int mMarginTop;
    protected int mMarginBottom;

    public void setPadding(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        this.mPaddingLeft = leftPadding;
        this.mPaddingRight = rightPadding;
        this.mPaddingTop = topPadding;
        this.mPaddingBottom = bottomPadding;
    }

    public void setMargin(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.mMarginLeft = leftMargin;
        this.mMarginTop = topMargin;
        this.mMarginRight = rightMargin;
        this.mMarginBottom = bottomMargin;
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        return 0;
    }

    @Override
    public int computeMarginStart(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            return this.mMarginTop;
        }
        return this.mMarginLeft;
    }

    @Override
    public int computeMarginEnd(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            return this.mMarginBottom;
        }
        return this.mMarginRight;
    }

    @Override
    public int computePaddingStart(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            return this.mPaddingTop;
        }
        return this.mPaddingLeft;
    }

    @Override
    public int computePaddingEnd(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            return this.mPaddingBottom;
        }
        return this.mPaddingRight;
    }

    public int getHorizontalMargin() {
        return this.mMarginLeft + this.mMarginRight;
    }

    public int getVerticalMargin() {
        return this.mMarginTop + this.mMarginBottom;
    }

    public int getHorizontalPadding() {
        return this.mPaddingLeft + this.mPaddingRight;
    }

    public int getVerticalPadding() {
        return this.mPaddingTop + this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getMarginLeft() {
        return this.mMarginLeft;
    }

    public int getMarginRight() {
        return this.mMarginRight;
    }

    public int getMarginTop() {
        return this.mMarginTop;
    }

    public int getMarginBottom() {
        return this.mMarginBottom;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.mPaddingLeft = paddingLeft;
    }

    public void setPaddingRight(int paddingRight) {
        this.mPaddingRight = paddingRight;
    }

    public void setPaddingTop(int paddingTop) {
        this.mPaddingTop = paddingTop;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.mPaddingBottom = paddingBottom;
    }

    public void setMarginLeft(int marginLeft) {
        this.mMarginLeft = marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this.mMarginRight = marginRight;
    }

    public void setMarginTop(int marginTop) {
        this.mMarginTop = marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this.mMarginBottom = marginBottom;
    }
}

